<?php

return [
    'seeders' => [
        'attribute' => [
            'attribute-families' => [
                'default' => '默認',
            ],

            'attribute-groups' => [
                'description'      => '描述',
                'general'          => '通用',
                'inventories'      => '庫存',
                'meta-description' => '元描述',
                'price'            => '價格',
                'settings'         => '設定',
                'shipping'         => '運送',
            ],

            'attributes' => [
                'brand'                => '品牌',
                'color'                => '顏色',
                'cost'                 => '成本',
                'description'          => '描述',
                'featured'             => '特色',
                'guest-checkout'       => '訪客結帳',
                'height'               => '高度',
                'length'               => '長度',
                'manage-stock'         => '庫存管理',
                'meta-description'     => '元描述',
                'meta-keywords'        => '元關鍵詞',
                'meta-title'           => '元標題',
                'name'                 => '名稱',
                'new'                  => '新品',
                'price'                => '價格',
                'product-number'       => '產品號',
                'short-description'    => '簡短描述',
                'size'                 => '尺寸',
                'sku'                  => 'SKU',
                'special-price'        => '特價',
                'special-price-from'   => '特價起始日期',
                'special-price-to'     => '特價結束日期',
                'status'               => '狀態',
                'tax-category'         => '稅收類別',
                'url-key'              => '網址關鍵字',
                'visible-individually' => '單獨顯示',
                'weight'               => '重量',
                'width'                => '寬度',
            ],

            'attribute-options' => [
                'black'  => '黑色',
                'green'  => '綠色',
                'l'      => 'L',
                'm'      => 'M',
                'red'    => '紅色',
                's'      => 'S',
                'white'  => '白色',
                'xl'     => 'XL',
                'yellow' => '黃色',
            ],
        ],

        'category' => [
            'categories' => [
                'description' => '根分類描述',
                'name'        => '根',
            ],
        ],

        'cms' => [
            'pages' => [
                'about-us' => [
                    'content' => '關於我們頁面內容',
                    'title'   => '關於我們',
                ],

                'contact-us' => [
                    'content' => '聯繫我們頁面內容',
                    'title'   => '聯繫我們',
                ],

                'customer-service' => [
                    'content' => '客戶服務頁面內容',
                    'title'   => '客戶服務',
                ],

                'payment-policy' => [
                    'content' => '付款政策頁面內容',
                    'title'   => '付款政策',
                ],

                'privacy-policy' => [
                    'content' => '隱私政策頁面內容',
                    'title'   => '隱私政策',
                ],

                'refund-policy' => [
                    'content' => '退款政策頁面內容',
                    'title'   => '退款政策',
                ],

                'return-policy' => [
                    'content' => '退貨政策頁面內容',
                    'title'   => '退貨政策',
                ],

                'shipping-policy' => [
                    'content' => '運送政策頁面內容',
                    'title'   => '運送政策',
                ],

                'terms-conditions' => [
                    'content' => '條款和條件頁面內容',
                    'title'   => '條款和條件',
                ],

                'terms-of-use' => [
                    'content' => '使用條款頁面內容',
                    'title'   => '使用條款',
                ],

                'whats-new' => [
                    'content' => '最新消息頁面內容',
                    'title'   => '最新消息',
                ],
            ],
        ],

        'core' => [
            'channels' => [
                'name'             => '默認',
                'meta-title'       => '演示商店',
                'meta-keywords'    => '演示商店元關鍵詞',
                'meta-description' => '演示商店元描述',
            ],

            'currencies' => [
                'AED' => '阿联酋迪拉姆',
                'ARS' => '阿根廷比索',
                'AUD' => '澳大利亚元',
                'BDT' => '孟加拉塔卡',
                'BRL' => '巴西雷亚尔',
                'CAD' => '加拿大元',
                'CHF' => '瑞士法郎',
                'CLP' => '智利比索',
                'CNY' => '人民币',
                'COP' => '哥伦比亚比索',
                'CZK' => '捷克克朗',
                'DKK' => '丹麦克朗',
                'DZD' => '阿尔及利亚第纳尔',
                'EGP' => '埃及镑',
                'EUR' => '欧元',
                'FJD' => '斐济元',
                'GBP' => '英镑',
                'HKD' => '港元',
                'HUF' => '匈牙利福林',
                'IDR' => '印尼盾',
                'ILS' => '以色列新谢克尔',
                'INR' => '印度卢比',
                'JOD' => '约旦第纳尔',
                'JPY' => '日元',
                'KRW' => '韩元',
                'KWD' => '科威特第纳尔',
                'KZT' => '哈萨克斯坦坚戈',
                'LBP' => '黎巴嫩镑',
                'LKR' => '斯里兰卡卢比',
                'LYD' => '利比亚第纳尔',
                'MAD' => '摩洛哥迪拉姆',
                'MUR' => '毛里求斯卢比',
                'MXN' => '墨西哥比索',
                'MYR' => '马来西亚林吉特',
                'NGN' => '尼日利亚奈拉',
                'NOK' => '挪威克朗',
                'NPR' => '尼泊尔卢比',
                'NZD' => '新西兰元',
                'OMR' => '阿曼里亚尔',
                'PAB' => '巴拿马巴波亚',
                'PEN' => '秘鲁新索尔',
                'PHP' => '菲律宾比索',
                'PKR' => '巴基斯坦卢比',
                'PLN' => '波兰兹罗提',
                'PYG' => '巴拉圭瓜拉尼',
                'QAR' => '卡塔尔里亚尔',
                'RON' => '罗马尼亚列伊',
                'RUB' => '俄罗斯卢布',
                'SAR' => '沙特里亚尔',
                'SEK' => '瑞典克朗',
                'SGD' => '新加坡元',
                'THB' => '泰铢',
                'TND' => '突尼斯第纳尔',
                'TRY' => '土耳其里拉',
                'TWD' => '新台币',
                'UAH' => '乌克兰格里夫纳',
                'USD' => '美元',
                'UZS' => '乌兹别克斯坦苏姆',
                'VEF' => '委内瑞拉玻利瓦尔',
                'VND' => '越南盾',
                'XAF' => '中非金融合作法郎',
                'XOF' => '西非金融合作法郎',
                'ZAR' => '南非兰特',
                'ZMW' => '赞比亚克瓦查',
            ],

            'locales' => [
                'ar'    => '阿拉伯語',
                'bn'    => '孟加拉語',
                'de'    => '德語',
                'en'    => '英語',
                'es'    => '西班牙語',
                'fa'    => '波斯語',
                'fr'    => '法語',
                'he'    => '希伯來語',
                'hi_IN' => '印度區區',
                'it'    => '意大利語',
                'ja'    => '日語',
                'nl'    => '荷蘭語',
                'pl'    => '波蘭語',
                'pt_BR' => '巴西葡萄牙語',
                'ru'    => '俄語',
                'sin'   => '僧伽羅語',
                'tr'    => '土耳其語',
                'uk'    => '烏克蘭語',
                'zh_CN' => '簡體中文',
            ],
        ],

        'customer' => [
            'customer-groups' => [
                'general'   => '普通',
                'guest'     => '訪客',
                'wholesale' => '批發',
            ],
        ],

        'inventory' => [
            'inventory-sources' => [
                'name' => '默認',
            ],
        ],

        'shop' => [
            'theme-customizations' => [
                'all-products' => [
                    'name' => '所有产品',

                    'options' => [
                        'title' => '所有产品',
                    ],
                ],

                'bold-collections' => [
                    'content' => [
                        'btn-title'   => '查看收藏',
                        'description' => '隆重推出我们大胆的新系列！通过大胆的设计和充满活力的宣言提升您的风格。探索引人注目的图案和大胆的色彩，重新定义您的衣柜。准备好拥抱非凡吧！',
                        'title'       => '准备好迎接我们全新的大胆系列吧！',
                    ],

                    'name' => '大胆系列',
                ],

                'categories-collections' => [
                    'name' => '类别 收藏',
                ],

                'featured-collections' => [
                    'name' => '特色收藏',

                    'options' => [
                        'title' => '特色产品',
                    ],
                ],

                'footer-links' => [
                    'name' => '页脚链接',

                    'options' => [
                        'about-us'         => '关于我们',
                        'contact-us'       => '联系我们',
                        'customer-service' => '客户服务',
                        'payment-policy'   => '付款政策',
                        'privacy-policy'   => '隐私政策',
                        'refund-policy'    => '退款政策',
                        'return-policy'    => '退货政策',
                        'shipping-policy'  => '运输政策',
                        'terms-conditions' => '条款及条件',
                        'terms-of-use'     => '使用条款',
                        'whats-new'        => '什么是新的',
                    ],
                ],

                'game-container' => [
                    'content' => [
                        'sub-title-1' => '我们的系列',
                        'sub-title-2' => '我们的系列',
                        'title'       => '游戏新增了我们的新内容！',
                    ],

                    'name' => '游戏容器',
                ],

                'image-carousel' => [
                    'name' => '图像轮播',

                    'sliders' => [
                        'title' => '为新系列做好准备',
                    ],
                ],

                'new-products' => [
                    'name' => '新产品',

                    'options' => [
                        'title' => '新产品',
                    ],
                ],

                'offer-information' => [
                    'content' => [
                        'title' => '第一份订单可享受高达 40% 的折扣 现在购买',
                    ],

                    'name' => '优惠资讯',
                ],

                'services-content' => [
                    'description' => [
                        'emi-available-info'   => '所有主要信用卡均可免费使用 EMI',
                        'free-shipping-info'   => '所有订单均可享受免费送货',
                        'product-replace-info' => '可轻松更换产品！',
                        'time-support-info'    => '专门的 24/7 支持，通过聊天和电子邮件提供',
                    ],

                    'name' => '服务内容',

                    'title' => [
                        'emi-available'   => 'EMI 可用',
                        'free-shipping'   => '免费送货',
                        'product-replace' => '产品更换',
                        'time-support'    => '24/7 支持',
                    ],
                ],

                'top-collections'        => [
                    'content' => [
                        'sub-title-1' => '我们的系列',
                        'sub-title-2' => '我们的系列',
                        'sub-title-3' => '我们的系列',
                        'sub-title-4' => '我们的系列',
                        'sub-title-5' => '我们的系列',
                        'sub-title-6' => '我们的系列',
                        'title'       => '游戏新增了我们的新内容！',
                    ],

                    'name' => '热门收藏',
                ],
            ],
        ],

        'user' => [
            'roles' => [
                'description' => '该角色用户将拥有所有访问权限',
                'name'        => '行政人员',
            ],

            'users' => [
                'name' => '例子',
            ],
        ],

        'sample-categories' => [
            'category-translation' => [
                '2' => [
                    'description'      => '男士类别描述',
                    'meta-description' => '男士类别元描述',
                    'meta-keywords'    => '男士类别元关键词',
                    'meta-title'       => '男士类别元标题',
                    'name'             => '男士',
                    'slug'             => '男人',
                ],

                '3' => [
                    'description'      => '冬季服装类别描述',
                    'meta-description' => '冬季服装类别元描述',
                    'meta-keywords'    => '冬季服装类别元关键词',
                    'meta-title'       => '冬季服装类别元标题',
                    'name'             => '冬装',
                    'slug'             => '冬装',
                ],
            ],
        ],

        'sample-products' => [
            'product-flat' => [
                '1' => [
                    'description'       => 'Arctic Cozy Knit Unisex Beanie的Arctic Cozy Knit Beanie是您在寒冷的月份保持温暖，舒适和时尚的解决方案。采用柔软耐用的丙烯酸针织混纺材料制成，这款帽子设计为提供舒适贴合的贴合度。经典设计使其适用于男性和女性，提供了一款适合各种风格的多功能配饰。无论您是在城市休闲日还是迎接大自然，这款帽子都为您的装束增添了一丝舒适和温暖。柔软透气的材料确保您在不牺牲风格的情况下保持舒适。Arctic Cozy Knit Beanie不仅仅是一个配饰;它是冬季时尚的表达。它的简约设计使其易于与不同的服装搭配，使其成为您冬季衣橱中的必备品。这款帽子是送礼或者给自己的一种体贴的选择，是任何冬季装束的必备品。它是一款多功能的配饰，不仅具有功能性，还为您的外观增添了一丝温暖和时尚。用Arctic Cozy Knit Beanie拥抱冬天的精髓。无论您是享受休闲的一天还是面对恶劣天气，让这款帽子成为您舒适和时尚的伴侣。用这款经典配饰提升您的冬季衣橱，将温暖与永恒的时尚感无缝结合起来。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '北极舒适针织无性别帽子',
                    'short-description' => '用我们的北极舒适针织帽子时尚地拥抱寒冷的日子。这款帽子采用柔软耐用的丙烯酸混纺材料制成，提供温暖和多功能性。适合男女，是休闲或户外穿着的理想配饰。提升您的冬季衣橱或为特别的人提供这款必备的帽子。',
                ],

                '2' => [
                    'description'       => 'Arctic Bliss Stylish Winter Scarf不仅仅是一款寒冷天气的配饰;它是冬季温暖，舒适和时尚的表达。精心制作的丙烯酸和羊毛混纺材料，这款围巾设计为在最寒冷的温度下保持您温暖和舒适。柔软而豪华的质地不仅提供了对抗寒冷的保温功能，还为您的冬季衣橱增添了一丝奢华。Arctic Bliss Winter Scarf的设计既时尚又多功能，使其成为各种冬季服装的完美搭配。无论您是为特殊场合打扮还是为日常造型增添时尚层次，这款围巾都能轻松衬托您的风格。围巾的超长长度提供了可定制的造型选择。将其缠绕在身上增加保暖，松散地披在身上增添休闲感，或者尝试不同的打结方式来展现您独特的风格。这种多功能性使其成为冬季必备的配饰。寻找完美的礼物？Arctic Bliss Winter Scarf是理想的选择。无论您是给亲人一个惊喜还是给自己一个美好的礼物，这款围巾是一份永恒而实用的礼物，将在整个冬季受到珍视。用Arctic Bliss Winter Scarf拥抱冬天，温暖与风格完美融合。用这款必备的配饰提升您的冬季衣橱，不仅保持温暖，还增添了一丝优雅。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '北极幸福时尚冬季围巾',
                    'short-description' => '用我们的北极幸福冬季围巾体验温暖和风格的拥抱。这款围巾采用丙烯酸和羊毛混纺材料制成，舒适温暖，适合寒冷天气。时尚多功能的设计，加上超长长度，提供了多种造型选择。提升您的冬季衣橱或为特别的人提供这款必备的冬季配饰。',
                ],

                '3' => [
                    'description'       => '介绍北极触摸屏冬季手套-在这里，温暖，风格和连接性相遇，增强您的冬季体验。这款手套采用高品质的丙烯酸制成，旨在提供卓越的温暖和耐用性。触摸屏兼容的指尖使您可以在不暴露手部于寒冷的情况下保持连接。接听电话，发送消息和轻松导航您的设备，同时保持双手温暖。绝缘内衬增加了额外的舒适感，使这些手套成为您应对冬季寒冷的理想选择。无论您是通勤，办理差事还是享受户外活动，这些手套都提供所需的温暖和保护。弹性袖口确保安全贴合，防止寒冷气流，并在日常活动中保持手套的位置。时尚的设计为您的冬季装束增添了一丝风采，使这些手套既时尚又实用。作为送礼或者给自己的一种体贴的选择，北极触摸屏冬季手套是现代人的必备配饰。告别摘下手套使用设备的不便，拥抱温暖，风格和连接性的无缝融合。用北极触摸屏冬季手套保持连接，保持温暖，保持时尚-您在冬季季节中的可靠伴侣。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '北极触摸屏冬季手套',
                    'short-description' => '用我们的北极触摸屏冬季手套保持连接和温暖。这些手套不仅采用高品质的丙烯酸制成，以保持温暖和耐用性，而且还具有触摸屏兼容的设计。配有绝缘内衬，弹性袖口以确保安全贴合，并具有时尚外观，这些手套非常适合在寒冷条件下日常穿着。',
                ],

                '4' => [
                    'description'       => '介绍北极温暖羊毛混纺袜子-在寒冷的季节，它是您舒适和温暖的必备伴侣。这款袜子采用优质的美利奴羊毛，丙烯酸，尼龙和氨纶混纺材料制成，旨在提供无与伦比的温暖和舒适。羊毛混纺确保即使在最寒冷的温度下，您的双脚也能保持温暖，使这款袜子成为冬季冒险或在家中保持舒适的理想选择。袜子的柔软舒适质地为您的皮肤提供奢华的触感。告别寒冷的双脚，享受这款羊毛混纺袜子提供的豪华温暖。袜子采用耐磨的设计，带有加固的鞋跟和脚趾，为高磨损区域增加了额外的强度。这确保您的袜子经受住时间的考验，提供持久的舒适和温暖。材料的透气性防止过热，使您的双脚在一整天中保持舒适和干燥。无论您是去户外远足还是在室内放松，这些袜子提供了温暖和透气性的完美平衡。这款羊毛混纺袜子既多功能又时尚，适合各种场合。与您最喜欢的靴子搭配，打造时尚的冬季造型，或者在家中穿着，享受终极舒适。提升您的冬季衣橱，优先考虑舒适性，选择北极温暖羊毛混纺袜子。给您的双脚提供应得的奢华，踏入一个持续整个季节的舒适世界。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '北极温暖羊毛混纺袜子',
                    'short-description' => '体验我们的北极温暖羊毛混纺袜子的无与伦比的温暖和舒适。这些袜子采用美利奴羊毛，丙烯酸，尼龙和氨纶混纺材料制成，为寒冷天气提供了终极舒适。具有加固的鞋跟和脚趾以增加耐用性，这些多功能时尚袜子非常适合各种场合。',
                ],

                '5' => [
                    'description'       => '介绍北极霜冬季配饰套装，您在寒冷的冬季日子里保持温暖，时尚和连接的解决方案。这个经过精心策划的套装将四个必备的冬季配饰融合在一起，打造出一个和谐的整体。豪华围巾采用丙烯酸和羊毛编织而成，不仅增加了一层温暖，还为您的冬季衣橱增添了一丝优雅。精心制作的软针织帽子承诺让您保持舒适，同时增添时尚风格。但事情并不止于此-我们的套装还包括触摸屏兼容的手套。在保持温暖的同时保持连接，轻松导航您的设备。无论您是接听电话，发送消息还是在智能手机上捕捉冬季时刻，这些手套都确保方便而不妥协风格。袜子的柔软舒适质地为您的皮肤提供奢华的触感。告别寒冷的双脚，享受这款羊毛混纺袜子提供的豪华温暖。北极霜冬季配饰套装不仅仅是功能性的;它是冬季时尚的表达。每件配件都不仅旨在保护您免受寒冷的侵袭，还旨在提升您在寒冷季节的风格。为此套装选择的材料既注重耐用性又注重舒适性，确保您可以以时尚的方式享受冬季乐园。无论您是为自己寻找完美的礼物还是为了提升自己的冬季衣橱，北极霜冬季配饰套装都是一个多功能的选择。在假日季节中让特殊的人感到愉悦，或者用这个时尚而实用的整套装备提升自己的冬季衣橱。自信地拥抱寒冷，知道您拥有完美的配饰来保持温暖和时尚。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '北极霜冬季配饰',
                    'short-description' => '用我们的北极霜冬季配饰套装拥抱冬天的寒冷。这个精心策划的套装包括豪华围巾，舒适的帽子，触摸屏兼容的手套和羊毛混纺袜子。时尚而实用，这个整套装备采用高品质材料制成，确保耐用性和舒适性。提升您的冬季衣橱或为特别的人提供这个完美的礼物选择。',
                ],

                '6' => [
                    'description'       => '介绍北极霜冬季配件套装，您在寒冷的冬天保持温暖、时尚和连接的解决方案。这个精心策划的套装将四个必备的冬季配件融合在一起，打造出一个和谐的整体。豪华的围巾由丙烯酸纤维和羊毛混纺编织而成，不仅增加了一层温暖，还为您的冬季衣橱增添了一丝优雅。柔软的针织帽子精心制作，保证让您感到舒适，同时为您的造型增添时尚的风格。但这还不是全部 - 我们的套装还包括触摸屏兼容手套。在不牺牲温暖的情况下保持连接，轻松操作您的设备。无论您是接听电话、发送短信还是在智能手机上捕捉冬季时刻，这些手套都能确保方便，而不会牺牲风格。袜子的柔软和舒适质地为您的皮肤提供奢华的触感。通过这些羊毛混纺袜子提供的丰盈温暖，告别寒冷的脚丫。北极霜冬季配件套装不仅仅是功能性的；它是冬季时尚的表达。每一件都不仅能保护您免受寒冷的侵袭，还能提升您在寒冷季节的风格。为这个套装选择的材料既注重耐用性又注重舒适性，确保您可以以时尚的方式享受冬季仙境。无论是为自己购买还是寻找完美的礼物，北极霜冬季配件套装都是一个多功能的选择。在假日季节让特别的人感到愉悦，或者用这个时尚而实用的套装提升自己的冬季衣橱。怀着自信迎接寒冷，因为您拥有完美的配件来保持温暖和时尚。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '北极霜冬季配件套装',
                    'short-description' => '拥抱冬季寒冷，我们的北极霜冬季配件套装让您保持温暖。这个精心策划的套装包括豪华的围巾、舒适的针织帽子、触摸屏兼容手套和羊毛混纺袜子。时尚而实用，这个套装采用高质量的材料制成，确保耐用性和舒适性。提升您的冬季衣橱或用这个完美的礼物让特别的人感到愉悦。',
                ],

                '7' => [
                    'description'       => '介绍奥尼热男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款夹克以耐用性和保暖性为设计理念，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供额外的保暖，为您抵御寒冷的风和天气。全袖设计提供全面的覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服提供方便，可携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，使其非常适合对抗寒冷的白天和夜晚。这款夹克采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种环境的考验。有5种吸引人的颜色可供选择，您可以选择适合您的风格和喜好的颜色。奥尼热男士纯色连帽羽绒服既多功能又实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验时尚、舒适和功能完美融合的奥尼热男士纯色连帽羽绒服。提升您的冬季衣橱，在拥抱户外活动时保持舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '奥尼热男士纯色连帽羽绒服',
                    'short-description' => '拥抱冬季寒冷，我们的奥尼热男士纯色连帽羽绒服让您保持温暖和时尚。这款夹克设计精良，提供极致保暖，并配有插袋，方便实用。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '8' => [
                    'description'       => '介绍奥尼热男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款夹克以耐用性和保暖性为设计理念，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供额外的保暖，为您抵御寒冷的风和天气。全袖设计提供全面的覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服提供方便，可携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，使其非常适合对抗寒冷的白天和夜晚。这款夹克采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种环境的考验。有5种吸引人的颜色可供选择，您可以选择适合您的风格和喜好的颜色。奥尼热男士纯色连帽羽绒服既多功能又实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验时尚、舒适和功能完美融合的奥尼热男士纯色连帽羽绒服。提升您的冬季衣橱，在拥抱户外活动时保持舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '奥尼热男士纯色连帽羽绒服-蓝色-黄色-M',
                    'short-description' => '拥抱冬季寒冷，我们的奥尼热男士纯色连帽羽绒服让您保持温暖和时尚。这款夹克设计精良，提供极致保暖，并配有插袋，方便实用。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '9' => [
                    'description'       => '介绍奥尼热男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款夹克以耐用性和保暖性为设计理念，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供额外的保暖，为您抵御寒冷的风和天气。全袖设计提供全面的覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服提供方便，可携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，使其非常适合对抗寒冷的白天和夜晚。这款夹克采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种环境的考验。有5种吸引人的颜色可供选择，您可以选择适合您的风格和喜好的颜色。奥尼热男士纯色连帽羽绒服既多功能又实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验时尚、舒适和功能完美融合的奥尼热男士纯色连帽羽绒服。提升您的冬季衣橱，在拥抱户外活动时保持舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '奥尼热男士纯色连帽羽绒服-蓝色-黄色-L',
                    'short-description' => '拥抱冬季寒冷，我们的奥尼热男士纯色连帽羽绒服让您保持温暖和时尚。这款夹克设计精良，提供极致保暖，并配有插袋，方便实用。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '10' => [
                    'description'       => '介绍奥尼热男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款夹克以耐用性和保暖性为设计理念，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供额外的保暖，为您抵御寒冷的风和天气。全袖设计提供全面的覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服提供方便，可携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，使其非常适合对抗寒冷的白天和夜晚。这款夹克采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种环境的考验。有5种吸引人的颜色可供选择，您可以选择适合您的风格和喜好的颜色。奥尼热男士纯色连帽羽绒服既多功能又实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验时尚、舒适和功能完美融合的奥尼热男士纯色连帽羽绒服。提升您的冬季衣橱，在拥抱户外活动时保持舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '奥尼热男士纯色连帽羽绒服-蓝色-绿色-M',
                    'short-description' => '拥抱冬季寒冷，我们的奥尼热男士纯色连帽羽绒服让您保持温暖和时尚。这款夹克设计精良，提供极致保暖，并配有插袋，方便实用。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '11' => [
                    'description'       => '介绍奥尼热男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款夹克以耐用性和保暖性为设计理念，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供额外的保暖，为您抵御寒冷的风和天气。全袖设计提供全面的覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服提供方便，可携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，使其非常适合对抗寒冷的白天和夜晚。这款夹克采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种环境的考验。有5种吸引人的颜色可供选择，您可以选择适合您的风格和喜好的颜色。奥尼热男士纯色连帽羽绒服既多功能又实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验时尚、舒适和功能完美融合的奥尼热男士纯色连帽羽绒服。提升您的冬季衣橱，在拥抱户外活动时保持舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description'  => '元描述',
                    'meta-keywords'     => '元1，元2，元3',
                    'meta-title'        => '元标题',
                    'name'              => '奥尼热男士纯色连帽羽绒服-蓝色-绿色-L',
                    'short-description' => '拥抱冬季寒冷，我们的奥尼热男士纯色连帽羽绒服让您保持温暖和时尚。这款夹克设计精良，提供极致保暖，并配有插袋，方便实用。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],
            ],

            'product-attribute-values' => [
                '1' => [
                    'description'      => '北极舒适针织无性别针织帽是您在寒冷月份保持温暖、舒适和时尚的首选解决方案。由柔软耐用的丙烯酸纤维混纺制成，这款针织帽设计舒适贴合。经典设计使其适合男女，提供了一款适用于各种风格的多功能配饰。无论您是在城市闲逛还是享受户外活动，这款帽子都能为您的装束增添一丝舒适和温暖。柔软透气的材质确保您在不牺牲风格的情况下保持舒适。北极舒适针织无性别针织帽不仅仅是一个配饰，它是冬季时尚的象征。它的简约设计使其易于搭配不同的服装，成为您冬季衣橱中的必备单品。这款帽子是送礼或者给自己的一份特别的礼物，是任何冬季装束的体贴补充。它是一款多功能的配饰，不仅具有功能性，还能为您的外观增添一丝温暖和时尚感。用北极舒适针织无性别针织帽感受冬季的精髓。无论您是享受休闲的一天还是面对恶劣天气，让这款帽子成为您舒适和时尚的伴侣。用这款经典配饰提升您的冬季衣橱，将温暖与永恒的时尚感完美结合起来。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => '北极舒适针织无性别帽子',
                    'sort-description' => '用我们的北极舒适针织帽子时尚地拥抱寒冷的日子。由柔软耐用的丙烯酸纤维混纺制成的这款经典帽子提供温暖和多功能性。适合男女，是休闲或户外穿着的理想配饰。用这款必备的帽子提升您的冬季衣橱或者给特别的人带来惊喜。',
                ],

                '2' => [
                    'description'      => '北极幸福冬季围巾不仅仅是一款防寒配饰；它是冬季季节温暖、舒适和时尚的象征。精心制作的这款围巾采用丙烯酸纤维和羊毛的豪华混纺材料，旨在在最寒冷的温度下保持您温暖和舒适。柔软而豪华的质地不仅提供了对抗寒冷的保温功能，还为您的冬季衣橱增添了一丝奢华感。北极幸福冬季围巾的设计既时尚又多功能，使其成为各种冬季服装的完美搭配。无论您是为特殊场合打扮还是为日常造型增添时尚层次，这款围巾都能轻松衬托您的风格。围巾的超长长度提供了多种可定制的造型选择。将其缠绕在身上增加保暖，松散地披在身上展现休闲的外观，或者尝试不同的打结方式展现您独特的风格。这种多功能性使其成为冬季季节必备的配饰。寻找完美的礼物？北极幸福冬季围巾是理想的选择。无论是给亲人一个惊喜还是给自己一个美好的礼物，这款围巾是一个永恒而实用的礼物，在整个冬季都会被珍视。用北极幸福冬季围巾拥抱冬天，温暖与时尚完美融合。用这款必备配饰提升您的冬季衣橱，不仅保持温暖，还增添一丝优雅。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => '北极幸福时尚冬季围巾',
                    'sort-description' => '用我们的北极幸福冬季围巾时尚地拥抱寒冷的日子。由丙烯酸纤维和羊毛精心制作的这款舒适围巾既保暖又多功能。其时尚多功能的设计，加上超长长度，提供了多种造型选择。用这款冬季必备配饰提升您的冬季衣橱或者给特别的人带来惊喜。',
                ],

                '3' => [
                    'description'      => '介绍北极触屏冬季手套-在这里，温暖、时尚和连接性相遇，提升您的冬季体验。这款手套采用高品质的丙烯酸纤维制成，旨在提供卓越的温暖和耐用性。触屏兼容的指尖设计使您可以在不暴露手部于寒冷的情况下保持连接。接听电话、发送信息和轻松导航您的设备，同时保持双手温暖。绝缘内衬增加了额外的舒适感，使这些手套成为您应对冬季寒冷的理想选择。无论您是通勤、办事还是享受户外活动，这些手套都能为您提供所需的温暖和保护。弹性袖口确保紧密贴合，防止寒冷气流，使手套在日常活动中保持位置稳定。时尚的设计为您的冬季装束增添一丝风采，使这些手套既时尚又实用。作为送礼或者给自己的一份特别的礼物，北极触屏冬季手套是现代人的必备配饰。告别摘下手套使用设备的不便，拥抱温暖、时尚和连接性的无缝融合。用北极触屏冬季手套保持连接、保持温暖、保持时尚-您在冬季季节中的可靠伴侣。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => '北极触屏冬季手套',
                    'sort-description' => '用我们的北极触屏冬季手套保持连接和温暖。这些手套不仅由高品质的丙烯酸纤维制成，还具有触屏兼容的设计。内衬绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '4' => [
                    'description'      => '介绍北极温暖羊毛混纺袜子-在寒冷季节，您舒适温暖的脚部必备伴侣。这款袜子采用优质的美丽诺羊毛、丙烯酸纤维、尼龙和氨纶混纺材料制成，旨在提供无与伦比的温暖和舒适。羊毛混纺材料确保即使在最寒冷的温度下，您的双脚也能保持温暖，使这款袜子成为冬季冒险或在家保持舒适的理想选择。袜子柔软舒适的质地为您的皮肤提供奢华的触感。告别寒冷的脚部，享受这款羊毛混纺袜子提供的豪华温暖。袜子采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种天气的考验。有透气性的材料防止过热，使您的双脚在一整天中保持舒适和干燥。无论您是去户外远足还是在家休息，这些袜子提供了温暖和透气性的完美平衡。这款羊毛混纺袜子既多功能又时尚，适合各种场合。与您最喜欢的靴子搭配，打造时尚的冬季造型，或者在家穿着，享受极致舒适。用北极温暖羊毛混纺袜子提升您的冬季衣橱，优先考虑舒适。给您的双脚带来应得的奢华，踏入一个持续整个季节的舒适世界。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => '北极温暖羊毛混纺袜子',
                    'sort-description' => '体验我们的北极温暖羊毛混纺袜子的无与伦比的温暖和舒适。这款袜子采用美丽诺羊毛、丙烯酸纤维、尼龙和氨纶混纺材料制成，为寒冷天气提供了终极舒适感。耐用的鞋跟和脚趾部位增加了额外的强度。这确保您的袜子经受住时间的考验，提供持久的舒适和温暖。材料透气性防止过热，使您的双脚在一整天中保持舒适和干燥。无论您是去户外远足还是在家休息，这些袜子提供了温暖和透气性的完美平衡。这款羊毛混纺袜子多功能且时尚，适合各种场合。',
                ],

                '5' => [
                    'description'      => '介绍北极霜冬季配饰套装，您在寒冷的冬季日子里保持温暖、时尚和连接的首选解决方案。这个经过精心策划的套装将四个必备的冬季配饰融合在一起，打造出一个和谐的整体。豪华围巾采用丙烯酸纤维和羊毛编织而成，不仅增加了一层温暖，还为您的冬季衣橱增添了一丝优雅。精心制作的软针织帽子保证让您保持舒适，同时增添时尚风格。但这还不止于此-我们的套装还包括触屏兼容手套。在保持温暖的同时保持连接，轻松操作您的设备。无论您是接听电话、发送信息还是在智能手机上记录冬季时刻，这些手套都能保证方便，而不会影响您的风格。袜子柔软舒适的质地为您的皮肤提供奢华的触感。告别寒冷的脚部，享受这款羊毛混纺袜子提供的豪华温暖。北极霜冬季配饰套装不仅仅是功能性的；它是冬季时尚的象征。每件配饰都不仅旨在保护您免受寒冷的侵袭，还旨在提升您在寒冷季节的风格。为这个套装选择的材料既注重耐用性又注重舒适性，确保您可以以时尚的方式享受冬季乐园。无论是给自己一个美好的礼物还是寻找完美的礼物，北极霜冬季配饰套装都是一个多功能的选择。在假日季节让特殊的人感到愉悦，或者用这个时尚而实用的套装提升您自己的冬季衣橱。自信地拥抱寒冷，因为您拥有完美的配饰来保持温暖和时尚。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => '北极霜冬季配饰套装',
                    'sort-description' => '拥抱冬季寒冷，选择我们的北极霜冬季配饰套装。这个精心策划的套装包括豪华围巾、舒适的针织帽、触屏兼容手套和羊毛混纺袜子。时尚而实用，这个套装采用高品质材料制成，既耐用又舒适。提升您的冬季衣橱，或者给特别的人带来惊喜，这是一个完美的礼物选择。',
                ],

                '6' => [
                    'description'      => '介绍北极霜冬季配饰套装，这是您在寒冷的冬天保持温暖、时尚和连接的首选解决方案。这个精心策划的套装将四种必备的冬季配饰融合在一起，打造出一个和谐的整体。豪华围巾采用丙烯酸纤维和羊毛混纺编织而成，不仅增加了一层温暖，还为您的冬季衣橱增添了一丝优雅。柔软的针织帽经过精心制作，保证让您感到舒适，同时为您的造型增添时尚风格。但这还不止于此 - 我们的套装还包括触屏兼容手套。在保持温暖的同时，轻松操作您的设备，保持连接。无论是接听电话、发送短信还是在智能手机上捕捉冬季时刻，这些手套都能确保方便，而不会牺牲风格。袜子的柔软和舒适质地给您的皮肤带来奢华的感觉。通过这款羊毛混纺袜子提供的豪华温暖，告别寒冷的双脚。北极霜冬季配饰套装不仅仅是功能性的，它还是冬季时尚的代表。每一件配饰都不仅能保护您免受寒冷的侵袭，还能提升您在寒冷季节的风格。为这个套装选择的材料既注重耐用性又注重舒适性，确保您可以以时尚的方式享受冬季的美妙。无论是为自己购买还是寻找完美的礼物，北极霜冬季配饰套装都是一个多功能的选择。在假日季节让某个特别的人感到愉悦，或者用这个时尚而实用的套装提升自己的冬季衣橱。自信地拥抱寒冷，因为您拥有完美的配饰来保持温暖和时尚。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => '北极霜冬季配饰套装',
                    'sort-description' => '拥抱冬季寒冷，选择我们的北极霜冬季配饰套装。这个精心策划的套装包括豪华围巾、舒适的针织帽、触屏兼容手套和羊毛混纺袜子。时尚而实用，这个套装采用高品质材料制成，既耐用又舒适。提升您的冬季衣橱，或者给特别的人带来惊喜，这是一个完美的礼物选择。',
                ],

                '7' => [
                    'description'      => '介绍OmniHeat男士纯色连帽羽绒服，这是您在寒冷季节保持温暖和时尚的首选解决方案。这款羽绒服注重耐用性和保暖性，确保成为您值得信赖的伙伴。连帽设计不仅增添了一丝风格，还提供了额外的保暖，使您免受寒冷的侵袭。全袖设计提供全面的覆盖，确保您从肩膀到手腕都能感到舒适。配备插袋，这款羽绒服方便携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，使其成为对抗寒冷的日夜的理想选择。这款羽绒服采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种天气的考验。有5种吸引人的颜色可供选择，您可以选择适合自己风格和喜好的颜色。OmniHeat男士纯色连帽羽绒服既多功能又实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验OmniHeat男士纯色连帽羽绒服的完美融合时尚、舒适和功能性。提升您的冬季衣橱，在拥抱户外的同时保持舒适。以时尚的方式抵御寒冷，用这款必备单品展示自己。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => 'OmniHeat男士纯色连帽羽绒服',
                    'sort-description' => '用我们的OmniHeat男士纯色连帽羽绒服保持温暖和时尚。这款羽绒服旨在提供终极保暖，并配有插袋，方便携带。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '8' => [
                    'description'      => '介绍OmniHeat男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款羽绒服注重耐用性和保暖性，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供了额外的保暖，保护您免受寒冷的风和天气的侵扰。全袖设计提供全面覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服方便携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，非常适合对抗寒冷的白天和夜晚。这款羽绒服采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种天气的考验。有5种吸引人的颜色可供选择，您可以选择适合您风格和喜好的颜色。OmniHeat男士纯色连帽羽绒服多功能而实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验OmniHeat男士纯色连帽羽绒服的时尚、舒适和功能的完美结合。提升您的冬季衣橱，享受户外活动时的舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => 'OmniHeat男士纯色连帽羽绒服-蓝色-黄色-M',
                    'sort-description' => '用我们的OmniHeat男士纯色连帽羽绒服保持温暖和时尚。这款羽绒服旨在提供终极保暖，并配有插袋，方便携带。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '9' => [
                    'description'      => '介绍OmniHeat男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款羽绒服注重耐用性和保暖性，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供了额外的保暖，保护您免受寒冷的风和天气的侵扰。全袖设计提供全面覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服方便携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，非常适合对抗寒冷的白天和夜晚。这款羽绒服采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种天气的考验。有5种吸引人的颜色可供选择，您可以选择适合您风格和喜好的颜色。OmniHeat男士纯色连帽羽绒服多功能而实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验OmniHeat男士纯色连帽羽绒服的时尚、舒适和功能的完美结合。提升您的冬季衣橱，享受户外活动时的舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => 'OmniHeat男士纯色连帽羽绒服-蓝色-黄色-L',
                    'sort-description' => '用我们的OmniHeat男士纯色连帽羽绒服保持温暖和时尚。这款羽绒服旨在提供终极保暖，并配有插袋，方便携带。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '10' => [
                    'description'      => '介绍OmniHeat男士纯色连帽羽绒服，您在寒冷季节保持温暖和时尚的首选解决方案。这款羽绒服注重耐用性和保暖性，确保成为您值得信赖的伙伴。连帽设计不仅增添了时尚感，还提供了额外的保暖，保护您免受寒冷的风和天气的侵扰。全袖设计提供全面覆盖，确保您从肩膀到手腕都保持舒适。配有插袋，这款羽绒服方便携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，非常适合对抗寒冷的白天和夜晚。这款羽绒服采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种天气的考验。有5种吸引人的颜色可供选择，您可以选择适合您风格和喜好的颜色。OmniHeat男士纯色连帽羽绒服多功能而实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验OmniHeat男士纯色连帽羽绒服的时尚、舒适和功能的完美结合。提升您的冬季衣橱，享受户外活动时的舒适。以时尚的方式抵御寒冷，展示您的个性。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => 'OmniHeat男士纯色连帽羽绒服-蓝色-绿色-M',
                    'sort-description' => '用我们的OmniHeat男士纯色连帽羽绒服保持温暖和时尚。这款羽绒服旨在提供终极保暖，并配有插袋，方便携带。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],

                '11' => [
                    'description'      => '介绍OmniHeat男士纯色连帽羽绒服，这是您在寒冷季节保持温暖和时尚的首选解决方案。这款羽绒服注重耐用性和保暖性，确保成为您值得信赖的伙伴。连帽设计不仅增添了一丝风格，还提供了额外的保暖，使您免受寒冷的侵袭。全袖设计提供全面的覆盖，确保您从肩膀到手腕都能感到舒适。配备插袋，这款羽绒服方便携带必需品或保持双手温暖。绝缘合成填充物提供增强的保暖性，使其成为对抗寒冷的日夜的理想选择。这款羽绒服采用耐用的聚酯纤维外壳和内衬制成，经久耐用，经受住各种天气的考验。有5种吸引人的颜色可供选择，您可以选择适合自己风格和喜好的颜色。OmniHeat男士纯色连帽羽绒服既多功能又实用，适合各种场合，无论是上班、休闲外出还是参加户外活动。体验OmniHeat男士纯色连帽羽绒服的完美融合时尚、舒适和功能性。提升您的冬季衣橱，在拥抱户外的同时保持舒适。以时尚的方式抵御寒冷，用这款必备单品展示自己。',
                    'meta-description' => '元描述',
                    'meta-keywords'    => '元1，元2，元3',
                    'meta-title'       => '元标题',
                    'name'             => 'OmniHeat男士纯色连帽羽绒服-蓝色-绿色-L',
                    'sort-description' => '用我们的OmniHeat男士纯色连帽羽绒服保持温暖和时尚。这款羽绒服旨在提供终极保暖，并配有插袋，方便携带。绝缘材料确保您在寒冷天气中保持舒适。有5种吸引人的颜色可供选择，使其成为各种场合的多功能选择。',
                ],
            ],

            'product-bundle-option-translations' => [
                '1' => [
                    'label' => '捆绑选项 1',
                ],

                '2' => [
                    'label' => '捆绑选项 1',
                ],

                '3' => [
                    'label' => '捆绑选项 2',
                ],

                '4' => [
                    'label' => '捆绑选项 2',
                ],
            ],
        ],
    ],

    'installer' => [
        'index' => [
            'create-administrator' => [
                'admin'            => '管理员',
                'bagisto'          => 'Bagisto',
                'confirm-password' => '确认密码',
                'email'            => '电子邮件',
                'email-address'    => 'admin@example.com',
                'password'         => '密码',
                'title'            => '创建管理员',
            ],

            'environment-configuration' => [
                'algerian-dinar'              => '阿尔及利亚第纳尔 (DZD)',
                'allowed-currencies'          => '允许的货币',
                'allowed-locales'             => '允许的语言环境',
                'application-name'            => '应用程序名称',
                'argentine-peso'              => '阿根廷比索 (ARS)',
                'australian-dollar'           => '澳大利亚元 (AUD)',
                'bagisto'                     => 'Bagisto',
                'bangladeshi-taka'            => '孟加拉塔卡 (BDT)',
                'brazilian-real'              => '巴西雷亚尔 (BRL)',
                'british-pound-sterling'      => '英镑 (GBP)',
                'canadian-dollar'             => '加拿大元 (CAD)',
                'cfa-franc-bceao'             => 'CFA 法郎 BCEAO (XOF)',
                'cfa-franc-beac'              => 'CFA 法郎 BEAC (XAF)',
                'chilean-peso'                => '智利比索 (CLP)',
                'chinese-yuan'                => '人民币 (CNY)',
                'colombian-peso'              => '哥伦比亚比索 (COP)',
                'czech-koruna'                => '捷克克朗 (CZK)',
                'danish-krone'                => '丹麦克朗 (DKK)',
                'database-connection'         => '数据库连接',
                'database-hostname'           => '数据库主机名',
                'database-name'               => '数据库名称',
                'database-password'           => '数据库密码',
                'database-port'               => '数据库端口',
                'database-prefix'             => '数据库前缀',
                'database-username'           => '数据库用户名',
                'default-currency'            => '默认货币',
                'default-locale'              => '默认语言环境',
                'default-timezone'            => '默认时区',
                'default-url'                 => '默认网址',
                'default-url-link'            => 'https://localhost',
                'egyptian-pound'              => '埃及镑 (EGP)',
                'euro'                        => '欧元 (EUR)',
                'fijian-dollar'               => '斐济元 (FJD)',
                'hong-kong-dollar'            => '港元 (HKD)',
                'hungarian-forint'            => '匈牙利福林 (HUF)',
                'indian-rupee'                => '印度卢比 (INR)',
                'indonesian-rupiah'           => '印度尼西亚盾 (IDR)',
                'israeli-new-shekel'          => '以色列新谢克尔 (ILS)',
                'japanese-yen'                => '日元 (JPY)',
                'jordanian-dinar'             => '约旦第纳尔 (JOD)',
                'kazakhstani-tenge'           => '哈萨克斯坦坚戈 (KZT)',
                'kuwaiti-dinar'               => '科威特第纳尔 (KWD)',
                'lebanese-pound'              => '黎巴嫩镑 (LBP)',
                'libyan-dinar'                => '利比亚第纳尔 (LYD)',
                'malaysian-ringgit'           => '马来西亚林吉特 (MYR)',
                'mauritian-rupee'             => '毛里求斯卢比 (MUR)',
                'mexican-peso'                => '墨西哥比索 (MXN)',
                'moroccan-dirham'             => '摩洛哥迪拉姆 (MAD)',
                'mysql'                       => 'MySQL',
                'nepalese-rupee'              => '尼泊尔卢比 (NPR)',
                'new-taiwan-dollar'           => '新台币 (TWD)',
                'new-zealand-dollar'          => '新西兰元 (NZD)',
                'nigerian-naira'              => '尼日利亚奈拉 (NGN)',
                'norwegian-krone'             => '挪威克朗 (NOK)',
                'omani-rial'                  => '阿曼里亚尔 (OMR)',
                'pakistani-rupee'             => '巴基斯坦卢比 (PKR)',
                'panamanian-balboa'           => '巴拿马巴尔博亚 (PAB)',
                'paraguayan-guarani'          => '巴拉圭瓜拉尼 (PYG)',
                'peruvian-nuevo-sol'          => '秘鲁新索尔 (PEN)',
                'pgsql'                       => 'PgSQL',
                'philippine-peso'             => '菲律宾比索 (PHP)',
                'polish-zloty'                => '波兰兹罗提 (PLN)',
                'qatari-rial'                 => '卡塔尔里亚尔 (QAR)',
                'romanian-leu'                => '罗马尼亚列伊 (RON)',
                'russian-ruble'               => '俄罗斯卢布 (RUB)',
                'saudi-riyal'                 => '沙特里亚尔 (SAR)',
                'select-timezone'             => '选择时区',
                'singapore-dollar'            => '新加坡元 (SGD)',
                'south-african-rand'          => '南非兰特 (ZAR)',
                'south-korean-won'            => '韩元 (KRW)',
                'sqlsrv'                      => 'SQLSRV',
                'sri-lankan-rupee'            => '斯里兰卡卢比 (LKR)',
                'swedish-krona'               => '瑞典克朗 (SEK)',
                'swiss-franc'                 => '瑞士法郎 (CHF)',
                'thai-baht'                   => '泰铢 (THB)',
                'title'                       => '商店配置',
                'tunisian-dinar'              => '突尼斯第纳尔 (TND)',
                'turkish-lira'                => '土耳其里拉 (TRY)',
                'ukrainian-hryvnia'           => '乌克兰格里夫纳 (UAH)',
                'united-arab-emirates-dirham' => '阿联酋迪拉姆 (AED)',
                'united-states-dollar'        => '美元 (USD)',
                'uzbekistani-som'             => '乌兹别克斯坦苏姆 (UZS)',
                'venezuelan-bolívar'          => '委内瑞拉玻利瓦尔 (VEF)',
                'vietnamese-dong'             => '越南盾 (VND)',
                'warning-message'             => '注意！您的默认系统语言和默认货币设置是永久性的，设置后无法更改。',
                'zambian-kwacha'              => '赞比亚克瓦查 (ZMW)',
            ],

            'sample-products' => [
                'download-sample' => '下载样品',
                'no'              => '否',
                'sample-products' => '样品产品',
                'title'           => '样品产品',
                'yes'             => '是',
            ],

            'installation-processing' => [
                'bagisto-info' => '正在创建数据库表，这可能需要一些时间',
                'bagisto'      => 'Bagisto 安装',
                'title'        => '安装',
            ],

            'installation-completed' => [
                'admin-panel'                => '管理员面板',
                'bagisto-forums'             => 'Bagisto 论坛',
                'customer-panel'             => '客户面板',
                'explore-bagisto-extensions' => '探索 Bagisto 扩展',
                'title'                      => '安装已完成',
                'title-info'                 => 'Bagisto 已成功安装在您的系统上。',
            ],

            'ready-for-installation' => [
                'create-databsae-table'   => '创建数据库表',
                'install'                 => '安装',
                'install-info'            => 'Bagisto 安装信息',
                'install-info-button'     => '点击下面的按钮',
                'populate-database-table' => '填充数据库表',
                'start-installation'      => '开始安装',
                'title'                   => '准备安装',
            ],

            'start' => [
                'locale'        => '区域设置',
                'main'          => '开始',
                'select-locale' => '选择区域设置',
                'title'         => '您的 Bagisto 安装',
                'welcome-title' => '欢迎来到 Bagisto',
            ],

            'server-requirements' => [
                'calendar'    => '日历',
                'ctype'       => 'cType',
                'curl'        => 'cURL',
                'dom'         => 'DOM',
                'fileinfo'    => '文件信息',
                'filter'      => '过滤器',
                'gd'          => 'GD',
                'hash'        => '哈希',
                'intl'        => '国际化',
                'json'        => 'JSON',
                'mbstring'    => '多字节字符串',
                'openssl'     => 'OpenSSL',
                'pcre'        => 'PCRE',
                'pdo'         => 'PDO',
                'php'         => 'PHP',
                'php-version' => '8.1 或更高版本',
                'session'     => '会话',
                'title'       => '服务器要求',
                'tokenizer'   => '标记器',
                'xml'         => 'XML',
            ],

            'arabic'                   => '阿拉伯语',
            'back'                     => '返回',
            'bagisto'                  => 'Bagisto',
            'bagisto-info'             => '由 Webkul 社区共同开发的项目',
            'bagisto-logo'             => 'Bagisto Logo',
            'bengali'                  => '孟加拉语',
            'chinese'                  => '中文',
            'continue'                 => '继续',
            'dutch'                    => '荷兰语',
            'english'                  => '英语',
            'french'                   => '法语',
            'german'                   => '德语',
            'hebrew'                   => '希伯来语',
            'hindi'                    => '印地语',
            'installation-description' => 'Bagisto 的安装通常涉及几个步骤。以下是 Bagisto 安装过程的一般概述',
            'installation-info'        => '我们很高兴在这里见到你！',
            'installation-title'       => '欢迎安装 Bagisto',
            'italian'                  => '意大利语',
            'japanese'                 => '日语',
            'persian'                  => '波斯语',
            'polish'                   => '波兰语',
            'portuguese'               => '巴西葡萄牙语',
            'russian'                  => '俄语',
            'sinhala'                  => '僧伽罗语',
            'spanish'                  => '西班牙语',
            'title'                    => 'Bagisto 安装程序',
            'turkish'                  => '土耳其语',
            'ukrainian'                => '乌克兰语',
            'webkul'                   => 'Webkul',
        ],
    ],
];
