<?php

return [
    'users' => [
        'sessions' => [
            'email'                => '电子邮件地址',
            'forget-password-link' => '忘记密码？',
            'password'             => '密码',
            'submit-btn'           => '登录',
            'title'                => '登录',
        ],

        'forget-password' => [
            'create' => [
                'email'           => '注册电子邮件',
                'email-not-exist' => '电子邮件不存在',
                'page-title'      => '忘记密码',
                'reset-link-sent' => '重置密码链接已发送',
                'sign-in-link'    => '返回登录？',
                'submit-btn'      => '重置',
                'title'           => '找回密码',
            ],
        ],

        'reset-password' => [
            'back-link-title'  => '返回登录？',
            'confirm-password' => '确认密码',
            'email'            => '注册电子邮件',
            'password'         => '密码',
            'submit-btn'       => '重置密码',
            'title'            => '重置密码',
        ],
    ],

    'notifications' => [
        'description-text' => '列出所有通知',
        'marked-success'   => '通知标记成功',
        'no-record'        => '未找到记录',
        'of'               => '的',
        'per-page'         => '每页',
        'read-all'         => '标记为已读',
        'title'            => '通知',
        'view-all'         => '查看全部',

        'order-status-messages' => [
            'all'             => '全部',
            'canceled'        => '订单已取消',
            'closed'          => '订单已关闭',
            'completed'       => '订单已完成',
            'pending'         => '订单待处理',
            'pending-payment' => '待付款订单',
            'processing'      => '订单处理中',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => '返回',
            'change-password'   => '修改密码',
            'confirm-password'  => '确认密码',
            'current-password'  => '当前密码',
            'email'             => '电子邮件',
            'general'           => '通用',
            'invalid-password'  => '您输入的当前密码不正确。',
            'name'              => '姓名',
            'password'          => '密码',
            'profile-image'     => '个人资料图片',
            'save-btn'          => '保存账户',
            'title'             => '我的账户',
            'update-success'    => '账户已成功更新',
            'upload-image-info' => '上传个人资料图片（110px X 110px），格式为PNG或JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => '添加客户',
            'add-product'                 => '添加产品',
            'all-channels'                => '所有渠道',
            'attribute-code'              => '属性代码',
            'average-sale'                => '平均订单销售额',
            'color'                       => '颜色',
            'customer-info'               => '未找到销售额最高的客户',
            'customer-with-most-sales'    => '销售额最高的客户',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => '空阈值',
            'empty-threshold-description' => '没有可用的产品',
            'end-date'                    => '结束日期',
            'from'                        => '从',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ 更多图片',
            'order'                       => ':total_orders 订单',
            'order-count'                 => ':count 订单',
            'order-id'                    => '#:id',
            'overall-details'             => '总体详情',
            'pay-by'                      => '支付方式 - :method',
            'product-count'               => ':count 产品',
            'product-image'               => '产品图片',
            'product-info'                => '在路上添加相关产品。',
            'product-number'              => '产品 - :product_number',
            'revenue'                     => '收入 :total',
            'sale-count'                  => ':count 销售',
            'sales'                       => '销售',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => '开始日期',
            'stock-threshold'             => '库存阈值',
            'store-stats'                 => '商店统计',
            'title'                       => '仪表盘',
            'to'                          => '至',
            'today-customers'             => '今日客户',
            'today-details'               => '今日详情',
            'today-orders'                => '今日订单',
            'today-sales'                 => '今日销售',
            'top-performing-categories'   => '表现最佳的类别',
            'top-selling-products'        => '畅销产品',
            'total-customers'             => '总客户数',
            'total-orders'                => '总订单数',
            'total-sales'                 => '总销售额',
            'total-stock'                 => ':total_stock 库存',
            'total-unpaid-invoices'       => '未付发票总数',
            'unique-visitors'             => ':count 唯一',
            'user-info'                   => '快速查看商店的最新情况',
            'user-name'                   => '你好！:user_name',
            'visitors'                    => '访客',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => '创建订单',
                'title'      => '订单',

                'search-customer' => [
                    'create-btn'  => '创建客户',
                    'empty-info'  => '没有可用于搜索条件的客户。',
                    'empty-title' => '未找到客户',
                    'search-by'   => '按电子邮件或姓名搜索',
                    'title'       => '选择客户',
                ],

                'datagrid' => [
                    'canceled'        => '已取消',
                    'channel-name'    => '渠道',
                    'closed'          => '已关闭',
                    'completed'       => '已完成',
                    'customer'        => '客户',
                    'date'            => '日期',
                    'email'           => '电子邮件',
                    'fraud'           => '欺诈',
                    'grand-total'     => '总计',
                    'id'              => '订单号：#:id',
                    'items'           => '商品',
                    'location'        => '地点',
                    'order-id'        => '订单编号',
                    'pay-by'          => '支付方式 - :method',
                    'pay-via'         => '支付方式',
                    'pending-payment' => '待付款',
                    'pending'         => '待处理',
                    'processing'      => '处理中',
                    'product-count'   => ':count + 更多产品',
                    'status'          => '状态',
                    'success'         => '成功',
                    'view'            => '查看',
                ],
            ],

            'create' => [
                'add-to-cart'             => '添加到购物车',
                'back-btn'                => '返回',
                'check-billing-address'   => '缺少账单地址。',
                'check-shipping-address'  => '缺少送货地址。',
                'configuration'           => '配置',
                'coupon-already-applied'  => '优惠券已经应用。',
                'coupon-applied'          => '优惠券已成功应用。',
                'coupon-error'            => '无法应用优惠券。',
                'coupon-not-found'        => '找不到优惠券',
                'coupon-remove'           => '优惠券已成功移除。',
                'error'                   => '出现错误',
                'minimum-order-error'     => '未达到最低订单金额。',
                'order-placed-success'    => '订单已成功下单。',
                'payment-not-supported'   => '不支持此支付方式',
                'save-btn'                => '创建订单',
                'specify-payment-method'  => '缺少支付方式。',
                'specify-shipping-method' => '缺少配送方式。',
                'title'                   => '为 :name 创建订单',

                'types' => [
                    'configurable' => [
                        'select-options' => '请选择一个选项',
                    ],

                    'bundle' => [
                        'none'         => '无',
                        'total-amount' => '总金额',
                    ],

                    'grouped' => [
                        'name' => '名称',
                    ],

                    'downloadable' => [
                        'title' => '链接',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => '产品已成功添加到购物车',
                    'success-remove'      => '项目已成功从购物车中移除',
                    'success-update'      => '购物车项目已成功更新',

                    'items' => [
                        'add-product'       => '添加产品',
                        'amount-per-unit'   => ':amount 每单位 x :qty 数量',
                        'delete'            => '删除',
                        'empty-description' => '购物车中没有找到任何商品。',
                        'empty-title'       => '购物车为空',
                        'excl-tax'          => '不含税',
                        'move-to-wishlist'  => '移到心愿单',
                        'see-details'       => '查看详情',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => '小计 - :sub_total',
                        'title'             => '购物车商品',

                        'search' => [
                            'add-to-cart'   => '添加到购物车',
                            'available-qty' => ':qty 可用',
                            'empty-info'    => '没有可用于搜索词的产品。',
                            'empty-title'   => '未找到产品',
                            'product-image' => '产品图片',
                            'qty'           => '数量',
                            'sku'           => 'SKU - :sku',
                            'title'         => '搜索产品',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => '添加地址',
                        'add-new'          => '添加新地址',
                        'add-new-address'  => '添加新地址',
                        'addresses'        => '地址',
                        'back'             => '返回',
                        'billing-address'  => '账单地址',
                        'city'             => '城市',
                        'company-name'     => '公司名称',
                        'confirm'          => '确认',
                        'country'          => '国家',
                        'edit-btn'         => '编辑地址',
                        'email'            => '电子邮件',
                        'first-name'       => '名字',
                        'last-name'        => '姓氏',
                        'postcode'         => '邮政编码',
                        'proceed'          => '继续',
                        'same-as-billing'  => '使用相同地址作为送货地址？',
                        'save'             => '保存',
                        'save-address'     => '保存到地址簿',
                        'select-country'   => '选择国家',
                        'select-state'     => '选择省/州',
                        'shipping-address' => '送货地址',
                        'state'            => '省/州',
                        'street-address'   => '街道地址',
                        'telephone'        => '电话',
                        'title'            => '地址',
                        'vat-id'           => '增值税号码',
                    ],

                    'payment' => [
                        'title' => '支付',
                    ],

                    'shipping' => [
                        'title' => '配送',
                    ],

                    'summary' => [
                        'apply-coupon'             => '应用优惠券',
                        'discount-amount'          => '折扣金额',
                        'enter-your-code'          => '输入您的代码',
                        'grand-total'              => '总计',
                        'place-order'              => '下单',
                        'processing'               => '处理中',
                        'shipping-amount-excl-tax' => '运费（不含税）',
                        'shipping-amount-incl-tax' => '运费（含税）',
                        'shipping-amount'          => '运费',
                        'sub-total-excl-tax'       => '小计（不含税）',
                        'sub-total-incl-tax'       => '小计（含税）',
                        'sub-total'                => '小计',
                        'tax'                      => '税费',
                        'title'                    => '订单摘要',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => '添加到购物车',
                    'delete'            => '删除',
                    'empty-description' => '购物车中没有找到任何商品。',
                    'empty-title'       => '购物车为空',
                    'excl-tax'          => '不含税',
                    'see-details'       => '查看详情',
                    'sku'               => 'SKU - :sku',
                    'title'             => '购物车商品',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => '添加到购物车',
                    'empty-description' => '最近订单中没有找到任何商品。',
                    'empty-title'       => '订单为空',
                    'see-details'       => '查看详情',
                    'sku'               => 'SKU - :sku',
                    'title'             => '最近订单商品',
                    'view'              => '查看',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => '添加到购物车',
                    'delete'            => '删除',
                    'empty-description' => '心愿单中没有找到任何商品。',
                    'empty-title'       => '心愿单为空',
                    'see-details'       => '查看详情',
                    'sku'               => 'SKU - :sku',
                    'title'             => '心愿单商品',
                ],

                'compare-items' => [
                    'add-to-cart'       => '添加到购物车',
                    'delete'            => '删除',
                    'empty-description' => '比较列表中没有找到任何商品。',
                    'empty-title'       => '比较列表为空',
                    'sku'               => 'SKU - :sku',
                    'title'             => '比较商品',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount 每单位 x :qty 数量',
                'billing-address'                => '账单地址',
                'cancel'                         => '取消',
                'cancel-msg'                     => '确定要取消此订单吗？',
                'cancel-success'                 => '订单取消成功',
                'canceled'                       => '已取消',
                'channel'                        => '渠道',
                'closed'                         => '已关闭',
                'comment-success'                => '评论添加成功。',
                'comments'                       => '评论',
                'completed'                      => '已完成',
                'contact'                        => '联系人',
                'create-success'                 => '订单创建成功',
                'currency'                       => '货币',
                'customer'                       => '客户',
                'customer-group'                 => '客户组',
                'customer-not-notified'          => ':date | 客户 <b>未通知</b>',
                'customer-notified'              => ':date | 客户 <b>已通知</b>',
                'discount'                       => '折扣 - :discount',
                'download-pdf'                   => '下载PDF',
                'fraud'                          => '欺诈',
                'grand-total'                    => '总计 - :grand_total',
                'invoice-id'                     => '发票号 #:invoice',
                'invoices'                       => '发票',
                'item-canceled'                  => '已取消 (:qty_canceled)',
                'item-invoice'                   => '已开票 (:qty_invoiced)',
                'item-ordered'                   => '已下单 (:qty_ordered)',
                'item-refunded'                  => '已退款 (:qty_refunded)',
                'item-shipped'                   => '已发货 (:qty_shipped)',
                'name'                           => '名称',
                'no-invoice-found'               => '未找到发票',
                'no-refund-found'                => '未找到退款',
                'no-shipment-found'              => '未找到发货',
                'notify-customer'                => '通知客户',
                'order-date'                     => '订单日期',
                'order-information'              => '订单信息',
                'order-status'                   => '订单状态',
                'payment-and-shipping'           => '付款和配送',
                'payment-method'                 => '付款方式',
                'pending'                        => '待处理',
                'pending_payment'                => '待付款',
                'per-unit'                       => '每单位',
                'price'                          => '价格 - :price',
                'price-excl-tax'                 => '价格（不含税） - :price',
                'price-incl-tax'                 => '价格（含税） - :price',
                'processing'                     => '处理中',
                'quantity'                       => '数量',
                'refund'                         => '退款',
                'refund-id'                      => '退款号 #:refund',
                'refunded'                       => '已退款',
                'reorder'                        => '重新下单',
                'ship'                           => '发货',
                'shipment'                       => '发货 #:shipment',
                'shipments'                      => '发货',
                'shipping-address'               => '配送地址',
                'shipping-and-handling'          => '配送和处理',
                'shipping-and-handling-excl-tax' => '配送和处理（不含税）',
                'shipping-and-handling-incl-tax' => '配送和处理（含税）',
                'shipping-method'                => '配送方式',
                'shipping-price'                 => '配送费用',
                'sku'                            => 'SKU - :sku',
                'status'                         => '状态',
                'sub-total'                      => '小计 - :sub_total',
                'sub-total-excl-tax'             => '小计（不含税） - :sub_total',
                'sub-total-incl-tax'             => '小计（含税） - :sub_total',
                'submit-comment'                 => '提交评论',
                'summary-discount'               => '折扣',
                'summary-grand-total'            => '总计',
                'summary-sub-total'              => '小计',
                'summary-sub-total-excl-tax'     => '小计（不含税）',
                'summary-sub-total-incl-tax'     => '小计（含税）',
                'summary-tax'                    => '税费',
                'tax'                            => '税费 (:percent) - :tax',
                'title'                          => '订单 #:order_id',
                'total-due'                      => '应付总额',
                'total-paid'                     => '已付总额',
                'total-refund'                   => '退款总额',
                'view'                           => '查看',
                'write-your-comment'             => '写下您的评论',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => '发货',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => '库存来源',
                    'order-date'       => '订单日期',
                    'order-id'         => '订单ID',
                    'shipment-date'    => '发货日期',
                    'shipment-to'      => '发货至',
                    'total-qty'        => '总数量',
                    'view'             => '查看',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount 每单位 x :qty 数量',
                'cancel-error'     => '无法取消订单',
                'carrier-name'     => '承运人名称',
                'create-btn'       => '创建发货',
                'creation-error'   => '发货创建出错',
                'item-canceled'    => '已取消 (:qty_canceled)',
                'item-invoice'     => '已开票 (:qty_invoiced)',
                'item-ordered'     => '已下单 (:qty_ordered)',
                'item-refunded'    => '已退款 (:qty_refunded)',
                'item-shipped'     => '已发货 (:qty_shipped)',
                'order-error'      => '发货无效',
                'per-unit'         => '每单位',
                'qty-available'    => '可用数量',
                'qty-to-ship'      => '待发货数量',
                'quantity-invalid' => '数量无效',
                'sku'              => 'SKU - :sku',
                'source'           => '来源',
                'success'          => '发货创建成功',
                'title'            => '创建新的发货',
                'tracking-number'  => '跟踪编号',
            ],

            'view' => [
                'billing-address'      => '账单地址',
                'carrier-title'        => '承运人标题',
                'channel'              => '渠道',
                'currency'             => '货币',
                'customer'             => '客户',
                'email'                => '电子邮件 - :email',
                'inventory-source'     => '库存来源',
                'order-date'           => '订单日期',
                'order-id'             => '订单ID',
                'order-information'    => '订单信息',
                'order-status'         => '订单状态',
                'ordered-items'        => '已下单项目',
                'payment-and-shipping' => '付款和发货',
                'payment-method'       => '付款方式',
                'product-image'        => '产品图片',
                'qty'                  => '数量 - :qty',
                'shipping-address'     => '发货地址',
                'shipping-method'      => '发货方式',
                'shipping-price'       => '发货价格',
                'sku'                  => 'SKU - :sku ',
                'title'                => '发货 #:shipment_id',
                'tracking-number'      => '跟踪编号',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => '退款',

                'datagrid' => [
                    'billed-to'       => '账单至',
                    'id'              => 'ID',
                    'order-id'        => '订单ID',
                    'refund-date'     => '退款日期',
                    'refunded-amount' => '退款金额',
                    'view'            => '查看',
                ],
            ],

            'view' => [
                'account-information'        => '账户信息',
                'adjustment-fee'             => '调整费用',
                'adjustment-refund'          => '调整退款',
                'base-discounted-amount'     => '基准折扣金额 - :base_discounted_amount',
                'billing-address'            => '账单地址',
                'currency'                   => '货币',
                'sub-total-amount-excl-tax'  => '小计金额（不含税） - :discounted_amount',
                'sub-total-amount-incl-tax'  => '小计金额（含税） - :discounted_amount',
                'sub-total-amount'           => '小计金额 - :discounted_amount',
                'grand-total'                => '总计',
                'order-channel'              => '订单渠道',
                'order-date'                 => '订单日期',
                'order-id'                   => '订单ID',
                'order-information'          => '订单信息',
                'order-status'               => '订单状态',
                'payment-information'        => '付款信息',
                'payment-method'             => '付款方式',
                'price-excl-tax'             => '价格（不含税） - :price',
                'price-incl-tax'             => '价格（含税） - :price',
                'price'                      => '价格 - :price',
                'product-image'              => '产品图片',
                'product-ordered'            => '已订购产品',
                'qty'                        => '数量 - :qty',
                'refund'                     => '退款',
                'shipping-address'           => '发货地址',
                'shipping-handling-excl-tax' => '配送和处理（不含税）',
                'shipping-handling-incl-tax' => '配送和处理（含税）',
                'shipping-handling'          => '配送和处理',
                'shipping-method'            => '配送方式',
                'shipping-price'             => '配送费用',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => '小计（不含税）',
                'sub-total-incl-tax'         => '小计（含税）',
                'sub-total'                  => '小计',
                'tax'                        => '税费',
                'tax-amount'                 => '税费金额 - :tax_amount',
                'title'                      => '退款 #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => '调整费用',
                'adjustment-refund'           => '调整退款',
                'amount-per-unit'             => ':amount 每单位 x :qty 数量',
                'create-success'              => '退款创建成功',
                'creation-error'              => '退款创建不允许。',
                'discount-amount'             => '折扣金额',
                'grand-total'                 => '总计',
                'invalid-qty'                 => '我们发现有无效的数量要开票。',
                'invalid-refund-amount-error' => '退款金额应为非零。',
                'item-canceled'               => '已取消 (:qty_canceled)',
                'item-invoice'                => '已开票 (:qty_invoiced)',
                'item-ordered'                => '已下单 (:qty_ordered)',
                'item-refunded'               => '已退款 (:qty_refunded)',
                'item-shipped'                => '已发货 (:qty_shipped)',
                'per-unit'                    => '每单位',
                'price'                       => '价格',
                'qty-to-refund'               => '待退款数量',
                'refund-btn'                  => '退款',
                'refund-limit-error'          => '退款金额 :amount 无法进行。',
                'refund-shipping'             => '退款运费',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => '小计',
                'tax-amount'                  => '税额',
                'title'                       => '创建退款',
                'update-totals-btn'           => '更新总计',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => '发票',

                'datagrid' => [
                    'action'       => '操作',
                    'grand-total'  => '总计',
                    'id'           => 'ID',
                    'invoice-date' => '发票日期',
                    'order-id'     => '订单ID',
                    'overdue'      => '逾期',
                    'paid'         => '已支付',
                    'pending'      => '待支付',
                    'status'       => '状态',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount 每单位 x :qty 数量',
                'channel'                        => '渠道',
                'customer-email'                 => '邮箱 - :email',
                'customer'                       => '客户',
                'discount'                       => '折扣金额 - :discount',
                'email'                          => '邮箱',
                'grand-total'                    => '总计',
                'invoice-items'                  => '发票项目',
                'invoice-sent'                   => '发票发送成功',
                'invoice-status'                 => '发票状态',
                'order-date'                     => '订单日期',
                'order-id'                       => '订单ID',
                'order-information'              => '订单信息',
                'order-status'                   => '订单状态',
                'price-excl-tax'                 => '价格（不含税） - :price',
                'price-incl-tax'                 => '价格（含税） - :price',
                'price'                          => '价格 - :price',
                'print'                          => '打印',
                'product-image'                  => '产品图片',
                'qty'                            => '数量 - :qty',
                'send-btn'                       => '发送',
                'send-duplicate-invoice'         => '发送重复发票',
                'send'                           => '发送',
                'shipping-and-handling-excl-tax' => '配送和处理（不含税）',
                'shipping-and-handling-incl-tax' => '配送和处理（含税）',
                'shipping-and-handling'          => '配送和处理',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => '小计（不含税） - :sub_total',
                'sub-total-incl-tax'             => '小计（含税） - :sub_total',
                'sub-total-summary-excl-tax'     => '小计（不含税）',
                'sub-total-summary-incl-tax'     => '小计（含税）',
                'sub-total-summary'              => '小计',
                'sub-total'                      => '小计 - :sub_total',
                'summary-discount'               => '折扣金额',
                'summary-tax'                    => '税费金额',
                'tax'                            => '税费金额 - :tax',
                'title'                          => '发票 #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount 每单位 x :qty 数量',
                'create-invoice'     => '创建发票',
                'create-success'     => '发票创建成功',
                'create-transaction' => '创建交易',
                'creation-error'     => '不允许创建订单发票。',
                'invalid-qty'        => '我们发现无效的数量来开发票商品。',
                'invoice'            => '发票',
                'new-invoice'        => '新发票',
                'product-error'      => '无法没有产品创建发票。',
                'product-image'      => '产品图片',
                'qty-to-invoiced'    => '要开发票的数量',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => '银行详细信息',
                'bill-to'                    => '账单给',
                'contact-number'             => '联系电话',
                'contact'                    => '联系人',
                'date'                       => '发票日期',
                'discount'                   => '折扣',
                'excl-tax'                   => '不含税：',
                'grand-total'                => '总计',
                'invoice-id'                 => '发票ID',
                'invoice'                    => '发票',
                'order-date'                 => '订单日期',
                'order-id'                   => '订单ID',
                'payment-method'             => '付款方式',
                'payment-terms'              => '付款条件',
                'price'                      => '价格',
                'product-name'               => '产品名称',
                'qty'                        => '数量',
                'ship-to'                    => '收货地址',
                'shipping-handling-excl-tax' => '运输和处理（不含税）',
                'shipping-handling-incl-tax' => '运输和处理（含税）',
                'shipping-handling'          => '运输和处理',
                'shipping-method'            => '运输方式',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => '小计（不含税）',
                'subtotal-incl-tax'          => '小计（含税）',
                'subtotal'                   => '小计',
                'tax-amount'                 => '税费金额',
                'tax'                        => '税费',
                'vat-number'                 => '增值税号码',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => '交易日期',
            'transaction-id'   => '交易ID',
            'view'             => '查看',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => '创建交易',
                'title'      => '交易',

                'datagrid' => [
                    'completed'          => '已完成',
                    'id'                 => 'ID',
                    'invoice-id'         => '发票ID',
                    'order-id'           => '订单ID',
                    'paid'               => '已支付',
                    'pending'            => '待定',
                    'status'             => '状态',
                    'transaction-amount' => '金额',
                    'transaction-date'   => '日期',
                    'transaction-id'     => '交易ID',
                    'view'               => '查看',
                ],

                'create' => [
                    'already-paid'               => '已支付',
                    'amount'                     => '金额',
                    'create-transaction'         => '创建交易',
                    'invoice-id'                 => '发票号',
                    'invoice-missing'            => '发票丢失',
                    'payment-method'             => '付款方式',
                    'save-transaction'           => '保存交易',
                    'transaction-amount-exceeds' => '交易金额超过',
                    'transaction-amount-zero'    => '交易金额为零',
                    'transaction-saved'          => '交易已成功保存。',
                ],

                'view' => [
                    'amount'           => '金额',
                    'created-at'       => '创建时间',
                    'invoice-id'       => '发票 ID',
                    'order-id'         => '订单 ID',
                    'payment-details'  => '付款详情',
                    'payment-method'   => '付款方式',
                    'status'           => '状态',
                    'title'            => '交易详情',
                    'transaction-data' => '交易数据',
                    'transaction-id'   => '交易 ID',
                ],
            ],
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => ':name 已经被占用。',
                'create-btn'    => '创建产品',
                'title'         => '产品',

                'create' => [
                    'back-btn'                => '返回',
                    'configurable-attributes' => '可配置属性',
                    'create-btn'              => '创建产品',
                    'family'                  => '家庭',
                    'save-btn'                => '保存产品',
                    'sku'                     => 'SKU',
                    'title'                   => '创建新产品',
                    'type'                    => '类型',
                ],

                'datagrid' => [
                    'active'                 => '激活',
                    'attribute-family'       => '属性家族',
                    'attribute-family-value' => '属性家族 - :attribute_family',
                    'category'               => '类别',
                    'channel'                => '渠道',
                    'copy-of'                => '复制 :value',
                    'copy-of-slug'           => '复制-:value',
                    'delete'                 => '删除',
                    'disable'                => '禁用',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => '图像',
                    'mass-delete-success'    => '已成功删除所选产品',
                    'mass-update-success'    => '已成功更新所选产品',
                    'name'                   => '名称',
                    'out-of-stock'           => '缺货',
                    'price'                  => '价格',
                    'product-image'          => '产品图像',
                    'qty'                    => '数量',
                    'qty-value'              => ':qty 可用',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => '状态',
                    'type'                   => '类型',
                    'update-status'          => '更新状态',
                ],
            ],

            'edit' => [
                'preview'  => '预览',
                'remove'   => '删除',
                'save-btn' => '保存产品',
                'title'    => '编辑产品',

                'channels' => [
                    'title' => '渠道',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => '添加组价格',
                        'all-groups'                => '所有群组',
                        'create-btn'                => '添加新的',
                        'discount-group-price-info' => '对于 :qty 个数量，折扣价格为 :price',
                        'edit-btn'                  => '编辑',
                        'empty-info'                => '针对属于特定组的客户的特殊定价。',
                        'fixed-group-price-info'    => '对于 :qty 个数量，固定价格为 :price',
                        'title'                     => '客户组价格',

                        'create' => [
                            'all-groups'     => '所有群组',
                            'create-title'   => '创建客户组价格',
                            'customer-group' => '客户组',
                            'delete-btn'     => '删除',
                            'discount'       => '折扣',
                            'fixed'          => '固定',
                            'price'          => '价格',
                            'price-type'     => '价格类型',
                            'qty'            => '最小数量',
                            'save-btn'       => '保存',
                            'update-title'   => '更新客户组价格',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => '待发货数量: :qty',
                    'pending-ordered-qty-info' => '待发货数量将在发货后从相应的库存来源中扣减。在取消的情况下，待处理数量将可供销售。',
                    'title'                    => '库存',
                ],

                'categories' => [
                    'title' => '分类',
                ],

                'images' => [
                    'info'  => '图像分辨率应为560px X 609px',
                    'title' => '图片',
                ],

                'videos' => [
                    'error' => ':attribute 不能大于:max KB。请选择较小的文件。',
                    'title' => '视频',
                    'info'  => '最大视频尺寸应为 :size',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => '在路上添加相关产品。',
                        'info'       => '除了客户当前查看的产品外，他们还会看到相关产品。',
                        'title'      => '相关产品',
                    ],

                    'up-sells' => [
                        'empty-info' => '在路上添加额外的销售产品。',
                        'info'       => '客户将看到上卖产品，这些产品是当前查看的产品的高级或更高质量的替代品。',
                        'title'      => '上卖产品',
                    ],

                    'cross-sells' => [
                        'empty-info' => '在路上添加交叉销售产品。',
                        'info'       => '在购物车旁边，您将找到这些“冲动购买”产品，它们被定位为与已经添加到购物车的商品相补充的交叉销售产品。',
                        'title'      => '交叉销售产品',
                    ],

                    'add-btn'           => '添加产品',
                    'delete'            => '删除',
                    'empty-info'        => '随时添加 :type 产品。',
                    'empty-title'       => '添加产品',
                    'image-placeholder' => '产品图片',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'configurable' => [
                        'add-btn'           => '添加变体',
                        'delete-btn'        => '删除',
                        'edit-btn'          => '编辑',
                        'empty-info'        => '随时创建产品的各种组合。',
                        'empty-title'       => '添加变体',
                        'image-placeholder' => '产品图片',
                        'info'              => '变体产品取决于所有可能的属性组合。',
                        'qty'               => ':qty 个',
                        'sku'               => 'SKU - :sku',
                        'title'             => '变体',

                        'create' => [
                            'description'            => '描述',
                            'name'                   => '名称',
                            'save-btn'               => '添加',
                            'title'                  => '添加变体',
                            'variant-already-exists' => '此变体已存在',
                        ],

                        'edit' => [
                            'disabled'        => '禁用',
                            'edit-info'       => '如果您想详细更新产品信息，请转至',
                            'edit-link-title' => '产品详细信息页面',
                            'enabled'         => '启用',
                            'images'          => '图片',
                            'name'            => '名称',
                            'price'           => '价格',
                            'quantities'      => '数量',
                            'save-btn'        => '保存',
                            'sku'             => 'SKU',
                            'status'          => '状态',
                            'title'           => '产品',
                            'weight'          => '重量',
                        ],

                        'mass-edit' => [
                            'add-images'          => '添加图片',
                            'apply-to-all-btn'    => '应用于所有',
                            'apply-to-all-name'   => '将名称应用于所有变体。',
                            'apply-to-all-sku'    => '将价格应用于所有 SKU。',
                            'apply-to-all-status' => '将状态应用于所有变体。',
                            'apply-to-all-weight' => '对所有变体应用权重。',
                            'edit-inventories'    => '编辑库存',
                            'edit-names'          => '编辑名称',
                            'edit-prices'         => '编辑价格',
                            'edit-sku'            => '编辑 SKU',
                            'edit-status'         => '编辑状态',
                            'edit-weight'         => '编辑重量',
                            'name'                => '名称',
                            'price'               => '价格',
                            'remove-images'       => '移除图片',
                            'remove-variants'     => '移除变体',
                            'select-action'       => '选择操作',
                            'select-variants'     => '选择变体',
                            'status'              => '状态',
                            'variant-name'        => '变体名称',
                            'variant-sku'         => '变体 SKU',
                            'weight'              => '重量',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => '添加产品',
                        'default-qty'       => '默认数量',
                        'delete'            => '删除',
                        'empty-info'        => '随时创建产品的各种组合。',
                        'empty-title'       => '添加产品',
                        'image-placeholder' => '产品图片',
                        'info'              => '分组产品包括独立销售的项目，作为一个集合呈现，允许按季节或主题进行变化或协调。每个产品可以单独购买，也可以作为该组的一部分购买。',
                        'sku'               => 'SKU - :sku',
                        'title'             => '组合产品',
                    ],

                    'bundle' => [
                        'add-btn'           => '添加选项',
                        'empty-info'        => '随时创建捆绑选项。',
                        'empty-title'       => '添加选项',
                        'image-placeholder' => '产品图片',
                        'info'              => '捆绑产品是一组多个项目或服务，以特价一起销售，为客户提供价值和便利。',
                        'title'             => '捆绑项目',

                        'update-create' => [
                            'checkbox'    => '复选框',
                            'is-required' => '必填',
                            'multiselect' => '多选框',
                            'name'        => '标题',
                            'no'          => '否',
                            'radio'       => '单选按钮',
                            'save-btn'    => '保存',
                            'select'      => '选择',
                            'title'       => '选项',
                            'type'        => '类型',
                            'yes'         => '是',
                        ],

                        'option' => [
                            'add-btn'     => '添加产品',
                            'default-qty' => '默认数量',
                            'delete'      => '删除',
                            'delete-btn'  => '删除',
                            'edit-btn'    => '编辑',
                            'empty-info'  => '随时创建产品的各种组合。',
                            'empty-title' => '添加产品',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => '使用复选框设置默认产品',
                                    'title' => '复选框',
                                ],

                                'multiselect' => [
                                    'info'  => '使用复选框按钮设置默认产品',
                                    'title' => '多选框',
                                ],

                                'radio' => [
                                    'info'  => '使用单选按钮设置默认产品',
                                    'title' => '单选按钮',
                                ],

                                'select' => [
                                    'info'  => '使用单选按钮设置默认产品',
                                    'title' => '选择',
                                ],
                            ],
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => '添加链接',
                            'delete-btn'  => '删除',
                            'edit-btn'    => '编辑',
                            'empty-info'  => '随时创建链接。',
                            'empty-title' => '添加链接',
                            'file'        => '文件：',
                            'info'        => '可下载产品类型允许销售数字产品，如电子书，软件应用程序，音乐，游戏等。',
                            'sample-file' => '示例文件：',
                            'sample-url'  => '示例网址：',
                            'title'       => '可下载链接',
                            'url'         => '网址：',

                            'update-create' => [
                                'downloads'   => '允许下载',
                                'file'        => '文件',
                                'file-type'   => '文件类型',
                                'name'        => '标题',
                                'price'       => '价格',
                                'sample'      => '示例',
                                'sample-type' => '示例类型',
                                'save-btn'    => '保存',
                                'title'       => '链接',
                                'url'         => '网址',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => '添加示例',
                            'delete-btn'  => '删除',
                            'edit-btn'    => '编辑',
                            'empty-info'  => '随时创建示例。',
                            'empty-title' => '添加示例',
                            'file'        => '文件：',
                            'info'        => '可下载产品类型允许销售数字产品，如电子书，软件应用程序，音乐，游戏等。',
                            'title'       => '可下载示例',
                            'url'         => '网址：',

                            'update-create' => [
                                'file'        => '文件',
                                'file-type'   => '文件类型',
                                'name'        => '标题',
                                'save-btn'    => '保存',
                                'title'       => '链接',
                                'url'         => '网址',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => '产品创建成功',
            'delete-failed'           => '产品删除失败',
            'delete-success'          => '产品删除成功',
            'product-copied'          => '产品复制成功',
            'saved-inventory-message' => '产品保存成功',
            'update-success'          => '产品更新成功',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => '创建属性',
                'title'      => '属性',

                'datagrid' => [
                    'boolean'             => '布尔值',
                    'channel-based'       => '基于频道',
                    'checkbox'            => '复选框',
                    'code'                => '代码',
                    'created-at'          => '创建时间',
                    'date'                => '日期',
                    'date-time'           => '日期时间',
                    'delete'              => '删除',
                    'edit'                => '编辑',
                    'file'                => '文件',
                    'id'                  => '标识',
                    'image'               => '图片',
                    'locale-based'        => '基于区域设置',
                    'mass-delete-success' => '已成功删除所选属性',
                    'multiselect'         => '多选',
                    'name'                => '名称',
                    'price'               => '价格',
                    'required'            => '必填',
                    'select'              => '选择',
                    'text'                => '文本',
                    'textarea'            => '文本区域',
                    'type'                => '类型',
                    'unique'              => '唯一',
                ],
            ],

            'create' => [
                'add-attribute-options' => '添加属性选项',
                'add-option'            => '添加选项',
                'add-options-info'      => '快速创建各种属性选项组合。',
                'add-row'               => '添加行',
                'admin'                 => '管理员',
                'admin-name'            => '管理员名称',
                'back-btn'              => '返回',
                'boolean'               => '布尔',
                'checkbox'              => '复选框',
                'code'                  => '属性编码',
                'color'                 => '颜色',
                'configuration'         => '配置',
                'create-empty-option'   => '创建默认空选项',
                'date'                  => '日期',
                'datetime'              => '日期时间',
                'decimal'               => '小数',
                'default-value'         => '默认值',
                'email'                 => '电子邮件',
                'enable-wysiwyg'        => '启用所见即所得编辑器',
                'file'                  => '文件',
                'general'               => '常规',
                'image'                 => '图片',
                'input-options'         => '输入选项',
                'input-validation'      => '输入验证',
                'is-comparable'         => '可比较的属性',
                'is-configurable'       => '用于创建可配置产品',
                'is-filterable'         => '用于分层导航',
                'is-required'           => '必填',
                'is-unique'             => '唯一',
                'is-visible-on-front'   => '在前端产品视图页面上可见',
                'label'                 => '标签',
                'multiselect'           => '多选',
                'no'                    => '否',
                'numeric'               => '数字',
                'option-deleted'        => '选项删除成功',
                'options'               => '选项',
                'position'              => '位置',
                'price'                 => '价格',
                'regex'                 => '正则表达式',
                'regex-info'            => '表达式应该用双引号括起来。',
                'save-btn'              => '保存属性',
                'select'                => '选择',
                'select-type'           => '选择属性类型',
                'swatch'                => '颜色样本',
                'text'                  => '文本',
                'textarea'              => '文本区域',
                'title'                 => '添加属性',
                'type'                  => '属性类型',
                'url'                   => 'URL',
                'use-in-flat'           => '在产品平坦表中创建',
                'validations'           => '验证',
                'value-per-channel'     => '渠道性值',
                'value-per-locale'      => '区域性值',
                'yes'                   => '是',

                'option' => [
                    'color'    => '颜色样本',
                    'dropdown' => '下拉菜单',
                    'image'    => '图片样本',
                    'save-btn' => '保存选项',
                    'text'     => '文本样本',
                ],
            ],

            'edit' => [
                'add-attribute-options' => '添加属性选项',
                'add-option'            => '添加选项',
                'add-options-info'      => '快速创建各种属性选项组合。',
                'add-row'               => '添加行',
                'admin'                 => '管理员',
                'admin-name'            => '管理员名称',
                'back-btn'              => '返回',
                'boolean'               => '布尔',
                'checkbox'              => '复选框',
                'code'                  => '属性编码',
                'color'                 => '颜色',
                'configuration'         => '配置',
                'create-empty-option'   => '创建默认空选项',
                'date'                  => '日期',
                'datetime'              => '日期时间',
                'decimal'               => '小数',
                'default-value'         => '默认值',
                'email'                 => '电子邮件',
                'enable-wysiwyg'        => '启用所见即所得编辑器',
                'file'                  => '文件',
                'general'               => '常规',
                'image'                 => '图片',
                'input-options'         => '输入选项',
                'input-validation'      => '输入验证',
                'is-comparable'         => '可比较的属性',
                'is-configurable'       => '用于创建可配置产品',
                'is-filterable'         => '用于分层导航',
                'is-required'           => '必填',
                'is-unique'             => '唯一',
                'is-visible-on-front'   => '在前端产品视图页面上可见',
                'label'                 => '标签',
                'multiselect'           => '多选',
                'no'                    => '否',
                'numeric'               => '数字',
                'option-deleted'        => '选项删除成功',
                'options'               => '选项',
                'position'              => '位置',
                'price'                 => '价格',
                'regex'                 => '正则表达式',
                'regex-info'            => '表达式应该用双引号括起来。',
                'save-btn'              => '保存属性',
                'select'                => '选择',
                'select-type'           => '选择属性类型',
                'swatch'                => '颜色样本',
                'text'                  => '文本',
                'textarea'              => '文本区域',
                'title'                 => '编辑属性',
                'type'                  => '属性类型',
                'url'                   => 'URL',
                'use-in-flat'           => '在产品平坦表中创建',
                'validations'           => '验证',
                'value-per-channel'     => '渠道性值',
                'value-per-locale'      => '区域性值',
                'yes'                   => '是',

                'option' => [
                    'color'    => '颜色样本',
                    'dropdown' => '下拉菜单',
                    'image'    => '图片样本',
                    'save-btn' => '保存选项',
                    'text'     => '文本样本',
                ],
            ],

            'create-success'    => '属性创建成功',
            'delete-failed'     => '属性删除失败',
            'delete-success'    => '属性删除成功',
            'update-success'    => '属性更新成功',
            'user-define-error' => '无法删除系统属性',
        ],

        'categories' => [
            'index' => [
                'add-btn' => '创建分类',
                'title'   => '分类',

                'datagrid' => [
                    'active'         => '激活',
                    'delete'         => '删除',
                    'delete-success' => '已成功删除所选 :resource',
                    'edit'           => '编辑',
                    'id'             => 'ID',
                    'inactive'       => '禁用',
                    'name'           => '名称',
                    'no-of-products' => '产品数量',
                    'position'       => '位置',
                    'status'         => '菜单可见',
                    'update-status'  => '更新状态',
                ],
            ],

            'create' => [
                'add-banner'               => '添加横幅',
                'add-logo'                 => '添加徽标',
                'back-btn'                 => '返回',
                'banner'                   => '横幅',
                'banner-size'              => '横幅尺寸（1320px X 300px）',
                'company-name'             => '名称',
                'description'              => '描述',
                'description-and-images'   => '描述和图片',
                'description-only'         => '仅描述',
                'display-mode'             => '显示模式',
                'enter-position'           => '输入位置',
                'filterable-attributes'    => '可筛选属性',
                'general'                  => '常规',
                'logo'                     => '徽标',
                'logo-size'                => '徽标分辨率应为（110px X 110px）',
                'meta-description'         => 'Meta 描述',
                'meta-keywords'            => 'Meta 关键词',
                'meta-title'               => 'Meta 标题',
                'parent-category'          => '父级分类',
                'position'                 => '位置',
                'products-and-description' => '产品和描述',
                'products-only'            => '仅产品',
                'save-btn'                 => '保存分类',
                'select-display-mode'      => '选择显示模式',
                'seo-details'              => 'SEO 详情',
                'settings'                 => '设置',
                'slug'                     => 'Slug',
                'title'                    => '创建新分类',
                'visible-in-menu'          => '在菜单中可见',
            ],

            'edit' => [
                'add-banner'               => '添加横幅',
                'add-logo'                 => '添加徽标',
                'back-btn'                 => '返回',
                'banner'                   => '横幅',
                'banner-size'              => '横幅尺寸（1320px X 300px）',
                'company-name'             => '名称*',
                'description'              => '描述',
                'description-and-images'   => '描述和图片',
                'description-only'         => '仅描述',
                'display-mode'             => '显示模式',
                'enter-position'           => '输入位置',
                'filterable-attributes'    => '可筛选属性',
                'general'                  => '常规',
                'logo'                     => '徽标',
                'logo-size'                => '徽标分辨率应为（110px X 110px）',
                'meta-description'         => 'Meta 描述',
                'meta-keywords'            => 'Meta 关键词',
                'meta-title'               => 'Meta 标题',
                'position'                 => '位置*',
                'products-and-description' => '产品和描述',
                'products-only'            => '仅产品',
                'save-btn'                 => '保存分类',
                'select-display-mode'      => '选择显示模式',
                'select-parent-category'   => '选择父级分类*',
                'seo-details'              => 'SEO 详情',
                'settings'                 => '设置',
                'slug'                     => 'Slug',
                'title'                    => '编辑分类',
                'visible-in-menu'          => '在菜单中可见',
            ],

            'category'             => '分类',
            'create-success'       => '分类创建成功。',
            'delete-category-root' => '无法删除根类别 ',
            'delete-failed'        => '删除类别时发生错误',
            'delete-success'       => '分类已成功删除。',
            'update-success'       => '分类更新成功。',
        ],

        'families' => [
            'index' => [
                'add'   => '创建属性家族',
                'title' => '属性家族',

                'datagrid' => [
                    'code'           => '代码',
                    'delete'         => '删除',
                    'delete-success' => '已成功删除所选 :resource',
                    'edit'           => '编辑',
                    'id'             => 'ID',
                    'method-error'   => '错误！检测到错误的方法，请检查批量操作配置',
                    'name'           => '名称',
                    'no-resource'    => '提供的资源不足以执行操作',
                    'partial-action' => '由于系统约束限制，某些操作未执行',
                    'update-success' => '已成功更新所选 :resource',
                ],
            ],

            'create' => [
                'add-group-btn'                    => '添加分组',
                'add-group-title'                  => '添加新分组',
                'back-btn'                         => '返回',
                'code'                             => '代码',
                'column'                           => '列',
                'delete-group-btn'                 => '删除分组',
                'edit-group-info'                  => '双击编辑分组',
                'enter-code'                       => '输入代码',
                'enter-name'                       => '输入名称',
                'general'                          => '常规',
                'group-code-already-exists'        => '属性组代码已经存在。',
                'group-contains-system-attributes' => '此分组包含系统属性。请先将系统属性移至其他分组，然后重试。',
                'group-name-already-exists'        => '已存在属性分组名称。',
                'groups'                           => '分组',
                'groups-info'                      => '管理属性家族分组',
                'main-column'                      => '主列',
                'name'                             => '名称',
                'removal-not-possible'             => '您无法从属性家族中移除系统属性。',
                'right-column'                     => '右侧列',
                'save-btn'                         => '保存属性家族',
                'select-group'                     => '请选择属性分组。',
                'title'                            => '创建属性家族',
                'unassigned-attributes'            => '未分配的属性',
                'unassigned-attributes-info'       => '拖动这些属性以添加到列或分组中。',
            ],

            'edit' => [
                'add-group-btn'                    => '添加分组',
                'add-group-title'                  => '添加新分组',
                'back-btn'                         => '返回',
                'code'                             => '代码',
                'column'                           => '列',
                'delete-group-btn'                 => '删除分组',
                'edit-group-info'                  => '双击编辑分组',
                'enter-code'                       => '输入代码',
                'enter-name'                       => '输入名称',
                'general'                          => '一般的',
                'group-code-already-exists'        => '属性组代码已经存在。',
                'group-contains-system-attributes' => '此分组包含系统属性。请先将系统属性移至其他分组，然后重试。',
                'group-name-already-exists'        => '已存在属性分组名称。',
                'groups'                           => '分组',
                'groups-info'                      => '管理属性家族分组',
                'main-column'                      => '主列',
                'name'                             => '名称',
                'removal-not-possible'             => '您无法从属性家族中移除系统属性。',
                'right-column'                     => '右侧列',
                'save-btn'                         => '保存属性家族',
                'select-group'                     => '请选择属性分组。',
                'title'                            => '编辑属性家族',
                'unassigned-attributes'            => '未分配的属性',
                'unassigned-attributes-info'       => '拖动这些属性以添加到列或分组中。',
            ],

            'attribute-family'        => '属性家族',
            'attribute-product-error' => '家族在产品中使用。',
            'create-success'          => '成功创建家族。',
            'delete-failed'           => '删除家族时遇到错误。',
            'delete-success'          => '成功删除家族。',
            'family'                  => '属性家族',
            'last-delete-error'       => '至少需要一个家族。',
            'update-success'          => '成功更新家族。',
            'user-define-error'       => '无法删除系统属性家族。',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => '客户',
                'login-message' => '您以 :customer_name 的身份登录',

                'datagrid' => [
                    'active'         => '活跃',
                    'address'        => ':address  地址',
                    'address-count'  => '地址数量',
                    'channel'        => '渠道',
                    'delete'         => '删除',
                    'delete-success' => '成功删除所选数据',
                    'email'          => '电子邮件',
                    'gender'         => '性别',
                    'group'          => '分组',
                    'id'             => '客户 ID',
                    'inactive'       => '不活跃',
                    'method-error'   => '错误！检测到错误的方法，请检查大规模操作配置',
                    'name'           => '客户姓名',
                    'no-resource'    => '提供的资源不足以执行操作',
                    'order'          => ':order 订单',
                    'order-count'    => '订单数量',
                    'order-pending'  => '客户有待处理订单',
                    'partial-action' => '由于 :resource 上的受限制的系统约束，未执行一些操作',
                    'phone'          => '联系号码',
                    'revenue'        => '收入',
                    'status'         => '状态',
                    'suspended'      => '已暂停',
                    'update-status'  => '更新状态',
                    'update-success' => '成功更新所选客户',
                ],

                'create' => [
                    'contact-number'        => '联系号码',
                    'create-btn'            => '创建客户',
                    'create-success'        => '成功创建客户',
                    'customer-group'        => '客户组',
                    'date-of-birth'         => '出生日期',
                    'email'                 => '电子邮件',
                    'female'                => '女性',
                    'first-name'            => '名字',
                    'gender'                => '性别',
                    'last-name'             => '姓氏',
                    'male'                  => '男性',
                    'other'                 => '其他',
                    'save-btn'              => '保存客户',
                    'select-customer-group' => '选择客户组',
                    'select-gender'         => '选择性别',
                    'title'                 => '创建新客户',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => '您确定要删除此账户吗？',
                'active'                      => '活跃',
                'address-delete-confirmation' => '您确定要删除此地址吗？',
                'back-btn'                    => '返回',
                'create-order'                => '创建订单',
                'customer'                    => '客户',
                'date-of-birth'               => '生日 - :dob',
                'default-address'             => '默认地址',
                'delete-account'              => '删除账户',
                'delete'                      => '删除',
                'email'                       => '电子邮件 - :email',
                'empty-description'           => '为客户创建新地址',
                'empty-title'                 => '添加客户地址',
                'gender'                      => '性别 - :gender',
                'group'                       => '分组 - :group_code',
                'inactive'                    => '不活跃',
                'login-as-customer'           => '以客户身份登录',
                'note-created-success'        => '成功创建备注',
                'order-create-confirmation'   => '您确定要为此客户创建订单吗?',
                'phone'                       => '电话 - :phone',
                'set-as-default'              => '设为默认',
                'suspended'                   => '已暂停',
                'title'                       => '客户视图',

                'address' => [
                    'count' => '地址 (:count)',

                    'create' => [
                        'city'               => '城市',
                        'company-name'       => '公司名称',
                        'country'            => '国家',
                        'create-btn'         => '创建',
                        'create-address-btn' => '添加新地址',
                        'default-address'    => '默认地址',
                        'email'              => '电子邮件',
                        'first-name'         => '名字',
                        'last-name'          => '姓氏',
                        'phone'              => '电话',
                        'post-code'          => '邮政编码',
                        'save-btn-title'     => '保存地址',
                        'select-country'     => '选择国家',
                        'state'              => '州',
                        'street-address'     => '街道地址',
                        'title'              => '创建地址',
                        'vat-id'             => 'VAT 号码',
                    ],

                    'edit' => [
                        'city'            => '城市',
                        'company-name'    => '公司名称',
                        'country'         => '国家',
                        'default-address' => '默认地址',
                        'edit-btn'        => '编辑',
                        'email'           => '电子邮件',
                        'first-name'      => '名字',
                        'last-name'       => '姓氏',
                        'phone'           => '电话',
                        'post-code'       => '邮政编码',
                        'save-btn-title'  => '保存地址',
                        'select-country'  => '选择国家',
                        'state'           => '州',
                        'street-address'  => '街道地址',
                        'title'           => '编辑地址',
                        'vat-id'          => 'VAT 号码',
                    ],

                    'address-delete-success' => '成功删除地址',
                    'create-success'         => '成功创建地址',
                    'set-default-success'    => '默认地址更新成功',
                    'success-mass-delete'    => '成功进行地址批量删除',
                    'update-success'         => '成功更新地址',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => '没有评论',
                        'increment-id'   => '发票 ID',
                        'invoice-amount' => '发票金额',
                        'invoice-date'   => '发票日期',
                        'order-id'       => '订单 ID',
                        'view'           => '查看',
                    ],

                    'orders' => [
                        'canceled'        => '已取消',
                        'channel-name'    => '渠道名称',
                        'closed'          => '已关闭',
                        'completed'       => '已完成',
                        'customer-name'   => '客户姓名',
                        'date'            => '日期',
                        'empty-order'     => '没有订单',
                        'email'           => '电子邮件',
                        'fraud'           => '欺诈',
                        'grand-total'     => '总计',
                        'location'        => '位置',
                        'order-id'        => '订单 ID',
                        'pay-via'         => '支付方式',
                        'pending'         => '待处理',
                        'pending-payment' => '待付款',
                        'processing'      => '处理中',
                        'status'          => '状态',
                        'view'            => '查看',
                    ],

                    'reviews' => [
                        'approved'      => '已批准',
                        'comment'       => '评论',
                        'created-at'    => '创建于',
                        'disapproved'   => '未批准',
                        'empty-reviews' => '没有发票',
                        'id'            => 'ID',
                        'invoice-date'  => '发票日期',
                        'pending'       => '待处理',
                        'product-id'    => '产品 ID',
                        'product-name'  => '产品名称',
                        'rating'        => '评分',
                        'status'        => '状态',
                        'title'         => '标题',
                    ],
                ],

                'edit' => [
                    'contact-number'        => '联系号码',
                    'customer-group'        => '客户组',
                    'date-of-birth'         => '出生日期',
                    'edit-btn'              => '编辑',
                    'email'                 => '电子邮件',
                    'female'                => '女性',
                    'first-name'            => '名字',
                    'gender'                => '性别',
                    'last-name'             => '姓氏',
                    'male'                  => '男性',
                    'other'                 => '其他',
                    'save-btn'              => '保存客户',
                    'select-customer-group' => '选择客户组',
                    'select-gender'         => '选择性别',
                    'status'                => '状态',
                    'suspended'             => '已暂停',
                    'title'                 => '编辑客户',
                ],

                'invoices' => [
                    'count'        => '发票 (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => '添加备注',
                    'customer-not-notified' => ':date | 客户 <b>未通知</b>',
                    'customer-notified'     => ':date | 客户 <b>已通知</b>',
                    'note'                  => '备注',
                    'note-placeholder'      => '在这里写下您的备注',
                    'notify-customer'       => '通知客户',
                    'submit-btn-title'      => '提交备注',
                ],

                'orders' => [
                    'count'         => '订单 (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => '总收入 - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => '评论 (:count)',
                ],

                'cart' => [
                    'delete-success' => '成功删除购物车商品。',
                ],

                'wishlist' => [
                    'delete-success' => '成功删除心愿单商品。',
                ],

                'compare' => [
                    'delete-success' => '成功删除对比商品。',
                ],
            ],

            'delete-failed'  => '删除客户失败',
            'delete-success' => '成功删除客户',
            'order-pending'  => '订单待处理',
            'update-success' => '成功更新客户',
        ],

        'groups' => [
            'index' => [
                'title' => '分组',

                'create' => [
                    'code'       => '代码',
                    'create-btn' => '创建分组',
                    'name'       => '名称',
                    'save-btn'   => '保存分组',
                    'success'    => '分组创建成功',
                    'title'      => '创建新分组',
                ],

                'edit' => [
                    'delete-failed'  => '分组删除失败',
                    'delete-success' => '分组删除成功',
                    'group-default'  => '默认分组无法删除',
                    'success'        => '分组更新成功',
                    'title'          => '编辑分组',
                ],

                'datagrid' => [
                    'code'   => '代码',
                    'delete' => '删除',
                    'edit'   => '编辑',
                    'id'     => 'ID',
                    'name'   => '名称',
                ],
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => '日期',
                'description' => '描述',
                'id'          => 'ID',
                'name'        => '姓名',
                'product'     => '产品',
                'rating'      => '评分',
                'status'      => '状态',
                'title'       => '评论',

                'edit' => [
                    'approved'       => '已批准',
                    'customer'       => '顾客',
                    'date'           => '日期',
                    'disapproved'    => '未批准',
                    'id'             => 'ID',
                    'images'         => '图片',
                    'pending'        => '待处理',
                    'product'        => '产品',
                    'rating'         => '评分',
                    'review-comment' => '评论',
                    'review-title'   => '标题',
                    'save-btn'       => '保存',
                    'status'         => '状态',
                    'title'          => '编辑评论',
                    'update-success' => '更新成功',
                ],

                'datagrid' => [
                    'approved'            => '已批准',
                    'comment'             => '评论',
                    'customer-names'      => '姓名',
                    'date'                => '日期',
                    'delete'              => '删除',
                    'delete-success'      => '评论删除成功',
                    'disapproved'         => '未批准',
                    'edit'                => '编辑',
                    'id'                  => 'ID',
                    'mass-delete-error'   => '出现了一些问题',
                    'mass-delete-success' => '所选评论删除成功',
                    'mass-update-success' => '所选评论更新成功',
                    'pending'             => '待处理',
                    'product'             => '产品',
                    'rating'              => '评分',
                    'review-id'           => 'ID - :review_id',
                    'status'              => '状态',
                    'title'               => '标题',
                    'update-status'       => '更新状态',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => '创建模板',
                    'title'      => '电子邮件模板',

                    'datagrid' => [
                        'active'   => '激活',
                        'draft'    => '草稿',
                        'id'       => 'ID',
                        'inactive' => '未激活',
                        'name'     => '名称',
                        'status'   => '状态',
                    ],
                ],

                'create' => [
                    'active'         => '激活',
                    'back-btn'       => '返回',
                    'content'        => '内容',
                    'create-success' => '电子邮件模板创建成功。',
                    'draft'          => '草稿',
                    'general'        => '常规',
                    'inactive'       => '未激活',
                    'name'           => '名称',
                    'save-btn'       => '保存模板',
                    'select-status'  => '选择状态',
                    'status'         => '状态',
                    'title'          => '创建模板',
                ],

                'edit' => [
                    'active'         => '激活',
                    'back-btn'       => '返回',
                    'content'        => '内容*',
                    'draft'          => '草稿',
                    'general'        => '常规',
                    'inactive'       => '未激活',
                    'name'           => '名称',
                    'save-btn'       => '保存模板',
                    'status'         => '状态',
                    'title'          => '编辑模板',
                    'update-success' => '更新成功',
                ],

                'delete-failed'  => ':name 删除失败',
                'delete-success' => '模板删除成功',
                'email-template' => '电子邮件模板',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => '创建活动',
                    'title'      => '活动',

                    'datagrid' => [
                        'active'   => '激活',
                        'delete'   => '删除',
                        'edit'     => '编辑',
                        'id'       => 'ID',
                        'inactive' => '未激活',
                        'name'     => '名称',
                        'status'   => '状态',
                        'subject'  => '主题',
                    ],
                ],

                'create' => [
                    'active'          => '激活',
                    'back-btn'        => '返回',
                    'channel'         => '渠道',
                    'customer-group'  => '顾客组',
                    'email-template'  => '电子邮件模板',
                    'event'           => '事件',
                    'general'         => '常规',
                    'inactive'        => '未激活',
                    'name'            => '名称',
                    'save-btn'        => '保存活动',
                    'select-channel'  => '选择频道',
                    'select-event'    => '选择事件',
                    'select-group'    => '选择群组',
                    'select-status'   => '选择状态',
                    'select-template' => '选择模板',
                    'setting'         => '设置',
                    'status'          => '状态',
                    'subject'         => '主题',
                    'title'           => '创建活动',
                ],

                'edit' => [
                    'active'          => '激活',
                    'audience'        => '受众',
                    'back-btn'        => '返回',
                    'channel'         => '渠道',
                    'customer-group'  => '顾客组',
                    'email-template'  => '电子邮件模板',
                    'event'           => '事件',
                    'general'         => '常规',
                    'inactive'        => '未激活',
                    'name'            => '名称',
                    'save-btn'        => '保存活动',
                    'select-event'    => '选择事件',
                    'select-status'   => '选择状态',
                    'select-template' => '选择模板',
                    'status'          => '状态',
                    'subject'         => '主题',
                    'title'           => '编辑活动',
                ],

                'create-success' => '活动创建成功。',
                'delete-failed'  => ':name 删除失败',
                'delete-success' => '活动删除成功',
                'email-campaign' => '电子邮件活动',
                'update-success' => '活动更新成功。',
            ],

            'events' => [
                'index' => [
                    'create-btn' => '创建事件',
                    'event'      => '事件',
                    'title'      => '事件',

                    'datagrid' => [
                        'actions' => '操作',
                        'date'    => '日期',
                        'delete'  => '删除',
                        'edit'    => '编辑',
                        'id'      => 'ID',
                        'name'    => '名称',
                    ],

                    'create' => [
                        'date'           => '日期',
                        'delete-warning' => '您确定要执行此操作吗？',
                        'description'    => '描述',
                        'general'        => '常规',
                        'name'           => '名称',
                        'save-btn'       => '保存事件',
                        'success'        => '事件创建成功',
                        'title'          => '创建事件',
                    ],

                    'edit' => [
                        'success' => '事件更新成功',
                        'title'   => '编辑事件',
                    ],
                ],

                'delete-failed'  => ':name 删除失败',
                'delete-success' => '事件删除成功',
                'edit-error'     => '事件无法编辑',
            ],

            'subscribers' => [
                'index' => [
                    'title' => '通讯订阅',

                    'datagrid' => [
                        'actions'    => '操作',
                        'delete'     => '删除',
                        'edit'       => '编辑',
                        'email'      => '电子邮件',
                        'false'      => '否',
                        'id'         => 'ID',
                        'subscribed' => '已订阅',
                        'true'       => '是',
                    ],

                    'edit' => [
                        'back-btn'      => '返回',
                        'email'         => '电子邮件',
                        'false'         => '否',
                        'save-btn'      => '保存订阅者',
                        'subscribed'    => '已订阅',
                        'success'       => '通讯订阅更新成功',
                        'title'         => '编辑通讯订阅者',
                        'true'          => '是',
                        'update-failed' => '通讯订阅未更新',
                    ],
                ],

                'delete-failed'  => '订阅者删除失败',
                'delete-success' => '订阅者删除成功',
                'delete-warning' => '您确定要执行此操作吗？',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => '购物车规则',
                'catalog-rule-title' => '产品目录规则',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => '创建购物车规则',
                    'title'      => '购物车规则',

                    'datagrid' => [
                        'active'      => '活动',
                        'copy'        => '复制z',
                        'copy-of'     => ':value',
                        'coupon-code' => '优惠券码',
                        'delete'      => '删除',
                        'draft'       => '草稿',
                        'edit'        => '编辑',
                        'end'         => '结束',
                        'id'          => 'ID',
                        'inactive'    => '不活动',
                        'name'        => '名称',
                        'priority'    => '优先级',
                        'start'       => '开始',
                        'status'      => '状态',
                    ],
                ],

                'create' => [
                    'action-type'                               => '操作类型',
                    'actions'                                   => '操作',
                    'add-condition'                             => '添加条件',
                    'additional'                                => '附加',
                    'all-conditions-true'                       => '所有条件为真',
                    'any-conditions-true'                       => '任意条件为真',
                    'apply-to-shipping'                         => '应用于运费',
                    'attribute-family'                          => '属性系列',
                    'attribute-name-children-only'              => '仅限子类别的属性名称',
                    'attribute-name-parent-only'                => '仅限父类别的属性名称',
                    'auto-generate-coupon'                      => '自动生成优惠券',
                    'back-btn'                                  => '返回',
                    'buy-x-get-y-free'                          => '买 X 送 Y',
                    'buy-x-quantity'                            => '买 X 数量',
                    'cart-attribute'                            => '购物车属性',
                    'cart-item-attribute'                       => '购物车项目属性',
                    'categories'                                => '类别',
                    'channels'                                  => '渠道',
                    'children-categories'                       => '子类别',
                    'choose-condition-to-add'                   => '选择要添加的条件',
                    'condition-type'                            => '条件类型',
                    'conditions'                                => '条件',
                    'contain'                                   => '包含',
                    'contains'                                  => '包含',
                    'coupon-code'                               => '优惠券码',
                    'coupon-type'                               => '优惠券类型',
                    'create-success'                            => '购物车规则创建成功',
                    'customer-groups'                           => '顾客群体',
                    'description'                               => '描述',
                    'discount-amount'                           => '折扣金额',
                    'does-not-contain'                          => '不包含',
                    'end-of-other-rules'                        => '结束其他规则',
                    'equals-or-greater-than'                    => '等于或大于',
                    'equals-or-less-than'                       => '等于或小于',
                    'fixed-amount'                              => '固定金额',
                    'fixed-amount-whole-cart'                   => '整个购物车的固定金额',
                    'free-shipping'                             => '免费运费',
                    'from'                                      => '从',
                    'general'                                   => '通用',
                    'greater-than'                              => '大于',
                    'is-equal-to'                               => '等于',
                    'is-not-equal-to'                           => '不等于',
                    'less-than'                                 => '小于',
                    'marketing-time'                            => '营销时间',
                    'maximum-quantity-allowed-to-be-discounted' => '允许折扣的最大数量',
                    'name'                                      => '名称',
                    'no'                                        => '否',
                    'no-coupon'                                 => '无优惠券',
                    'parent-categories'                         => '父类别',
                    'payment-method'                            => '支付方式',
                    'percentage-product-price'                  => '产品价格百分比',
                    'price-in-cart'                             => '购物车中的价格',
                    'priority'                                  => '优先级',
                    'product-attribute'                         => '产品属性',
                    'qty-in-cart'                               => '购物车中的数量',
                    'save-btn'                                  => '保存购物车规则',
                    'settings'                                  => '设置',
                    'shipping-country'                          => '运费国家',
                    'shipping-method'                           => '运送方式',
                    'shipping-postcode'                         => '运费邮编',
                    'shipping-state'                            => '运费州',
                    'specific-coupon'                           => '特定优惠券',
                    'status'                                    => '状态',
                    'subtotal'                                  => '小计',
                    'title'                                     => '创建购物车规则',
                    'to'                                        => '到',
                    'total-items-qty'                           => '总项目数量',
                    'total-weight'                              => '总重量',
                    'uses-per-coupon'                           => '每张优惠券使用次数',
                    'uses-per-customer'                         => '每位顾客使用次数',
                    'uses-per-customer-control-info'            => '仅适用于已登录的顾客。',
                    'yes'                                       => '是',
                ],

                'edit' => [
                    'action-type'                               => '操作类型',
                    'actions'                                   => '操作',
                    'add-condition'                             => '添加条件',
                    'additional'                                => '附加',
                    'all-conditions-true'                       => '所有条件为真',
                    'alphabetical'                              => '字母',
                    'alphanumeric'                              => '字母数字混合',
                    'any-conditions-true'                       => '任意条件为真',
                    'apply-to-shipping'                         => '应用于运费',
                    'attribute-family'                          => '属性系列',
                    'attribute-name-children-only'              => '仅限子类别的属性名称',
                    'attribute-name-parent-only'                => '仅限父类别的属性名称',
                    'auto-generate-coupon'                      => '自动生成优惠券',
                    'back-btn'                                  => '返回',
                    'buy-x-get-y-free'                          => '买 X 送 Y',
                    'buy-x-quantity'                            => '买 X 数量',
                    'cart-attribute'                            => '购物车属性',
                    'cart-item-attribute'                       => '购物车项目属性',
                    'categories'                                => '类别',
                    'channels'                                  => '渠道',
                    'children-categories'                       => '子类别',
                    'choose-condition-to-add'                   => '选择要添加的条件',
                    'code-format'                               => '代码格式',
                    'code-prefix'                               => '代码前缀',
                    'code-suffix'                               => '代码后缀',
                    'condition-type'                            => '条件类型',
                    'conditions'                                => '条件',
                    'contain'                                   => '包含',
                    'contains'                                  => '包含',
                    'coupon-code'                               => '优惠券码',
                    'coupon-length'                             => '优惠券长度',
                    'coupon-qty'                                => '优惠券数量',
                    'coupon-type'                               => '优惠券类型',
                    'customer-group'                            => '顾客群体',
                    'customer-groups'                           => '顾客群体',
                    'description'                               => '描述',
                    'discount-amount'                           => '折扣金额',
                    'does-not-contain'                          => '不包含',
                    'end-of-other-rules'                        => '结束其他规则',
                    'equals-or-greater-than'                    => '等于或大于',
                    'equals-or-less-than'                       => '等于或小于',
                    'fixed-amount'                              => '固定金额',
                    'fixed-amount-whole-cart'                   => '整个购物车的固定金额',
                    'free-shipping'                             => '免费运费',
                    'from'                                      => '从',
                    'general'                                   => '通用',
                    'generate'                                  => '生成',
                    'greater-than'                              => '大于',
                    'is-equal-to'                               => '等于',
                    'is-not-equal-to'                           => '不等于',
                    'less-than'                                 => '小于',
                    'marketing-time'                            => '营销时间',
                    'maximum-quantity-allowed-to-be-discounted' => '允许折扣的最大数量',
                    'name'                                      => '名称',
                    'no'                                        => '否',
                    'no-coupon'                                 => '无优惠券',
                    'numeric'                                   => '数字',
                    'parent-categories'                         => '父类别',
                    'payment-method'                            => '支付方式',
                    'percentage-product-price'                  => '产品价格百分比',
                    'price-in-cart'                             => '购物车中的价格',
                    'priority'                                  => '优先级',
                    'product-attribute'                         => '产品属性',
                    'qty-in-cart'                               => '购物车中的数量',
                    'save-btn'                                  => '保存购物车规则',
                    'settings'                                  => '设置',
                    'shipping-country'                          => '运费国家',
                    'shipping-method'                           => '运送方式',
                    'shipping-postcode'                         => '运费邮编',
                    'shipping-state'                            => '运费州',
                    'specific-coupon'                           => '特定优惠券',
                    'status'                                    => '状态',
                    'subtotal'                                  => '小计',
                    'title'                                     => '编辑购物车规则',
                    'to'                                        => '到',
                    'total-items-qty'                           => '总项目数量',
                    'total-weight'                              => '总重量',
                    'update-success'                            => '购物车规则更新成功',
                    'uses-per-coupon'                           => '每张优惠券使用次数',
                    'uses-per-customer'                         => '每位顾客使用次数',
                    'uses-per-customer-control-info'            => '仅适用于已登录的顾客。',
                    'yes'                                       => '是',
                ],

                'delete-failed'  => '购物车规则删除失败',
                'delete-success' => '购物车规则删除成功',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => '创建目录规则',
                    'title'      => '目录规则',

                    'datagrid' => [
                        'active'   => '活动',
                        'delete'   => '删除',
                        'edit'     => '编辑',
                        'end'      => '结束',
                        'id'       => 'ID',
                        'inactive' => '不活动',
                        'name'     => '名称',
                        'priority' => '优先级',
                        'start'    => '开始',
                        'status'   => '状态',
                    ],
                ],

                'create' => [
                    'action-type'              => '操作类型',
                    'actions'                  => '操作',
                    'add-condition'            => '添加条件',
                    'all-conditions-true'      => '所有条件为真',
                    'any-conditions-true'      => '任意条件为真',
                    'attribute-family'         => '属性系列',
                    'back-btn'                 => '返回',
                    'categories'               => '类别',
                    'channels'                 => '渠道',
                    'choose-condition-to-add'  => '选择要添加的条件',
                    'condition-type'           => '条件类型',
                    'conditions'               => '条件',
                    'contain'                  => '包含',
                    'contains'                 => '包含',
                    'customer-groups'          => '顾客群体',
                    'description'              => '描述',
                    'discount-amount'          => '折扣金额',
                    'does-not-contain'         => '不包含',
                    'end-other-rules'          => '结束其他规则',
                    'equals-or-greater-than'   => '等于或大于',
                    'equals-or-less-than'      => '等于或小于',
                    'fixed-amount'             => '固定金额',
                    'from'                     => '从',
                    'general'                  => '通用',
                    'greater-than'             => '大于',
                    'is-equal-to'              => '等于',
                    'is-not-equal-to'          => '不等于',
                    'less-than'                => '小于',
                    'marketing-time'           => '营销时间',
                    'name'                     => '名称',
                    'no'                       => '否',
                    'percentage-product-price' => '产品价格百分比',
                    'priority'                 => '优先级',
                    'product-attribute'        => '产品属性',
                    'save-btn'                 => '保存目录规则',
                    'settings'                 => '设置',
                    'status'                   => '状态',
                    'title'                    => '创建目录规则',
                    'to'                       => '到',
                    'yes'                      => '是',
                ],

                'edit' => [
                    'action-type'              => '操作类型',
                    'actions'                  => '操作',
                    'add-condition'            => '添加条件',
                    'all-conditions-true'      => '所有条件为真',
                    'any-conditions-true'      => '任意条件为真',
                    'back-btn'                 => '返回',
                    'categories'               => '类别',
                    'channels'                 => '渠道',
                    'choose-condition-to-add'  => '选择要添加的条件',
                    'condition-type'           => '条件类型',
                    'conditions'               => '条件',
                    'contain'                  => '包含',
                    'contains'                 => '包含',
                    'customer-groups'          => '顾客群体',
                    'description'              => '描述',
                    'discount-amount'          => '折扣金额',
                    'does-not-contain'         => '不包含',
                    'end-other-rules'          => '结束其他规则',
                    'equals-or-greater-than'   => '等于或大于',
                    'equals-or-less-than'      => '等于或小于',
                    'fixed-amount'             => '固定金额',
                    'from'                     => '从',
                    'general'                  => '通用',
                    'greater-than'             => '大于',
                    'is-equal-to'              => '等于',
                    'is-not-equal-to'          => '不等于',
                    'less-than'                => '小于',
                    'marketing-time'           => '营销时间',
                    'name'                     => '名称',
                    'no'                       => '否',
                    'percentage-product-price' => '产品价格百分比',
                    'priority'                 => '优先级',
                    'product-attribute'        => '产品属性',
                    'save-btn'                 => '保存目录规则',
                    'settings'                 => '设置',
                    'status'                   => '状态',
                    'title'                    => '编辑目录规则',
                    'to'                       => '到',
                    'yes'                      => '是',
                ],

                'create-success' => '目录规则创建成功',
                'delete-success' => '目录规则删除成功',
                'update-success' => '目录规则更新成功',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => '购物车规则无法删除',
                'delete-success'              => '购物车规则优惠券成功删除',
                'mass-delete-success'         => '成功删除所选项目',
                'success'                     => '成功创建 :name',

                'datagrid' => [
                    'coupon-code'     => '优惠券代码',
                    'created-date'    => '创建日期',
                    'delete'          => '删除',
                    'expiration-date' => '到期日期',
                    'id'              => 'ID',
                    'times-used'      => '使用次数',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => '创建新搜索词条',
                    'title'      => '搜索词条',

                    'datagrid' => [
                        'actions'             => '操作',
                        'channel'             => '频道',
                        'delete'              => '删除',
                        'edit'                => '编辑',
                        'id'                  => 'ID',
                        'locale'              => '本地化',
                        'mass-delete-success' => '已成功删除选定的搜索词条',
                        'redirect-url'        => '重定向 URL',
                        'results'             => '结果',
                        'search-query'        => '搜索查询',
                        'uses'                => '使用',
                    ],

                    'create' => [
                        'channel'        => '频道',
                        'delete-warning' => '您确定要执行此操作吗？',
                        'locale'         => '本地化',
                        'redirect-url'   => '重定向 URL',
                        'results'        => '结果',
                        'save-btn'       => '保存搜索词条',
                        'search-query'   => '搜索查询',
                        'success'        => '搜索词条已成功创建',
                        'title'          => '创建新搜索词条',
                        'uses'           => '使用',
                    ],

                    'edit' => [
                        'delete-success' => '搜索词条已成功删除',
                        'success'        => '搜索词条已成功更新',
                        'title'          => '编辑搜索词条',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => '创建搜索同义词',
                    'title'      => '搜索同义词',

                    'datagrid' => [
                        'actions'             => '操作',
                        'delete'              => '删除',
                        'edit'                => '编辑',
                        'id'                  => '标识',
                        'mass-delete-success' => '成功删除所选的搜索同义词',
                        'name'                => '名称',
                        'terms'               => '术语',
                    ],

                    'create' => [
                        'delete-warning' => '您确定要执行此操作吗？',
                        'name'           => '名称',
                        'save-btn'       => '保存搜索同义词',
                        'success'        => '成功创建搜索同义词',
                        'terms'          => '术语',
                        'terms-info'     => '将同义词输入为以逗号分隔的列表，例如“鞋子，鞋类”。这扩展了搜索以包括所有术语。',
                        'title'          => '创建搜索同义词',
                    ],

                    'edit' => [
                        'delete-success' => '成功删除搜索同义词',
                        'success'        => '成功更新搜索同义词',
                        'title'          => '编辑搜索同义词',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => '创建站点地图',
                    'sitemap'    => '站点地图',
                    'title'      => '站点地图',

                    'datagrid' => [
                        'actions'         => '操作',
                        'delete'          => '删除',
                        'edit'            => '编辑',
                        'file-name'       => '文件名',
                        'id'              => 'ID',
                        'link-for-google' => 'Google链接',
                        'path'            => '路径',
                    ],

                    'create' => [
                        'delete-warning' => '您确定要执行此操作吗？',
                        'file-name'      => '文件名',
                        'file-name-info' => '示例：sitemap.xml',
                        'path'           => '路径',
                        'path-info'      => '示例："/sitemap/" 或 "/" 用于基本路径',
                        'save-btn'       => '保存站点地图',
                        'success'        => '站点地图创建成功',
                        'title'          => '创建站点地图',
                    ],

                    'edit' => [
                        'delete-success' => '站点地图删除成功',
                        'success'        => '站点地图更新成功',
                        'title'          => '编辑站点地图',
                    ],
                ],

                'edit' => [
                    'back-btn'       => '返回',
                    'file-name'      => '文件名',
                    'file-name-info' => '示例：sitemap.xml',
                    'general'        => '通用',
                    'path'           => '路径',
                    'path-info'      => '示例："/sitemap/" 或 "/" 用于基本路径',
                    'save-btn'       => '保存站点地图',
                ],

                'delete-failed' => ':name 删除失败',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => '创建 URL 重写',
                    'title'      => 'URL 重写',

                    'datagrid' => [
                        'actions'             => '操作',
                        'category'            => '类别',
                        'cms-page'            => 'CMS 页面',
                        'delete'              => '删除',
                        'edit'                => '编辑',
                        'for'                 => '适用对象',
                        'id'                  => 'ID',
                        'locale'              => '语言环境',
                        'mass-delete-success' => '已成功删除选定的 URL 重写。',
                        'permanent-redirect'  => '永久（301）',
                        'product'             => '产品',
                        'redirect-type'       => '重定向类型',
                        'request-path'        => '请求路径',
                        'target-path'         => '目标路径',
                        'temporary-redirect'  => '临时（302）',
                    ],

                    'create' => [
                        'category'           => '类别',
                        'cms-page'           => 'CMS 页面',
                        'delete-warning'     => '您确定要执行此操作吗？',
                        'for'                => '适用对象',
                        'locale'             => '语言环境',
                        'permanent-redirect' => '永久（301）',
                        'product'            => '产品',
                        'redirect-type'      => '重定向类型',
                        'request-path'       => '请求路径',
                        'save-btn'           => '保存 URL 重写',
                        'success'            => '已成功创建 URL 重写。',
                        'target-path'        => '目标路径',
                        'temporary-redirect' => '临时（302）',
                        'title'              => '创建 URL 重写',
                    ],

                    'edit' => [
                        'delete-success' => '已成功删除 URL 重写。',
                        'success'        => '已成功更新 URL 重写。',
                        'title'          => '编辑 URL 重写',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => '该 :name 已被使用。',
            'channel'       => '渠道',
            'create-btn'    => '创建页面',
            'language'      => '语言',
            'title'         => '页面',

            'datagrid' => [
                'channel'             => '渠道',
                'delete'              => '删除',
                'edit'                => '编辑',
                'id'                  => 'ID',
                'mass-delete-success' => '所选数据已成功删除',
                'page-title'          => '页面标题',
                'url-key'             => 'URL键',
                'view'                => '查看',
            ],
        ],

        'create' => [
            'channels'         => '渠道',
            'content'          => '内容',
            'description'      => '描述',
            'general'          => '常规',
            'meta-description' => 'Meta描述',
            'meta-keywords'    => 'Meta关键词',
            'meta-title'       => 'Meta标题',
            'page-title'       => '标题',
            'save-btn'         => '保存页面',
            'seo'              => 'SEO',
            'title'            => '创建页面',
            'url-key'          => 'URL键',
        ],

        'edit' => [
            'back-btn'         => '返回',
            'channels'         => '渠道',
            'content'          => '内容',
            'description'      => '描述',
            'general'          => '常规',
            'meta-description' => 'Meta描述',
            'meta-keywords'    => 'Meta关键词',
            'meta-title'       => 'Meta标题',
            'page-title'       => '页面标题',
            'preview-btn'      => '预览页面',
            'save-btn'         => '保存页面',
            'seo'              => 'SEO',
            'title'            => '编辑页面',
            'url-key'          => 'URL键',
        ],

        'create-success' => 'CMS页面创建成功。',
        'delete-success' => 'CMS页面删除成功。',
        'no-resource'    => '资源不存在。',
        'update-success' => 'CMS页面更新成功。',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => '创建区域',
                'locale'     => '区域',
                'logo-size'  => '图像分辨率应该为24px x 16px',
                'title'      => '区域',

                'datagrid' => [
                    'actions'   => '操作',
                    'code'      => '代码',
                    'delete'    => '删除',
                    'direction' => '方向',
                    'edit'      => '编辑',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => '名称',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => '代码',
                    'direction'        => '方向',
                    'locale-logo'      => '区域标志',
                    'name'             => '名称',
                    'save-btn'         => '保存区域',
                    'select-direction' => '选择方向',
                    'title'            => '创建区域',
                ],

                'edit' => [
                    'title' => '编辑区域',
                ],

                'create-success'    => '区域创建成功。',
                'delete-failed'     => '区域删除失败',
                'delete-success'    => '区域删除成功。',
                'delete-warning'    => '确定要执行此操作吗？',
                'last-delete-error' => '至少需要一个区域。',
                'update-success'    => '区域更新成功。',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => '创建货币',
                'currency'   => '货币',
                'title'      => '货币',

                'datagrid' => [
                    'actions'        => '操作',
                    'code'           => '代码',
                    'delete'         => '删除',
                    'edit'           => '编辑',
                    'id'             => 'ID',
                    'method-error'   => '错误！检测到错误的方法，请检查批量操作配置',
                    'name'           => '名称',
                    'no-resource'    => '提供的资源不足以执行此操作',
                    'partial-action' => '由于系统对 :resource 的限制，未执行某些操作',
                    'update-success' => '已成功更新选定的 :resource',
                ],

                'create' => [
                    'code'              => '代码',
                    'create-btn'        => '创建货币',
                    'currency-position' => '货币位置',
                    'decimal'           => '小数',
                    'decimal-separator' => '小数点分隔符',
                    'delete-warning'    => '确定要执行此操作吗？',
                    'general'           => '常规',
                    'group-separator'   => '分组分隔符',
                    'name'              => '名称',
                    'save-btn'          => '保存货币',
                    'symbol'            => '符号',
                    'title'             => '创建新货币',
                ],

                'edit' => [
                    'title' => '编辑货币',
                ],

                'create-success'    => '货币创建成功。',
                'delete-failed'     => '货币删除失败',
                'delete-success'    => '货币删除成功。',
                'last-delete-error' => '至少需要一个货币。',
                'update-success'    => '货币更新成功。',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => '動作',
                    'allowed-errors'      => '允許的錯誤',
                    'back-btn'            => '返回',
                    'create-update'       => '建立/更新',
                    'delete'              => '刪除',
                    'download-sample'     => '下載範例',
                    'field-separator'     => '欄位分隔符',
                    'file'                => '檔案',
                    'file-info'           => '使用相對於 /project-root/storage/app/import 的路徑，例如 product-images, import-images。',
                    'file-info-example'   => '例如，在 product-images 的情況下，檔案應放置在 /project-root/storage/app/import/product-images 資料夾中。',
                    'general'             => '一般',
                    'images-directory'    => '圖片目錄路徑',
                    'process-in-queue'    => '佇列中處理',
                    'results'             => '結果',
                    'save-btn'            => '儲存匯入',
                    'settings'            => '設定',
                    'skip-errors'         => '跳過錯誤',
                    'stop-on-errors'      => '在發生錯誤時停止',
                    'title'               => '建立匯入',
                    'type'                => '類型',
                    'validation-strategy' => '驗證策略',
                ],

                'edit' => [
                    'action'              => '動作',
                    'allowed-errors'      => '允許的錯誤',
                    'back-btn'            => '返回',
                    'create-update'       => '建立/更新',
                    'delete'              => '刪除',
                    'download-sample'     => '下載範例',
                    'field-separator'     => '欄位分隔符',
                    'file'                => '檔案',
                    'file-info'           => '使用相對於 /project-root/storage/app/import 的路徑，例如 product-images, import-images。',
                    'file-info-example'   => '例如，在 product-images 的情況下，檔案應放置在 /project-root/storage/app/import/product-images 資料夾中。',
                    'general'             => '一般',
                    'images-directory'    => '圖片目錄路徑',
                    'process-in-queue'    => '佇列中處理',
                    'results'             => '結果',
                    'save-btn'            => '儲存匯入',
                    'settings'            => '設定',
                    'skip-errors'         => '跳過錯誤',
                    'stop-on-errors'      => '在發生錯誤時停止',
                    'title'               => '編輯匯入',
                    'type'                => '類型',
                    'validation-strategy' => '驗證策略',
                ],

                'index' => [
                    'button-title' => '建立匯入',
                    'title'        => '匯入',

                    'datagrid' => [
                        'actions'       => '動作',
                        'completed-at'  => '已完成於',
                        'created'       => '已建立',
                        'delete'        => '刪除',
                        'deleted'       => '已刪除',
                        'edit'          => '編輯',
                        'error-file'    => '錯誤檔案',
                        'id'            => 'ID',
                        'started-at'    => '已開始於',
                        'state'         => '狀態',
                        'summary'       => '摘要',
                        'updated'       => '已更新',
                        'uploaded-file' => '已上傳的檔案',
                    ],
                ],

                'import' => [
                    'back-btn'                => '返回',
                    'completed-batches'       => '已完成的批次：',
                    'download-error-report'   => '下載完整報告',
                    'edit-btn'                => '編輯',
                    'imported-info'           => '恭喜！您的匯入已成功完成。',
                    'importing-info'          => '匯入處理中',
                    'indexing-info'           => '價格、庫存和 Elasticsearch 索引中的資源處理中',
                    'linking-info'            => '資源連結中',
                    'progress'                => '進度：',
                    'title'                   => '匯入',
                    'total-batches'           => '總批次：',
                    'total-created'           => '已建立記錄：',
                    'total-deleted'           => '已刪除記錄：',
                    'total-errors'            => '總錯誤：',
                    'total-invalid-rows'      => '無效的行數：',
                    'total-rows-processed'    => '處理的行數：',
                    'total-updated'           => '已更新記錄：',
                    'validate-info'           => '按一下 „驗證數據“ 以檢查您的匯入。',
                    'validate'                => '驗證',
                    'validating-info'         => '數據開始閱讀和驗證',
                    'validation-failed-info'  => '您的匯入無效。請修正以下錯誤並再試一次。',
                    'validation-success-info' => '您的匯入有效。按一下 „匯入“ 以開始匯入過程。',
                ],

                'create-success'    => '已成功建立匯入。',
                'delete-failed'     => '匯入刪除失敗。',
                'delete-success'    => '已成功刪除匯入。',
                'not-valid'         => '匯入無效',
                'nothing-to-import' => '沒有要匯入的資源。',
                'setup-queue-error' => '請將您的佇列驅動程序更改為 „database“ 或 „redis“，以開始匯入過程。',
                'update-success'    => '已成功更新匯入。',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => '创建汇率',
                'exchange-rate' => '汇率',
                'title'         => '汇率',
                'update-rates'  => '更新汇率',

                'create' => [
                    'delete-warning'         => '确定要执行此操作吗？',
                    'rate'                   => '汇率',
                    'save-btn'               => '保存汇率',
                    'select-target-currency' => '选择目标货币',
                    'source-currency'        => '源货币',
                    'target-currency'        => '目标货币',
                    'title'                  => '创建汇率',
                ],

                'edit' => [
                    'title' => '编辑汇率',
                ],

                'datagrid' => [
                    'actions'       => '操作',
                    'currency-name' => '货币名称',
                    'delete'        => '删除',
                    'edit'          => '编辑',
                    'exchange-rate' => '汇率',
                    'id'            => 'ID',
                ],

                'create-success'  => '汇率创建成功',
                'delete-error'    => '汇率删除失败',
                'delete-success'  => '汇率删除成功',
                'update-success'  => '汇率更新成功',
            ],
        ],

        'inventory-sources' => [
            'index' => [
                'create-btn' => '创建库存源',
                'title'      => '库存来源',

                'datagrid' => [
                    'active'   => '激活',
                    'code'     => '代码',
                    'delete'   => '删除',
                    'edit'     => '编辑',
                    'id'       => 'ID',
                    'inactive' => '未激活',
                    'name'     => '名称',
                    'priority' => '优先级',
                    'status'   => '状态',
                ],
            ],

            'create' => [
                'add-title'      => '添加库存来源',
                'address'        => '来源地址',
                'back-btn'       => '返回',
                'city'           => '城市',
                'code'           => '代码',
                'contact-email'  => '电子邮件',
                'contact-fax'    => '传真',
                'contact-info'   => '联系信息',
                'contact-name'   => '名称',
                'contact-number' => '联系电话',
                'country'        => '国家',
                'description'    => '描述',
                'general'        => '常规',
                'latitude'       => '纬度',
                'longitude'      => '经度',
                'name'           => '名称',
                'postcode'       => '邮政编码',
                'priority'       => '优先级',
                'save-btn'       => '保存库存来源',
                'select-country' => '选择国家',
                'select-state'   => '选择州/省',
                'settings'       => '设置',
                'state'          => '州/省',
                'status'         => '状态',
                'street'         => '街道',
                'title'          => '库存来源',
            ],

            'edit' => [
                'back-btn'       => '返回',
                'city'           => '城市',
                'code'           => '代码',
                'contact-email'  => '电子邮件',
                'contact-fax'    => '传真',
                'contact-info'   => '联系信息',
                'contact-name'   => '名称',
                'contact-number' => '联系电话',
                'country'        => '国家',
                'description'    => '描述',
                'general'        => '常规',
                'latitude'       => '纬度',
                'longitude'      => '经度',
                'name'           => '名称',
                'postcode'       => '邮政编码',
                'priority'       => '优先级',
                'save-btn'       => '保存库存来源',
                'select-country' => '选择国家',
                'select-state'   => '选择州/省',
                'settings'       => '设置',
                'source-address' => '来源地址',
                'state'          => '州/省',
                'status'         => '状态',
                'street'         => '街道',
                'title'          => '编辑库存来源',
            ],

            'create-success'    => '库存来源创建成功',
            'delete-failed'     => '库存来源删除失败',
            'delete-success'    => '库存来源删除成功',
            'last-delete-error' => '至少需要一个库存来源',
            'update-success'    => '库存来源更新成功',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => '您确定要删除吗？',
                    'tax-category'   => '税收分类',
                    'title'          => '税收分类',

                    'datagrid' => [
                        'actions' => '操作',
                        'code'    => '代码',
                        'delete'  => '删除',
                        'edit'    => '编辑',
                        'id'      => 'ID',
                        'name'    => '名称',
                    ],

                    'create' => [
                        'add-tax-rates' => '添加税率',
                        'code'          => '代码',
                        'description'   => '描述',
                        'empty-text'    => '税率不可用，请创建新的税率。',
                        'general'       => '税收分类',
                        'name'          => '名称',
                        'save-btn'      => '保存税收分类',
                        'select'        => '选择',
                        'tax-rates'     => '税率',
                        'title'         => '创建税收分类',
                    ],

                    'edit' => [
                        'title'   => '编辑税收分类',
                    ],

                    'create-success' => '新税收分类已创建',
                    'delete-failed'  => '税收分类删除失败',
                    'delete-success' => '税收分类已成功删除',
                    'update-success' => '税收分类成功更新',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => '创建税率',
                    'tax-rate'     => '税率',
                    'title'        => '税率',

                    'datagrid' => [
                        'country'    => '国家',
                        'delete'     => '删除',
                        'edit'       => '编辑',
                        'id'         => 'ID',
                        'identifier' => '标识符',
                        'state'      => '州',
                        'tax-rate'   => '税率',
                        'zip-code'   => '邮政编码',
                        'zip-from'   => '从',
                        'zip-to'     => '至',
                    ],
                ],

                'create' => [
                    'back-btn'       => '返回',
                    'country'        => '国家',
                    'general'        => '常规',
                    'identifier'     => '标识符',
                    'is-zip'         => '启用邮政编码范围',
                    'save-btn'       => '保存税率',
                    'select-country' => '选择国家',
                    'select-state'   => '选择州',
                    'settings'       => '设置',
                    'state'          => '州',
                    'tax-rate'       => '税率',
                    'title'          => '创建税率',
                    'zip-code'       => '邮政编码',
                    'zip-from'       => '从',
                    'zip-to'         => '至',
                ],

                'edit' => [
                    'back-btn'       => '返回',
                    'country'        => '国家',
                    'identifier'     => '标识符',
                    'save-btn'       => '保存税率',
                    'select-country' => '选择国家',
                    'select-state'   => '选择州',
                    'settings'       => '设置',
                    'state'          => '州',
                    'tax-rate'       => '税率',
                    'title'          => '编辑税率',
                    'zip-code'       => '邮政编码',
                    'zip-from'       => '从',
                    'zip-to'         => '至',
                ],

                'create-success' => '税率创建成功。',
                'delete-failed'  => '税率删除失败',
                'delete-success' => '税率删除成功',
                'update-success' => '税率更新成功',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => '创建渠道',
                'delete-failed'     => '频道 删除失败',
                'delete-success'    => '渠道删除成功。',
                'last-delete-error' => '最后一个渠道删除失败。',
                'title'             => '渠道',

                'datagrid' => [
                    'code'      => '代码',
                    'delete'    => '删除',
                    'edit'      => '编辑',
                    'host-name' => '主机名',
                    'id'        => 'ID',
                    'name'      => '名称',
                ],
            ],

            'create' => [
                'allowed-ips'             => '允许的IP',
                'cancel'                  => '返回',
                'code'                    => '代码',
                'create-success'          => '渠道创建成功。',
                'currencies'              => '货币',
                'currencies-and-locales'  => '货币和区域设置',
                'default-currency'        => '默认货币',
                'default-locale'          => '默认区域设置',
                'description'             => '描述',
                'design'                  => '设计',
                'favicon'                 => '网站图标',
                'favicon-size'            => '图像分辨率应为16px x 16px',
                'general'                 => '通用',
                'hostname'                => '主机名',
                'hostname-placeholder'    => 'https://www.example.com（不要在结尾添加斜杠。）',
                'inventory-sources'       => '库存来源',
                'last-delete-error'       => '至少需要一个渠道。',
                'locales'                 => '区域设置',
                'logo'                    => '标志',
                'logo-size'               => '图像分辨率应为192px x 50px',
                'maintenance-mode-text'   => '消息',
                'name'                    => '名称',
                'root-category'           => '根分类',
                'save-btn'                => '保存渠道',
                'select-default-currency' => '选择默认货币',
                'select-default-locale'   => '选择默认区域设置',
                'select-root-category'    => '选择根类别',
                'select-theme'            => '选择主题',
                'seo'                     => '主页SEO',
                'seo-description'         => '元描述',
                'seo-keywords'            => '元关键字',
                'seo-title'               => '元标题',
                'settings'                => '设置',
                'status'                  => '状态',
                'theme'                   => '主题',
                'title'                   => '创建渠道',
            ],

            'edit' => [
                'allowed-ips'            => '允许的IP',
                'back-btn'               => '返回',
                'code'                   => '代码',
                'currencies'             => '货币',
                'currencies-and-locales' => '货币和区域设置',
                'default-currency'       => '默认货币',
                'default-locale'         => '默认区域设置',
                'description'            => '描述',
                'design'                 => '设计',
                'favicon'                => '网站图标',
                'favicon-size'           => '图像分辨率应为16px x 16px',
                'general'                => '通用',
                'hostname'               => '主机名',
                'hostname-placeholder'   => 'https://www.example.com（不要在结尾添加斜杠。）',
                'inventory-sources'      => '库存来源',
                'last-delete-error'      => '至少需要一个渠道。',
                'locales'                => '区域设置',
                'logo'                   => '标志',
                'logo-size'              => '图像分辨率应为192px x 50px',
                'maintenance-mode'       => '维护模式',
                'maintenance-mode-text'  => '消息',
                'name'                   => '名称',
                'root-category'          => '根分类',
                'save-btn'               => '保存渠道',
                'seo'                    => '主页SEO',
                'seo-description'        => '元描述',
                'seo-keywords'           => '元关键字',
                'seo-title'              => '元标题',
                'status'                 => '状态',
                'theme'                  => '主题',
                'title'                  => '编辑渠道',
                'update-success'         => '渠道更新成功',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => '管理员',
                'title' => '用户',
                'user'  => '用户',

                'create' => [
                    'confirm-password'  => '确认密码',
                    'email'             => '电子邮件',
                    'name'              => '姓名',
                    'password'          => '密码',
                    'role'              => '角色',
                    'save-btn'          => '保存用户',
                    'status'            => '状态',
                    'title'             => '创建用户',
                    'upload-image-info' => '上传头像图片（110px x 110px），支持PNG或JPG格式',
                ],

                'datagrid' => [
                    'actions'  => '操作',
                    'active'   => '活跃',
                    'delete'   => '删除',
                    'edit'     => '编辑',
                    'email'    => '电子邮件',
                    'id'       => 'ID',
                    'inactive' => '不活跃',
                    'name'     => '姓名',
                    'role'     => '角色',
                    'status'   => '状态',
                ],

                'edit' => [
                    'title' => '编辑用户',
                ],
            ],

            'edit' => [
                'back-btn'         => '返回',
                'confirm-password' => '确认密码',
                'email'            => '电子邮件',
                'general'          => '通用',
                'name'             => '姓名',
                'password'         => '密码',
                'role'             => '角色',
                'save-btn'         => '保存用户',
                'status'           => '状态',
                'title'            => '编辑用户',
            ],

            'activate-warning'   => '您的帐户尚未激活，请联系管理员。',
            'cannot-change'      => '无法更改用户。',
            'create-success'     => '用户成功创建。',
            'delete-failed'      => '删除用户失败。',
            'delete-success'     => '用户成功删除。',
            'delete-warning'     => '您确定要执行此操作吗？',
            'incorrect-password' => '密码错误',
            'last-delete-error'  => '删除最后一个用户失败。',
            'login-error'        => '请检查您的凭据并重试。',
            'update-success'     => '用户成功更新。',
        ],

        'roles' => [
            'index' => [
                'create-btn' => '创建角色',
                'title'      => '角色',

                'datagrid' => [
                    'custom'          => '自定义',
                    'all'             => '全部',
                    'permission-type' => '权限类型',
                    'name'            => '名称',
                    'id'              => 'ID',
                    'edit'            => '编辑',
                    'delete'          => '删除',
                ],
            ],

            'create' => [
                'access-control' => '访问控制',
                'all'            => '全部',
                'back-btn'       => '返回',
                'custom'         => '自定义',
                'description'    => '描述',
                'general'        => '通用',
                'name'           => '名称',
                'permissions'    => '权限',
                'save-btn'       => '保存角色',
                'title'          => '创建角色',
            ],

            'edit' => [
                'access-control' => '访问控制',
                'all'            => '全部',
                'back-btn'       => '返回',
                'custom'         => '自定义',
                'description'    => '描述',
                'general'        => '通用',
                'name'           => '名称',
                'permissions'    => '权限',
                'save-btn'       => '保存角色',
                'title'          => '编辑角色',
            ],

            'being-used'        => '角色已在管理员用户中使用',
            'create-success'    => '角色创建成功',
            'delete-failed'     => '角色删除失败',
            'delete-success'    => '角色已成功删除',
            'last-delete-error' => '最后一个角色无法删除',
            'update-success'    => '角色已成功更新',
        ],

        'themes' => [
            'index' => [
                'create-btn' => '创建主题',
                'title'      => '主题',

                'datagrid' => [
                    'active'       => '活动',
                    'channel_name' => '频道名称',
                    'delete'       => '删除',
                    'id'           => 'ID',
                    'inactive'     => '非活动',
                    'name'         => '名称',
                    'sort-order'   => '排序顺序',
                    'status'       => '状态',
                    'theme'        => '主题',
                    'type'         => '类型',
                    'view'         => '查看',
                ],
            ],

            'create' => [
                'name'       => '名称',
                'save-btn'   => '保存主题',
                'sort-order' => '排序顺序',
                'themes'     => '主题',
                'title'      => '创建主题',

                'type' => [
                    'category-carousel' => '类别轮播',
                    'footer-links'      => '页脚链接',
                    'image-carousel'    => '图像轮播',
                    'product-carousel'  => '产品轮播',
                    'services-content'  => '服务内容',
                    'static-content'    => '静态内容',
                    'title'             => '类型',
                ],
            ],

            'edit' => [
                'active'                        => '活动',
                'add-filter-btn'                => '添加过滤器',
                'add-footer-link-btn'           => '添加页脚链接',
                'add-image-btn'                 => '添加图片',
                'add-link'                      => '添加链接',
                'asc'                           => '升序',
                'back'                          => '返回',
                'category-carousel'             => '类别轮播',
                'category-carousel-description' => '使用响应式类别轮播以引人注目的方式展示动态类别。',
                'channels'                      => '频道',
                'column'                        => '列',
                'create-filter'                 => '创建过滤器',
                'css'                           => 'CSS',
                'delete'                        => '删除',
                'desc'                          => '降序',
                'edit'                          => '编辑',
                'featured'                      => '精选',
                'filter-title'                  => '标题',
                'filters'                       => '过滤器',
                'footer-link'                   => '页脚链接',
                'footer-link-description'       => '通过页脚链接无缝浏览网站和获取信息。',
                'footer-link-form-title'        => '页脚链接',
                'footer-title'                  => '标题',
                'general'                       => '通用',
                'inactive'                      => '非活动',
                'html'                          => 'HTML',
                'image'                         => '图片',
                'image-size'                    => '图片分辨率应为（1920px x 700px）',
                'image-title'                   => '图片标题',
                'image-upload-message'          => '仅允许图片（.jpeg、.jpg、.png、.webp 等）。',
                'key'                           => '键：:key',
                'key-input'                     => '键',
                'limit'                         => '限制',
                'link'                          => '链接',
                'name'                          => '名称',
                'no'                            => '不',
                'new'                           => '新',
                'parent-id'                     => '父ID',
                'category-id'                   => '类别ID',
                'preview'                       => '预览',
                'product-carousel'              => '产品轮播',
                'product-carousel-description'  => '使用动态和响应式产品轮播优雅地展示产品。',
                'save-btn'                      => '保存',
                'select'                        => '选择',
                'slider'                        => '滑块',
                'slider-add-btn'                => '添加滑块',
                'slider-description'            => '与滑块相关的主题自定义。',
                'slider-image'                  => '滑块图片',
                'slider-required'               => '滑块字段为必填项。',
                'sort'                          => '排序',
                'sort-order'                    => '排序顺序',
                'static-content'                => '静态内容',
                'static-content-description'    => '为您的受众提供简洁、信息丰富的静态内容，提高参与度。',
                'status'                        => '状态',
                'title'                         => '编辑主题',
                'update-slider'                 => '更新滑块',
                'url'                           => '网址',
                'value'                         => '值：:value',
                'value-input'                   => '值',
                'themes'                        => '主题',

                'services-content' => [
                    'add-btn'            => '添加服务',
                    'channels'           => '渠道',
                    'delete'             => '删除',
                    'description'        => '描述',
                    'general'            => '通用',
                    'name'               => '名称',
                    'save-btn'           => '保存',
                    'service-icon'       => '服务图标',
                    'service-icon-class' => '服务图标类',
                    'service-info'       => '与服务相关的主题定制。',
                    'services'           => '服务',
                    'sort-order'         => '排序顺序',
                    'status'             => '状态',
                    'title'              => '标题',
                    'update-service'     => '更新服务',
                ],
                'yes'                           => '是',
            ],

            'create-success' => '成功创建主题',
            'delete-success' => '成功删除主题',
            'update-success' => '成功更新主题',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => '被遗弃的购物车',
                'abandoned-products'            => '被遗弃的商品',
                'abandoned-rate'                => '被遗弃率',
                'abandoned-revenue'             => '被遗弃的收入',
                'added-to-cart'                 => '已添加到购物车',
                'added-to-cart-info'            => '仅 :progress 位访客将产品添加到购物车',
                'all-channels'                  => '所有渠道',
                'average-order-value-over-time' => '随时间的平均订单价值',
                'average-sales'                 => '平均订单价值',
                'count'                         => '数量',
                'end-date'                      => '结束日期',
                'id'                            => 'ID',
                'interval'                      => '间隔',
                'name'                          => '名称',
                'orders'                        => '订单',
                'orders-over-time'              => '随时间的订单数',
                'payment-method'                => '付款方式',
                'product-views'                 => '商品浏览次数',
                'product-views-info'            => '仅 :progress 位访客查看商品',
                'purchase-funnel'               => '购买漏斗',
                'purchased'                     => '已购买',
                'purchased-info'                => '仅 :progress 位访客进行购买',
                'refunds'                       => '退款',
                'refunds-over-time'             => '随时间的退款',
                'sales-over-time'               => '随时间的销售',
                'shipping-collected'            => '运费收入',
                'shipping-collected-over-time'  => '随时间的运费收入',
                'start-date'                    => '开始日期',
                'tax-collected'                 => '税金收入',
                'tax-collected-over-time'       => '随时间的税金收入',
                'title'                         => '销售',
                'top-payment-methods'           => '热门付款方式',
                'top-shipping-methods'          => '热门配送方式',
                'top-tax-categories'            => '热门税收类别',
                'total'                         => '总计',
                'total-orders'                  => '总订单数',
                'total-sales'                   => '总销售额',
                'total-visits'                  => '总访问量',
                'total-visits-info'             => '商店的总访客数',
                'view-details'                  => '查看详情',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => '所有渠道',
                'count'                       => '数量',
                'customers'                   => '客户',
                'customers-over-time'         => '随时间的客户数',
                'customers-traffic'           => '客户流量',
                'customers-with-most-orders'  => '最多订单的客户',
                'customers-with-most-reviews' => '最多评价的客户',
                'customers-with-most-sales'   => '最多销售的客户',
                'email'                       => '电子邮件',
                'end-date'                    => '结束日期',
                'id'                          => 'ID',
                'interval'                    => '间隔',
                'name'                        => '名称',
                'orders'                      => '订单',
                'reviews'                     => '评价',
                'start-date'                  => '开始日期',
                'title'                       => '客户',
                'top-customer-groups'         => '热门客户群',
                'total'                       => '总计',
                'total-customers'             => '总客户数',
                'total-visitors'              => '总访客数',
                'traffic-over-week'           => '一周内的流量',
                'unique-visitors'             => '独立访客',
                'view-details'                => '查看详情',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => '所有渠道',
                'channel'                          => '频道',
                'end-date'                         => '结束日期',
                'id'                               => 'ID',
                'interval'                         => '间隔',
                'last-search-terms'                => '最近的搜索词',
                'locale'                           => '区域',
                'name'                             => '名称',
                'orders'                           => '订单',
                'price'                            => '价格',
                'products-added-over-time'         => '随时间的新增商品',
                'products-with-most-reviews'       => '最多评价的商品',
                'products-with-most-visits'        => '最多访问的商品',
                'quantities'                       => '数量',
                'quantities-sold-over-time'        => '随时间的销售数量',
                'results'                          => '结果',
                'revenue'                          => '收入',
                'reviews'                          => '评价',
                'search-term'                      => '搜索词',
                'start-date'                       => '开始日期',
                'title'                            => '商品',
                'top-search-terms'                 => '最受欢迎的搜索词',
                'top-selling-products-by-quantity' => '按数量销售最多的商品',
                'top-selling-products-by-revenue'  => '按收入销售最多的商品',
                'total'                            => '总计',
                'total-products-added-to-wishlist' => '已添加到愿望清单的商品',
                'total-sold-quantities'            => '已售商品数量',
                'uses'                             => '用途',
                'view-details'                     => '查看详情',
                'visits'                           => '访问次数',
            ],
        ],

        'view' => [
            'all-channels'  => '所有渠道',
            'day'           => '日',
            'end-date'      => '结束日期',
            'export-csv'    => '导出CSV',
            'export-xls'    => '导出XLS',
            'month'         => '月',
            'not-available' => '没有可用的记录。',
            'start-date'    => '开始日期',
            'year'          => '年',
        ],

        'empty' => [
            'info'  => '所选时间段内暂无数据',
            'title' => '暂无数据',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => '返回',
            'delete'                       => '删除',
            'enable-at-least-one-payment'  => '至少启用一种支付方式。',
            'enable-at-least-one-shipping' => '至少启用一种配送方式。',
            'no-result-found'              => '未找到结果',
            'save-btn'                     => '保存配置',
            'save-message'                 => '配置保存成功',
            'search'                       => '搜索',
            'select-country'               => '选择国家',
            'select-state'                 => '选择省份',
            'title'                        => '配置',

            'general' => [
                'info'  => '设置单位选项。',
                'title' => '常规',

                'general' => [
                    'info'  => '设置单位选项。',
                    'title' => '常规',

                    'unit-options' => [
                        'info'        => '设置单位选项。',
                        'title'       => '单位选项',
                        'title-info'  => '配置重量单位为磅（lbs）或千克（kgs）。',
                        'weight-unit' => '重量单位',
                    ],

                    'breadcrumbs' => [
                        'shop'       => '商店面包屑',
                        'title'      => '面包屑',
                        'title-info' => '在商店中启用或禁用面包屑导航。',
                    ],
                ],

                'content' => [
                    'info'  => '设置比较选项、心愿单选项、图像搜索选项、页脚、切换页脚和自定义脚本。',
                    'title' => '内容',

                    'header-offer' => [
                        'title'             => '页眉优惠标题',
                        'title-info'        => '配置页眉优惠标题，包括优惠标题、重定向标题和重定向链接。',
                        'offer-title'       => '优惠标题',
                        'redirection-title' => '重定向标题',
                        'redirection-link'  => '重定向链接',
                    ],

                    'custom-scripts' => [
                        'custom-css'        => '自定义CSS',
                        'custom-javascript' => '自定义Javascript',
                        'title'             => '自定义脚本',
                        'title-info'        => '自定义脚本是为软件添加特定功能或特性的个性化代码片段，独特地增强其功能。',
                    ],
                ],

                'design' => [
                    'info'  => '设置标志和网站图标。',
                    'title' => '设计',

                    'admin-logo' => [
                        'favicon'    => '网站图标',
                        'logo-image' => '标志图像',
                        'title'      => '管理标志',
                        'title-info' => '为您的网站前端配置标志和网站图标图像，以提升品牌形象和识别度。',
                    ],
                ],

                'magic-ai' => [
                    'info'  => '设置魔法AI选项。',
                    'title' => '魔法AI',

                    'settings' => [
                        'api-key'        => 'API密钥',
                        'enabled'        => '已启用',
                        'llm-api-domain' => 'LLM API域',
                        'organization'   => '组织',
                        'title'          => '常规设置',
                        'title-info'     => '通过输入您的独家API密钥和指示相关组织来增强您使用魔法AI功能的体验。掌握OpenAI凭据并根据您的特定需求自定义设置。',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => '类别描述提示',
                        'cms-page-content-prompt'          => 'CMS页面内容提示',
                        'enabled'                          => '已启用',
                        'product-description-prompt'       => '产品描述提示',
                        'product-short-description-prompt' => '产品简短描述提示',
                        'title'                            => '内容生成',
                        'title-info'                       => '此功能将为每个所见即所得编辑器启用魔法AI，您可以使用AI管理内容。<br/><br/>启用后，转到任何编辑器生成内容。',
                    ],

                    'image-generation' => [
                        'enabled'    => '已启用',
                        'title'      => '图像生成',
                        'title-info' => '此功能将为每个图像上传启用魔法AI，您可以使用DALL-E生成图像。<br/><br/>启用后，转到任何图像上传生成图像。',
                    ],

                    'review-translation' => [
                        'dolphin-phi'       => '海豚Phi',
                        'enabled'           => '已启用',
                        'gpt-3-5-turbo'     => 'OpenAI gpt-3.5-turbo',
                        'llama2'            => 'Llama 2',
                        'llama2-uncensored' => 'Llama 2未经审查',
                        'llama2:13b'        => 'Llama 2 13B',
                        'llama2:70b'        => 'Llama 2 70B',
                        'llava'             => 'LLaVA',
                        'mistral'           => 'Mistral',
                        'model'             => '模型',
                        'orca-mini'         => 'Orca Mini',
                        'phi'               => 'Phi-2',
                        'starling-lm'       => 'Starling',
                        'title'             => '评论翻译',
                        'title-info'        => '为顾客或访客提供将顾客评论翻译成英文的选项。<br/><br/>启用后，转到评论页面，如果您的评论不是英文，您将找到“翻译为英文”的按钮。',
                        'vicuna'            => 'Vicuna',
                    ],

                    'checkout-message' => [
                        'dolphin-phi'       => '海豚Phi',
                        'enabled'           => '已启用',
                        'gpt-3-5-turbo'     => 'OpenAI gpt-3.5-turbo',
                        'llama2'            => 'Llama 2',
                        'llama2-uncensored' => 'Llama 2未经审查',
                        'llama2:13b'        => 'Llama 2 13B',
                        'llama2:70b'        => 'Llama 2 70B',
                        'llava'             => 'LLaVA',
                        'mistral'           => 'Mistral',
                        'model'             => '模型',
                        'orca-mini'         => 'Orca Mini',
                        'phi'               => 'Phi-2',
                        'prompt'            => '提示',
                        'starling-lm'       => 'Starling',
                        'title'             => '个性化结账信息',
                        'title-info'        => '为感谢页面上的顾客定制结账信息，以使内容与个人偏好产生共鸣，增强整体购买后体验。',
                        'vicuna'            => 'Vicuna',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => '目录',
                'title' => '目录',

                'products' => [
                    'info'  => '产品查看页面，购物车查看页面，店面，评论和属性社交分享。',
                    'title' => '产品',

                    'settings' => [
                        'compare-options'     => '比较选项',
                        'image-search-option' => '图片搜索选项',
                        'title'               => '设置',
                        'title-info'          => '设置是指根据用户的偏好和要求，对系统、应用程序或设备的行为进行可配置的选择。',
                        'wishlist-options'    => '心愿单选项',
                    ],

                    'search' => [
                        'admin-mode'            => '管理员搜索模式',
                        'admin-mode-info'       => '管理员面板中的超级搜索、数据网格和其他搜索功能将基于所选的搜索引擎。',
                        'database'              => '数据库',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => '最大查询长度',
                        'max-query-length-info' => '设置搜索查询的最大查询长度。',
                        'min-query-length'      => '最小查询长度',
                        'min-query-length-info' => '设置搜索查询的最小查询长度。',
                        'search-engine'         => '搜索引擎',
                        'storefront-mode'       => '商店前端搜索模式',
                        'storefront-mode-info'  => '商店前端的搜索功能将基于所选的搜索引擎，包括分类页面、搜索页面和其他搜索功能。',
                        'title'                 => '搜索',
                        'title-info'            => '要设置产品搜索的搜索引擎，您可以根据需求选择数据库和Elasticsearch之间的选择。如果您有大量的产品，建议使用Elasticsearch。',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => '允许访客结账',
                        'allow-guest-checkout-hint' => '提示：如果打开此选项，可以针对每个产品进行配置。',
                        'title'                     => '访客结账',
                        'title-info'                => '访客结账允许客户在不创建帐户的情况下购买产品，简化购买流程，提供更便捷和快速的交易。',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => '允许相关产品的数量',
                        'allow-no-of-up-sells-products' => '允许上销售产品的数量',
                        'title'                         => '产品查看页面配置',
                        'title-info'                    => '产品查看页面配置涉及调整产品显示页面上的布局和元素，提升用户体验和信息呈现。',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => '允许交叉销售产品的数量',
                        'title'                            => '购物车查看页面配置',
                        'title-info'                       => '购物车查看页面配置涉及在购物车页面上排列商品、详细信息和选项，提高用户交互和购买流程。',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => '允许客户直接购买产品',
                        'cheapest-first'         => '最便宜的优先',
                        'comma-separated'        => '逗号分隔',
                        'default-list-mode'      => '默认列表模式',
                        'expensive-first'        => '最贵的优先',
                        'from-a-z'               => '从A到Z',
                        'from-z-a'               => '从Z到A',
                        'grid'                   => '网格',
                        'latest-first'           => '最新的优先',
                        'list'                   => '列表',
                        'oldest-first'           => '最旧的优先',
                        'products-per-page'      => '每页产品数量',
                        'sort-by'                => '排序方式',
                        'title'                  => '商店前端',
                        'title-info'             => '商店前端是在线商店的面向客户的界面，展示产品、分类和导航，提供无缝的购物体验。',
                    ],

                    'small-image' => [
                        'height'      => '高度',
                        'placeholder' => '小图占位符',
                        'title'       => '小图',
                        'title-info'  => '商店前端是在线商店的面向客户的界面，展示产品、分类和导航，提供无缝的购物体验。',
                        'width'       => '宽度',
                    ],

                    'medium-image' => [
                        'height'      => '高度',
                        'placeholder' => '中图占位符',
                        'title'       => '中图',
                        'title-info'  => '中图是指中等大小的图片，提供了详细信息和屏幕空间之间的平衡，通常用于视觉效果。',
                        'width'       => '宽度',
                    ],

                    'large-image' => [
                        'height'      => '高度',
                        'placeholder' => '大图占位符',
                        'title'       => '大图',
                        'title-info'  => '大图代表提供增强细节和视觉冲击力的高分辨率图片，通常用于展示产品或图形。',
                        'width'       => '宽度',
                    ],

                    'review' => [
                        'allow-customer-review' => '允许客户评价',
                        'allow-guest-review'    => '允许访客评价',
                        'display-review-count'  => '显示评级的评论计数。',
                        'display-star-count'    => '显示评分中的星级数。',
                        'summary'               => '概括',
                        'title'                 => '评价',
                        'title-info'            => '对某物进行评估或评价，通常涉及意见和反馈。',
                    ],

                    'attribute' => [
                        'file-upload-size'  => '允许文件上传大小（以KB为单位）',
                        'image-upload-size' => '允许图片上传大小（以KB为单位）',
                        'title'             => '属性',
                        'title-info'        => '定义对象的特性或属性，影响其行为、外观或功能。',
                    ],

                    'social-share' => [
                        'title-info'                  => '配置社交分享设置，以在Instagram、Twitter、WhatsApp、Facebook、Pinterest、LinkedIn和电子邮件中启用产品分享。',
                        'title'                       => '社交分享',
                        'share-message'               => '分享消息',
                        'share'                       => '分享',
                        'enable-social-share'         => '启用社交分享？',
                        'enable-share-whatsapp-info'  => '仅在移动设备上显示WhatsApp分享链接。',
                        'enable-share-whatsapp'       => '在WhatsApp中启用分享？',
                        'enable-share-twitter'        => '在Twitter中启用分享？',
                        'enable-share-pinterest'      => '在Pinterest中启用分享？',
                        'enable-share-linkedin'       => '在Linkedin中启用分享？',
                        'enable-share-facebook'       => '在Facebook中启用分享？',
                        'enable-share-email'          => '在电子邮件中启用分享？',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => '设置产品和分类。',
                    'title' => '富媒体片段',

                    'products' => [
                        'enable'          => '启用',
                        'show-categories' => '显示分类',
                        'show-images'     => '显示图片',
                        'show-offers'     => '显示优惠',
                        'show-ratings'    => '显示评级',
                        'show-reviews'    => '显示评价',
                        'show-sku'        => '显示SKU',
                        'show-weight'     => '显示重量',
                        'title'           => '产品',
                        'title-info'      => '配置产品设置，包括SKU、重量、类别、图像、评论、评分、优惠等。',
                    ],

                    'categories' => [
                        'enable'                  => '启用',
                        'show-search-input-field' => '显示搜索输入框',
                        'title'                   => '分类',
                        'title-info'              => '“分类”是指帮助组织和分组类似产品或物品以便更轻松地浏览和导航的组或分类。',
                    ],
                ],

                'inventory' => [
                    'title'      => '库存',
                    'title-info' => '配置库存设置以允许缺货、设置购物车的最小和最大数量，并定义缺货阈值。',

                    'product-stock-options' => [
                        'allow-back-orders'       => '允许缺货订单',
                        'max-qty-allowed-in-cart' => '购物车中允许的最大数量',
                        'min-qty-allowed-in-cart' => '购物车中允许的最小数量',
                        'out-of-stock-threshold'  => '缺货阈值',
                        'title'                   => '产品库存选项',
                        'info'                    => '配置产品库存选项，允许后订单，设置购物车的最小和最大数量，并定义缺货门槛。',
                    ],
                ],
            ],

            'customer' => [
                'info'  => '顧客',
                'title' => '顧客',

                'address' => [
                    'info'  => '国、都道府県、郵便番号、住所の行を設定します。',
                    'title' => '住所',

                    'requirements' => [
                        'city'       => '市区町村',
                        'country'    => '国',
                        'state'      => '都道府県',
                        'title'      => '要件',
                        'title-info' => '要件は、何かを達成するために必要な条件、機能、または仕様です。',
                        'zip'        => '郵便番号',
                    ],

                    'information' => [
                        'street-lines' => '住所の行',
                        'title'        => '情報',
                        'title-info'   => '「住所の行」は、住所の個々のセグメントを指し、通常はコンマで区切られており、家番号、通り名、市区町村などの位置情報を提供します。',
                    ],
                ],

                'captcha' => [
                    'info'  => 'サイトキー、シークレットキー、ステータスを設定します。',
                    'title' => 'キャプチャ',

                    'credentials' => [
                        'secret-key' => 'シークレットキー',
                        'site-key'   => 'サイトキー',
                        'status'     => 'ステータス',
                        'title'      => '資格情報',
                        'title-info' => '「サイトマップ：検索エンジン用のウェブサイトのレイアウトマップ。シークレットキー：データの暗号化、認証、またはAPIアクセス保護のためのセキュアコード。」',
                    ],

                    'validations' => [
                        'captcha'  => 'エラーが発生しました。もう一度お試しください。',
                        'required' => 'CAPTCHAを選択してください。',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'ニュースレターの購読、メールの確認、ソーシャルログインを設定します。',
                    'title'         => '設定',

                    'login-as-customer' => [
                        'allow-option' => '顧客としてログインを許可する',
                        'title'        => '顧客としてログイン',
                        'title-info'   => '「顧客としてログイン」機能を有効にします。',
                    ],

                    'wishlist' => [
                        'allow-option' => 'ウィッシュリストオプションを許可する',
                        'title'        => 'ウィッシュリスト',
                        'title-info'   => 'ウィッシュリストオプションを有効または無効にします。',
                    ],

                    'login-options' => [
                        'account'          => 'アカウント',
                        'home'             => 'ホーム',
                        'redirect-to-page' => '顧客を選択したページにリダイレクトする',
                        'title'            => 'ログインオプション',
                        'title-info'       => 'ログインオプションを設定して、ログイン後の顧客のリダイレクトページを決定します。',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'ニュースレターを許可する',
                        'news-letter-info' => 'サインアップページでニュースレターの購読オプションを有効にします。',
                        'title'            => '新規アカウントオプション',
                        'title-info'       => '新規アカウントのオプションを設定します。デフォルトの顧客グループの割り当てや、サインアップ時のニュースレターの購読オプションを有効にするなどが含まれます。',

                        'default-group' => [
                            'general'    => '一般',
                            'guest'      => 'ゲスト',
                            'title'      => 'デフォルトグループ',
                            'title-info' => '新規顧客のデフォルトとして特定の顧客グループを割り当てます。',
                            'wholesale'  => '卸売',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => '允许订阅通讯信息',
                        'title'        => '通讯信息',
                        'title-info'   => '“通讯信息”包含通过电子邮件定期发送给订阅者的更新、优惠或内容，使他们保持了解和参与。',
                    ],

                    'email' => [
                        'email-verification' => '允许电子邮件验证',
                        'title'              => '电子邮件验证',
                        'title-info'         => '“电子邮件验证”通过发送确认链接来确认电子邮件地址的真实性，增强帐户安全性和通信可靠性。',
                    ],

                    'social-login' => [
                        'enable-facebook'   => 'Enable Facebook',
                        'enable-github'     => 'Enable Github',
                        'enable-google'     => 'Enable Google',
                        'enable-linkedin'   => 'Enable LinkedIn',
                        'enable-twitter'    => 'Enable Twitter',
                        'social-login'      => 'Social Login',
                        'social-login-info' => '「ソーシャルログイン」は、ユーザーがソーシャルメディアアカウントを使用してウェブサイトにアクセスできるようにすることで、登録とログインのプロセスを簡素化します。',
                    ],
                ],
            ],

            'email' => [
                'info'  => 'メール',
                'title' => 'メール',

                'email-settings' => [
                    'admin-email'           => '管理者メール',
                    'admin-email-tip'       => 'このチャネルの管理者のメールアドレス、メールを受け取るため',
                    'admin-name'            => '管理者名',
                    'admin-name-tip'        => 'この名前はすべての管理者メールに表示されます',
                    'admin-page-limit'      => 'デフォルトのページごとのアイテム数（管理者）',
                    'contact-email'         => '連絡先メール',
                    'contact-email-tip'     => 'メールの下部に表示されるメールアドレス',
                    'contact-name'          => '連絡先名',
                    'contact-name-tip'      => 'メールの下部に表示される名前',
                    'email-sender-name'     => 'メール送信者名',
                    'email-sender-name-tip' => 'この名前は顧客の受信トレイに表示されます',
                    'info'                  => 'メール送信者名、ショップのメールアドレス、管理者名、管理者のメールアドレスを設定します。',
                    'shop-email-from'       => 'ショップのメールアドレス',
                    'shop-email-from-tip'   => '顧客にメールを送信するためのこのチャネルのメールアドレス',
                    'title'                 => 'メール設定',
                ],

                'notifications' => [
                    'cancel-order'                                     => '注文をキャンセルした後に通知を送信する',
                    'customer'                                         => '登録後に顧客アカウントの資格情報を送信する',
                    'customer-registration-confirmation-mail-to-admin' => '顧客登録後に管理者に確認メールを送信する',
                    'info'                                             => '配置产品库存选项，允许后订单，设置购物车的最小和最大数量，并定义缺货门槛。',
                    'new-admin'                                        => '新しい注文を配置した後に管理者に確認メールを送信する',
                    'new-inventory-source'                             => '出荷を作成した後に在庫ソースに通知メールを送信する',
                    'new-invoice'                                      => '新しい請求書を作成した後に顧客に通知メールを送信する',
                    'new-order'                                        => '新しい注文を配置した後に顧客に確認メールを送信する',
                    'new-refund'                                       => '返金を作成した後に顧客に通知メールを送信する',
                    'new-shipment'                                     => '出荷を作成した後に顧客に通知メールを送信する',
                    'registration'                                     => '顧客登録後に確認メールを送信する',
                    'title'                                            => '通知',
                    'verification'                                     => '顧客登録後に確認メールを送信する',
                ],
            ],

            'sales' => [
                'info'  => '販売',
                'title' => '販売',

                'shipping-setting' => [
                    'info'  => '国、州、市、住所、郵便番号、店舗名、VAT番号、連絡先番号、および銀行の詳細など、配送設定を構成します。',
                    'title' => '配送設定',

                    'origin' => [
                        'bank-details'   => '銀行の詳細',
                        'city'           => '市',
                        'contact-number' => '連絡先番号',
                        'country'        => '国',
                        'state'          => '州',
                        'store-name'     => '店舗名',
                        'street-address' => '住所',
                        'title'          => '出荷元',
                        'title-info'     => '出荷元は、商品や製品が目的地に輸送される前に起源となる場所を指します。',
                        'vat-number'     => 'VAT番号',
                        'zip'            => '郵便番号',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => '必要に応じて、無料配送、定額配送料などを含む配送方法を設定します。',
                    'title' => '配送方法',

                    'free-shipping' => [
                        'description' => '説明',
                        'page-title'  => '無料配送',
                        'status'      => 'ステータス',
                        'title'       => 'タイトル',
                        'title-info'  => '「無料配送」とは、配送料が免除され、販売者が買い手に商品を配送するための配送料を負担する配送方法を指します。',
                    ],

                    'flat-rate-shipping' => [
                        'description' => '説明',
                        'page-title'  => '定額配送料',
                        'rate'        => '料金',
                        'status'      => 'ステータス',
                        'title'       => 'タイトル',
                        'title-info'  => '定額配送料とは、パッケージの重さ、サイズ、距離に関係なく、一定の料金が配送料として請求される配送方法です。これにより、配送料が簡素化され、買い手と販売者の両方にとって有利になります。',
                        'type'        => [
                            'per-order' => '注文ごと',
                            'per-unit'  => '単位ごと',
                            'title'     => 'タイプ',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => '受け入れられる通貨',
                    'accepted-currencies-info'       => '通貨コードをカンマ区切りで追加してください。例：USD、INR、...',
                    'business-account'               => 'ビジネスアカウント',
                    'cash-on-delivery'               => '代金引換',
                    'cash-on-delivery-info'          => '顧客が商品やサービスを受け取った際に現金で支払う支払い方法です。',
                    'client-id'                      => 'クライアントID',
                    'client-id-info'                 => 'テスト用には「sb」を使用してください。',
                    'client-secret'                  => 'クライアントシークレット',
                    'client-secret-info'             => 'ここに秘密キーを追加してください。',
                    'description'                    => '説明',
                    'generate-invoice'               => '注文後に自動的に請求書を生成する',
                    'generate-invoice-applicable'    => '自動的に請求書を生成する場合に適用されます',
                    'info'                           => '支払い方法の情報を設定します',
                    'instructions'                   => '指示',
                    'logo'                           => 'ロゴ',
                    'logo-information'               => '画像の解像度は55px × 45pxのようにしてください',
                    'mailing-address'                => '送付先',
                    'money-transfer'                 => '送金',
                    'money-transfer-info'            => '資金の移動を指し、しばしば電子的に行われます。取引や送金など、さまざまな目的で使用されます。',
                    'page-title'                     => '支払い方法',
                    'paid'                           => '支払済み',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'PayPalスマートボタン：ウェブサイトやアプリでの安全なマルチメソッドトランザクションのためのカスタマイズ可能なボタンで、オンライン支払いを簡素化します。',
                    'paypal-standard'                => 'PayPalスタンダード',
                    'paypal-standard-info'           => 'PayPalスタンダードは、オンラインビジネス向けの基本的なPayPal支払いオプションで、顧客がPayPalアカウントやクレジット/デビットカードを使用して支払うことができます。',
                    'pending'                        => '保留中',
                    'pending-payment'                => '保留中の支払い',
                    'processing'                     => '処理中',
                    'sandbox'                        => 'サンドボックス',
                    'set-invoice-status'             => '請求書作成後の請求書のステータスを設定する',
                    'set-order-status'               => '請求書作成後の注文のステータスを設定する',
                    'sort-order'                     => '並び順',
                    'status'                         => 'ステータス',
                    'title'                          => 'タイトル',
                ],

                'order-settings' => [
                    'info'               => '注文番号、最小注文数、バックオーダーを設定します。',
                    'title'              => '注文設定',

                    'order-number' => [
                        'generator'   => '注文番号ジェネレーター',
                        'info'        => '特定の顧客注文に割り当てられる一意の識別子で、購入プロセス全体での追跡、コミュニケーション、参照を支援します。',
                        'length'      => '注文番号の長さ',
                        'prefix'      => '注文番号のプレフィックス',
                        'suffix'      => '注文番号のサフィックス',
                        'title'       => '注文番号の設定',
                    ],

                    'minimum-order' => [
                        'description'             => '説明',
                        'enable'                  => '有効にする',
                        'include-discount-amount' => '割引額を含む',
                        'include-tax-amount'      => '税額を含む',
                        'info'                    => '注文が処理されるか、特典の対象となるために必要な最低数量または金額を指定する基準を設定します。',
                        'minimum-order-amount'    => '最低注文金額',
                        'title'                   => '最低注文設定',
                    ],

                    'reorder' => [
                        'admin-reorder'      => '管理者の再注文',
                        'admin-reorder-info' => '管理者ユーザーの再注文機能を有効または無効にします。',
                        'info'               => 'ショップユーザーの再注文機能を有効または無効にします。',
                        'shop-reorder'       => 'ショップの再注文',
                        'shop-reorder-info'  => 'ショップユーザーの再注文機能を有効または無効にします。',
                        'title'              => '再注文を許可する',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'バックオーダーを許可する',
                        'info'              => 'ストックオプションは、特定の価格で会社の株式を購入または売却する権利を付与する投資契約であり、潜在的な利益に影響を与えます。',
                        'title'             => 'ストックオプション',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => '請求書番号、支払条件、請求書のデザイン、請求書リマインダーを設定します。',
                    'title' => '請求書設定',

                    'invoice-number' => [
                        'generator'  => '請求書番号ジェネレーター',
                        'info'       => '組織や追跡のために請求書に一意の識別番号を生成して割り当てるためのルールやパラメータの設定。',
                        'length'     => '請求書番号の長さ',
                        'prefix'     => '請求書番号のプレフィックス',
                        'suffix'     => '請求書番号のサフィックス',
                        'title'      => '請求書番号の設定',
                    ],

                    'payment-terms' => [
                        'due-duration'      => '支払期限',
                        'due-duration-day'  => ':due-duration 日',
                        'due-duration-days' => ':due-duration 日',
                        'info'              => '買い手が売り手に対して商品やサービスの支払いを行うべき時期や方法を定めた合意条件。',
                        'title'             => '支払条件',
                    ],

                    'pdf-print-outs' => [
                        'info'             => 'PDFプリントアウトを設定して、ヘッダーに請求書ID、注文IDを表示し、請求書のロゴを含めます。',
                        'invoice-id-info'  => '請求書ヘッダーに請求書IDを表示するかを設定します。',
                        'invoice-id-title' => 'ヘッダーに請求書IDを表示',
                        'logo'             => 'ロゴ',
                        'logo-info'        => '图像分辨率应为 131px X 30px。',
                        'order-id-info'    => '請求書ヘッダーに注文IDを表示するかを設定します。',
                        'order-id-title'   => 'ヘッダーに注文IDを表示',
                        'title'            => 'PDFプリントアウト',
                    ],

                    'invoice-reminders' => [
                        'info'                       => '請求書の支払いの予定または期限が近づいていること、または延滞していることを顧客に通知するための自動通知やコミュニケーション。',
                        'interval-between-reminders' => 'リマインダー間隔',
                        'maximum-limit-of-reminders' => 'リマインダーの最大数',
                        'title'                      => '請求書リマインダー',
                    ],
                ],

                'taxes' => [
                    'title'      => '税金',
                    'title-info' => '税金とは、政府が商品、サービス、または取引に課す義務的な料金であり、売り手が徴収し当局に納付するものです。',

                    'categories' => [
                        'title'      => '税金カテゴリー',
                        'title-info' => '税金カテゴリーは、販売税、付加価値税、消費税などの異なる種類の税金の分類であり、製品やサービスに税率を分類して適用するために使用されます。',
                        'product'    => '製品のデフォルト税金カテゴリー',
                        'shipping'   => '配送料税金カテゴリー',
                        'none'       => 'なし',
                    ],

                    'calculation' => [
                        'title'            => '計算設定',
                        'title-info'       => '商品やサービスの価格、割引、税金、追加料金などの費用に関する詳細情報。',
                        'based-on'         => '計算基準',
                        'shipping-address' => '配送先住所',
                        'billing-address'  => '請求先住所',
                        'shipping-origin'  => '出荷元',
                        'product-prices'   => '製品価格',
                        'shipping-prices'  => '配送料',
                        'excluding-tax'    => '税抜き',
                        'including-tax'    => '税込み',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'デフォルトの国',
                        'default-post-code' => 'デフォルトの郵便番号',
                        'default-state'     => 'デフォルトの都道府県',
                        'title'             => 'デフォルトの宛先計算',
                        'title-info'        => '事前に定義された要素や設定に基づいて、標準または初期の宛先を自動的に決定します。',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'ショッピングカートの表示設定',
                        'title-info'              => 'ショッピングカートでの税金の表示を設定します。',
                        'display-prices'          => '価格の表示',
                        'display-subtotal'        => '小計の表示',
                        'display-shipping-amount' => '配送料の表示',
                        'excluding-tax'           => '税抜き',
                        'including-tax'           => '税込み',
                        'both'                    => '税抜きと税込みの両方',
                    ],

                    'sales' => [
                        'title'                   => '注文、請求書、返金の表示設定',
                        'title-info'              => '注文、請求書、返金での税金の表示を設定します。',
                        'display-prices'          => '価格の表示',
                        'display-subtotal'        => '小計の表示',
                        'display-shipping-amount' => '配送料の表示',
                        'excluding-tax'           => '税抜き',
                        'including-tax'           => '税込み',
                        'both'                    => '税抜きと税込みの両方',
                    ],
                ],

                'checkout' => [
                    'title' => 'チェックアウト',
                    'info'  => '设置访客结账，启用或禁用迷你购物车，购物车摘要。',

                    'shopping-cart' => [
                        'cart-page'              => 'カートページ',
                        'cart-page-info'         => 'ユーザーのショッピング体験を向上させるために、カートページの表示を制御します。',
                        'cross-sell'             => 'クロスセル商品',
                        'cross-sell-info'        => '追加の販売機会を増やすために、クロスセル商品を有効にします。',
                        'estimate-shipping'      => '配送料の見積もり',
                        'estimate-shipping-info' => '見積もり配送料を有効にして、事前に配送料を提供します。',
                        'guest-checkout'         => 'ゲストチェックアウトを許可する',
                        'guest-checkout-info'    => '迅速で手間のかからない購入プロセスのために、ゲストチェックアウトを有効にします。',
                        'info'                   => 'ゲストチェックアウト、カートページ、クロスセル商品、および見積もり配送料を有効にして、ユーザーの利便性を向上させ、買い物プロセスを効率化して売上を増やします。',
                        'title'                  => 'ショッピングカート',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'アイテムの数量を表示',
                        'display-number-in-cart'  => 'カート内のアイテム数を表示',
                        'info'                    => 'マイカートの設定を有効にして、アイテムの数量の概要を表示し、カート内の総アイテム数を表示して追跡を容易にします。',
                        'summary'                 => '概要',
                        'title'                   => 'マイカート',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'ミニカートの表示',
                        'info'                 => 'ミニカートの設定を有効にして、ミニカートを表示し、ミニカートのオファー情報を表示してカートの詳細とプロモーションに簡単にアクセスできるようにします。',
                        'mini-cart-offer-info' => 'ミニカートのオファー情報',
                        'title'                => 'ミニカート',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => '账户',
                'app-version'   => '版本: :version',
                'logout'        => '退出',
                'my-account'    => '我的账户',
                'notifications' => '通知',
                'visit-shop'    => '访问商店',

                'mega-search' => [
                    'categories'                      => '分类',
                    'customers'                       => '客户',
                    'explore-all-categories'          => '浏览所有分类',
                    'explore-all-customers'           => '浏览所有客户',
                    'explore-all-matching-categories' => '浏览所有与“:query”匹配的分类（:count）',
                    'explore-all-matching-customers'  => '浏览所有与“:query”匹配的客户（:count）',
                    'explore-all-matching-orders'     => '浏览所有与“:query”匹配的订单（:count）',
                    'explore-all-matching-products'   => '浏览所有与“:query”匹配的产品（:count）',
                    'explore-all-orders'              => '浏览所有订单',
                    'explore-all-products'            => '浏览所有产品',
                    'orders'                          => '订单',
                    'products'                        => '产品',
                    'sku'                             => 'SKU: :sku',
                    'title'                           => '超级搜索',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => '属性族',
                'attributes'               => '属性',
                'campaigns'                => '活动',
                'catalog'                  => '目录',
                'categories'               => '分类',
                'channels'                 => '渠道',
                'cms'                      => '内容管理系统',
                'collapse'                 => '折叠',
                'communications'           => '通信',
                'configure'                => '配置',
                'currencies'               => '货币',
                'customers'                => '客户',
                'dashboard'                => '仪表板',
                'data-transfer'            => '数据传输',
                'discount'                 => '折扣',
                'email-templates'          => '电子邮件模板',
                'events'                   => '事件',
                'exchange-rates'           => '汇率',
                'groups'                   => '分组',
                'imports'                  => '进口',
                'inventory-sources'        => '库存来源',
                'invoices'                 => '发票',
                'locales'                  => '语言环境',
                'marketing'                => '营销',
                'mode'                     => '暗模式',
                'newsletter-subscriptions' => '通讯订阅',
                'orders'                   => '订单',
                'products'                 => '产品',
                'promotions'               => '促销',
                'refunds'                  => '退款',
                'reporting'                => '报告',
                'reviews'                  => '评论',
                'roles'                    => '角色',
                'sales'                    => '销售',
                'search-seo'               => '搜索和SEO',
                'search-synonyms'          => '搜索同义词',
                'search-terms'             => '搜索词',
                'settings'                 => '设置',
                'shipments'                => '发货',
                'sitemaps'                 => '站点地图',
                'tax-categories'           => '税收分类',
                'tax-rates'                => '税率',
                'taxes'                    => '税收',
                'themes'                   => '主题',
                'transactions'             => '交易',
                'url-rewrites'             => 'URL 重写',
                'users'                    => '用户',
            ],
        ],

        'datagrid' => [
            'index' => [
                'no-records-selected'              => '没有选择任何记录。',
                'must-select-a-mass-action-option' => '您必须选择批量操作的选项。',
                'must-select-a-mass-action'        => '您必须选择一项批量操作。',
            ],

            'toolbar' => [
                'length-of' => ':length 的',
                'of'        => '的',
                'per-page'  => '每页',
                'results'   => ':total 结果',
                'selected'  => ':total 已选择',

                'mass-actions' => [
                    'select-action' => '选择操作',
                    'select-option' => '选择选项',
                    'submit'        => '提交',
                ],

                'filter' => [
                    'apply-filters-btn' => '应用过滤器',
                    'back-btn'          => '返回',
                    'create-new-filter' => '创建新过滤器',
                    'custom-filters'    => '自定义过滤器',
                    'delete-error'      => '删除过滤器时出了点问题，请再试一次。',
                    'delete-success'    => '成功删除过滤器。',
                    'empty-description' => '没有可保存的选定过滤器。请选择要保存的过滤器。',
                    'empty-title'       => '添加要保存的过滤器',
                    'name'              => '名称',
                    'quick-filters'     => '快速过滤器',
                    'save-btn'          => '保存',
                    'save-filter'       => '保存过滤器',
                    'saved-success'     => '成功保存过滤器。',
                    'selected-filters'  => '已选过滤器',
                    'title'             => '过滤器',
                    'update'            => '更新',
                    'update-filter'     => '更新筛选器',
                    'updated-success'   => '过滤器已成功更新。',
                ],

                'search' => [
                    'title' => '搜索',
                ],
            ],

            'filters' => [
                'select' => '选择',
                'title'  => '过滤器',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => '请输入至少2个字符...',
                        'no-results'        => '未找到结果...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => '清除所有',
                    'title'     => '自定义筛选',
                ],

                'boolean-options' => [
                    'false' => '假',
                    'true'  => '真',
                ],

                'date-options' => [
                    'last-month'        => '上个月',
                    'last-six-months'   => '过去6个月',
                    'last-three-months' => '过去3个月',
                    'this-month'        => '本月',
                    'this-week'         => '本周',
                    'this-year'         => '今年',
                    'today'             => '今天',
                    'yesterday'         => '昨天',
                ],
            ],

            'table' => [
                'actions'              => '操作',
                'no-records-available' => '没有可用记录。',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => '同意',
                'disagree-btn' => '不同意',
                'message'      => '您确定要执行此操作吗？',
                'title'        => '您确定吗？',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => '添加所选产品',
                'empty-info'    => '没有找到与搜索词匹配的产品。',
                'empty-title'   => '未找到任何产品',
                'product-image' => '产品图片',
                'qty'           => ':qty 可用',
                'sku'           => 'SKU - :sku',
                'title'         => '选择产品',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => '添加图片',
                'ai-add-image-btn'  => '魔法 AI',
                'ai-btn-info'       => '生成图像',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => '仅允许图像文件（.jpeg、.jpg、.png 等）。',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => '应用',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => '生成',
                    'generating'       => '生成中...',
                    'hd'               => '高清',
                    'model'            => '模型',
                    'number-of-images' => '图片数量',
                    'prompt'           => '提示',
                    'quality'          => '质量',
                    'regenerate'       => '重新生成',
                    'regenerating'     => '重新生成中...',
                    'size'             => '大小',
                    'standard'         => '标准',
                    'title'            => 'AI 图像生成',
                ],

                'placeholders' => [
                    'front'     => '正面',
                    'next'      => '下一个',
                    'size'      => '尺寸',
                    'use-cases' => '用途',
                    'zoom'      => '缩放',
                ],
            ],

            'videos' => [
                'add-video-btn'     => '添加视频',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => '仅允许视频文件（.mp4、.mov、.ogg 等）。',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => '魔法 AI',

            'ai-generation' => [
                'apply'                  => '应用',
                'dolphin-phi'            => 'Dolphin Phi',
                'generate'               => '生成',
                'generated-content'      => '生成的内容',
                'generated-content-info' => 'AI内容可能具有误导性。请在应用之前审查生成的内容。',
                'generating'             => '生成中...',
                'gpt-3-5-turbo'          => 'OpenAI gpt-3.5-turbo',
                'llama2'                 => 'Llama 2',
                'llama2-uncensored'      => 'Llama 2 未经审查',
                'llama2:13b'             => 'Llama 2 13B',
                'llama2:70b'             => 'Llama 2 70B',
                'llava'                  => 'LLaVA',
                'mistral'                => 'Mistral',
                'model'                  => '模型',
                'orca-mini'              => 'Orca Mini',
                'phi'                    => 'Phi-2',
                'prompt'                 => '提示',
                'starling-lm'            => 'Starling',
                'title'                  => 'AI辅助',
                'vicuna'                 => 'Vicuna',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => '地址',
        'attribute-families'       => '属性族',
        'attributes'               => '属性',
        'campaigns'                => '活动',
        'cancel'                   => '取消',
        'cart-rules'               => '购物车规则',
        'catalog-rules'            => '目录规则',
        'catalog'                  => '目录',
        'categories'               => '分类',
        'channels'                 => '渠道',
        'cms'                      => 'CMS',
        'communications'           => '通信',
        'configure'                => '配置',
        'copy'                     => '复制',
        'create'                   => '创造',
        'currencies'               => '货币',
        'customers'                => '顾客',
        'data-transfer'            => '数据传输',
        'dashboard'                => '仪表板',
        'delete'                   => '删除',
        'edit'                     => '编辑',
        'email-templates'          => '电子邮件模板',
        'events'                   => '事件',
        'exchange-rates'           => '汇率',
        'groups'                   => '群组',
        'import'                   => '进口',
        'imports'                  => '进口',
        'inventory-sources'        => '库存来源',
        'invoices'                 => '发票',
        'locales'                  => '区域设置',
        'marketing'                => '营销',
        'newsletter-subscriptions' => '电子报订阅',
        'note'                     => '备注',
        'orders'                   => '订单',
        'products'                 => '产品',
        'promotions'               => '促销活动',
        'refunds'                  => '退款',
        'reporting'                => '报告',
        'reviews'                  => '评论',
        'roles'                    => '角色',
        'sales'                    => '销售',
        'search-seo'               => '搜索和SEO',
        'search-synonyms'          => '搜索同义词',
        'search-terms'             => '搜索词',
        'settings'                 => '设置',
        'shipments'                => '发货',
        'sitemaps'                 => '网站地图',
        'subscribers'              => '电子报订阅者',
        'tax-categories'           => '税务类别',
        'tax-rates'                => '税率',
        'taxes'                    => '税费',
        'themes'                   => '主题',
        'transactions'             => '交易',
        'url-rewrites'             => 'URL 重写',
        'users'                    => '用户',
        'view'                     => '查看',
    ],

    'errors' => [
        'dashboard' => '仪表盘',
        'go-back'   => '返回',
        'support'   => '如果问题持续存在，请通过<a href=":link" class=":class">:email</a>联系我们以寻求帮助。',

        '404' => [
            'description' => '哎呀！您正在寻找的页面似乎在度假。似乎我们无法找到您正在搜索的内容。',
            'title'       => '404 页面未找到',
        ],

        '401' => [
            'description' => '哎呀！看起来您无权访问此页面。似乎您缺少必要的凭证。',
            'title'       => '401 未经授权',
        ],

        '403' => [
            'description' => '哎呀！此页面受限制。似乎您没有查看此内容所需的权限。',
            'title'       => '403 禁止访问',
        ],

        '500' => [
            'description' => '哎呀！出了些问题。似乎我们在加载您所寻找的页面时遇到了问题。',
            'title'       => '500 内部服务器错误',
        ],

        '503' => [
            'description' => '哎呀！看起来我们暂时停机进行维护。请稍后再查看。',
            'title'       => '503 服务不可用',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => '下载',
        'export'     => '导出',
        'no-records' => '没有要导出的内容',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => '此slug在类别或产品中正在使用。',
        'slug-reserved'   => '此slug已保留。',
    ],

    'footer' => [
        'copy-right' => '由 <a href="https://bagisto.com/" target="_blank">Bagisto</a> 提供支持，一个由 <a href="https://webkul.com/" target="_blank">Webkul</a> 社区支持的项目',
    ],

    'emails' => [
        'dear'   => '尊敬的 :admin_name',
        'thanks' => '如果您需要任何帮助，请联系我们：<a href=":link" style=":style">:email</a>。<br/>谢谢！',

        'admin' => [
            'forgot-password' => [
                'description'    => '您收到此电子邮件是因为我们收到了您的帐户的密码重置请求。',
                'greeting'       => '忘记密码！',
                'reset-password' => '重置密码',
                'subject'        => '重置密码电子邮件',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => '新的客户帐户已成功创建。 他们现在可以使用电子邮件地址和密码凭据登录。 登录后，他们将可以访问各种服务，包括查看过去的订单、管理愿望清单和更新帐户信息的能力。',
                'greeting'    => '我们热烈欢迎刚刚在我们这里注册的新客户：customer_name！',
                'subject'     => '新客户注册',
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => '您在 :created_at 下单了新订单 :order_id',
                'subject'  => '新订单确认',
                'summary'  => '订单摘要',
                'title'    => '订单确认！',
            ],

            'invoiced' => [
                'greeting' => '您在 :created_at 创建的订单 :order_id 的发票 #:invoice_id',
                'subject'  => '新发票确认',
                'summary'  => '发票摘要',
                'title'    => '发票确认！',
            ],

            'shipped' => [
                'greeting' => '您在 :created_at 下的订单 :order_id 已发货',
                'subject'  => '新发货确认',
                'summary'  => '发货摘要',
                'title'    => '订单已发货！',
            ],

            'inventory-source' => [
                'greeting' => '您在 :created_at 下的订单 :order_id 已发货',
                'subject'  => '新发货确认',
                'summary'  => '发货摘要',
                'title'    => '订单已发货！',
            ],

            'refunded' => [
                'greeting' => '您在 :created_at 下的订单 :order_id 已退款',
                'subject'  => '新退款确认',
                'summary'  => '退款摘要',
                'title'    => '订单已退款！',
            ],

            'canceled' => [
                'greeting' => '您在 :created_at 下的订单 :order_id 已取消',
                'subject'  => '新订单取消',
                'summary'  => '订单摘要',
                'title'    => '订单已取消！',
            ],

            'billing-address'            => '账单地址',
            'carrier'                    => '承运人',
            'contact'                    => '联系人',
            'discount'                   => '折扣',
            'excl-tax'                   => '不含税：',
            'grand-total'                => '总计',
            'name'                       => '名称',
            'payment'                    => '支付',
            'price'                      => '价格',
            'qty'                        => '数量',
            'shipping-address'           => '送货地址',
            'shipping-handling-excl-tax' => '运输和处理（不含税）',
            'shipping-handling-incl-tax' => '运输和处理（含税）',
            'shipping-handling'          => '运输和处理',
            'shipping'                   => '运输',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => '小计（不含税）',
            'subtotal-incl-tax'          => '小计（含税）',
            'subtotal'                   => '小计',
            'tax'                        => '税费',
            'tracking-number'            => '跟踪号码：:tracking_number',
        ],
    ],
];
