<?php

return [
    'customers' => [
        'forgot-password' => [
            'already-sent'         => 'Лист для скидання пароля вже надіслано.',
            'back'                 => 'Повернутися до входу?',
            'bagisto'              => 'Багісто',
            'email'                => 'Електронна пошта',
            'email-not-exist'      => 'Ми не можемо знайти користувача за цією адресою електронної пошти.',
            'footer'               => '© Копірайт 2010 - :current_year, Webkul Software (зареєстрована в Індії). Всі права захищені.',
            'forgot-password-text' => 'Якщо ви забули свій пароль, відновіть його, введіть свою електронну адресу.',
            'page-title'           => 'Забули пароль?',
            'reset-link-sent'      => 'Ми відправили вам посилання на скидання пароля на вашу електронну пошту.',
            'sign-in-button'       => 'Увійти',
            'submit'               => 'Скинути пароль',
            'title'                => 'Відновлення паролю',
        ],

        'reset-password' => [
            'back-link-title'  => 'Повернутися до входу',
            'bagisto'          => 'Багісто',
            'confirm-password' => 'Підтвердити пароль',
            'email'            => 'Зареєстрована електронна пошта',
            'footer'           => '© Копірайт 2010 - :current_year, Webkul Software (зареєстрована в Індії). Всі права захищені.',
            'password'         => 'Пароль',
            'submit-btn-title' => 'Скинути пароль',
            'title'            => 'Скидання паролю',
        ],

        'login-form' => [
            'bagisto'             => 'Багісто',
            'button-title'        => 'Увійти',
            'create-your-account' => 'Створити свій обліковий запис',
            'email'               => 'Електронна пошта',
            'footer'              => '© Копірайт 2010 - :current_year, Webkul Software (зареєстрована в Індії). Всі права захищені.',
            'forgot-pass'         => 'Забули пароль?',
            'form-login-text'     => 'Якщо у вас є обліковий запис, увійдіть за допомогою своєї електронної адреси.',
            'invalid-credentials' => 'Перевірте свої облікові дані та спробуйте ще раз.',
            'new-customer'        => 'Новий користувач?',
            'not-activated'       => 'Ваш активний запит очікує схвалення адміністратора',
            'page-title'          => 'Вхід користувача',
            'password'            => 'Пароль',
            'show-password'       => 'Показати пароль',
            'title'               => 'Увійти',
            'verify-first'        => 'Спершу перевірте свою електронну пошту.',
        ],

        'signup-form' => [
            'account-exists'              => 'Вже є обліковий запис?',
            'bagisto'                     => 'Багісто',
            'button-title'                => 'Зареєструватися',
            'confirm-pass'                => 'Підтвердіть пароль',
            'email'                       => 'Електронна пошта',
            'first-name'                  => 'Ім’я',
            'footer'                      => '© Копірайт 2010 - :current_year, Webkul Software (зареєстрована в Індії). Всі права захищені.',
            'form-signup-text'            => 'Якщо ви новачок у нашому магазині, ми раді вас бачити як учасника.',
            'last-name'                   => 'Прізвище',
            'page-title'                  => 'Стати користувачем',
            'password'                    => 'Пароль',
            'sign-in-button'              => 'Увійти',
            'subscribe-to-newsletter'     => 'Підписатися на розсилку',
            'success'                     => 'Обліковий запис успішно створено.',
            'success-verify'              => 'Обліковий запис успішно створено, на вашу електронну адресу відправлено лист для підтвердження.',
            'success-verify-email-unsent' => 'Обліковий запис успішно створено, але лист із запитом на підтвердження не відправлено.',
            'verification-not-sent'       => 'Помилка! Під час надсилання листа для підтвердження сталася помилка, спробуйте ще раз пізніше.',
            'verification-sent'           => 'Лист для підтвердження надіслано',
            'verified'                    => 'Ваш обліковий запис підтверджено, спробуйте увійти зараз.',
            'verify-failed'               => 'Не вдалося підтвердити вашу електронну адресу.',
        ],

        'account' => [
            'home' => 'Главная',

            'profile' => [
                'index' => [
                    'delete'         => 'Видалити',
                    'delete-failed'  => 'Помилка при видаленні облікового запису користувача.',
                    'delete-profile' => 'Видалити профіль',
                    'delete-success' => 'Обліковий запис користувача успішно видалено',
                    'dob'            => 'Дата народження',
                    'edit'           => 'Редагувати',
                    'edit-success'   => 'Профіль успішно оновлено',
                    'email'          => 'Email',
                    'enter-password' => 'Введіть ваш пароль',
                    'first-name'     => 'Ім\'я',
                    'gender'         => 'Стать',
                    'last-name'      => 'Прізвище',
                    'order-pending'  => 'Не можна видалити обліковий запис користувача, оскільки є замовлення в стані очікування або обробки.',
                    'title'          => 'Профіль',
                    'unmatched'      => 'Старий пароль не збігається.',
                    'wrong-password' => 'Неправильний пароль!',
                ],

                'edit' => [
                    'confirm-password'        => 'Підтвердіть пароль',
                    'current-password'        => 'Поточний пароль',
                    'dob'                     => 'Дата народження',
                    'edit'                    => 'Редагувати',
                    'edit-profile'            => 'Редагувати профіль',
                    'email'                   => 'Email',
                    'female'                  => 'Жіноча',
                    'first-name'              => 'Ім\'я',
                    'gender'                  => 'Стать',
                    'last-name'               => 'Прізвище',
                    'male'                    => 'Чоловіча',
                    'new-password'            => 'Новий пароль',
                    'other'                   => 'Інша',
                    'phone'                   => 'Телефон',
                    'save'                    => 'Зберегти',
                    'subscribe-to-newsletter' => 'Підписатися на розсилку',
                ],
            ],

            'addresses' => [
                'index' => [
                    'add-address'      => 'Додати адресу',
                    'create-success'   => 'Адресу успішно додано.',
                    'default-address'  => 'Адреса за замовчуванням',
                    'default-delete'   => 'Адресу за замовчуванням не можна змінити.',
                    'delete'           => 'Видалити',
                    'delete-success'   => 'Адресу успішно видалено',
                    'edit'             => 'Редагувати',
                    'edit-success'     => 'Адресу успішно оновлено.',
                    'empty-address'    => 'Ви ще не додали адресу до свого облікового запису.',
                    'security-warning' => 'Виявлено підозрілу активність!!!',
                    'set-as-default'   => 'Встановити за замовчуванням',
                    'title'            => 'Адреса',
                    'update-success'   => 'Адресу успішно оновлено.',
                ],

                'create' => [
                    'add-address'    => 'Додати адресу',
                    'city'           => 'Місто',
                    'company-name'   => 'Назва компанії',
                    'country'        => 'Країна',
                    'email'          => 'Email',
                    'first-name'     => 'Ім\'я',
                    'last-name'      => 'Прізвище',
                    'phone'          => 'Телефон',
                    'post-code'      => 'Поштовий індекс',
                    'save'           => 'Зберегти',
                    'select-country' => 'Виберіть країну',
                    'set-as-default' => 'Встановити за замовчуванням',
                    'state'          => 'Область',
                    'street-address' => 'Вулиця та номер будинку',
                    'title'          => 'Адреса',
                    'vat-id'         => 'Ідентифікаційний номер ПДВ',
                ],

                'edit' => [
                    'city'           => 'Місто',
                    'company-name'   => 'Назва компанії',
                    'country'        => 'Країна',
                    'edit'           => 'Редагувати',
                    'email'          => 'Email',
                    'first-name'     => 'Ім\'я',
                    'last-name'      => 'Прізвище',
                    'phone'          => 'Телефон',
                    'post-code'      => 'Поштовий індекс',
                    'select-country' => 'Виберіть країну',
                    'state'          => 'Область',
                    'street-address' => 'Вулиця та номер будинку',
                    'title'          => 'Адреса',
                    'update-btn'     => 'Оновити',
                    'vat-id'         => 'Ідентифікаційний номер ПДВ',
                ],
            ],

            'orders' => [
                'action'      => 'Действие',
                'action-view' => 'Просмотр',
                'empty-order' => 'Вы еще не заказывали ни одного продукта',
                'order'       => 'Замовлення',
                'order-date'  => 'Дата замовлення',
                'order-id'    => 'ID замовлення',
                'subtotal'    => 'Підсумок',
                'title'       => 'Замовлення',
                'total'       => 'Всього',

                'status' => [
                    'title' => 'Статус',

                    'options' => [
                        'canceled'        => 'Отменен',
                        'closed'          => 'Закрыт',
                        'completed'       => 'Завершен',
                        'fraud'           => 'Мошенничество',
                        'pending'         => 'В ожидании',
                        'pending-payment' => 'Ожидание оплаты',
                        'processing'      => 'Обработка',
                    ],
                ],

                'view' => [
                    'billing-address'      => 'Адреса платника',
                    'cancel-btn-title'     => 'Скасувати',
                    'cancel-confirm-msg'   => 'Ви впевнені, що хочете скасувати це замовлення?',
                    'cancel-error'         => 'Ваше замовлення не може бути скасоване.',
                    'cancel-success'       => 'Ваше замовлення було скасоване',
                    'contact'              => 'Контакт',
                    'item-invoiced'        => 'Товар виставлений на рахунок',
                    'item-refunded'        => 'Товар повернутий',
                    'item-shipped'         => 'Товар відправлений',
                    'item-ordered'         => 'Товар замовлений',
                    'order-id'             => 'ID замовлення',
                    'page-title'           => 'Замовлення #:order_id',
                    'payment-method'       => 'Спосіб оплати',
                    'reorder-btn-title'    => 'Повторне замовлення',
                    'shipping-address'     => 'Адреса доставки',
                    'shipping-method'      => 'Спосіб доставки',
                    'shipping-and-payment' => 'Деталі доставки та оплати',
                    'status'               => 'Статус',
                    'title'                => 'Перегляд',
                    'total'                => 'Всього',

                    'information' => [
                        'discount'                   => 'Знижка',
                        'excl-tax'                   => 'Без ПДВ:',
                        'grand-total'                => 'Загальна сума',
                        'info'                       => 'Інформація',
                        'item-canceled'              => 'Скасовано (:qty_canceled)',
                        'item-refunded'              => 'Повернуто (:qty_refunded)',
                        'invoiced-item'              => 'Виставлено на рахунок (:qty_invoiced)',
                        'item-shipped'               => 'Відправлено (:qty_shipped)',
                        'item-status'                => 'Статус товару',
                        'ordered-item'               => 'Замовлено (:qty_ordered)',
                        'placed-on'                  => 'Дата замовлення',
                        'price'                      => 'Ціна',
                        'product-name'               => 'Назва',
                        'shipping-handling'          => 'Доставка та обробка',
                        'shipping-handling-excl-tax' => 'Доставка та обробка (Без ПДВ)',
                        'shipping-handling-incl-tax' => 'Доставка та обробка (З ПДВ)',
                        'sku'                        => 'Артикул',
                        'subtotal'                   => 'Підсумок',
                        'subtotal-excl-tax'          => 'Підсумок (Без ПДВ)',
                        'subtotal-incl-tax'          => 'Підсумок (З ПДВ)',
                        'order-summary'              => 'Підсумок замовлення',
                        'tax'                        => 'Податок',
                        'tax-amount'                 => 'Сума податку',
                        'tax-percent'                => 'Відсоток податку',
                        'total-due'                  => 'Всього до сплати',
                        'total-paid'                 => 'Всього сплачено',
                        'total-refunded'             => 'Всього повернуто',
                    ],

                    'invoices' => [
                        'discount'                   => 'Знижка',
                        'excl-tax'                   => 'Без ПДВ:',
                        'grand-total'                => 'Загальна сума',
                        'individual-invoice'         => 'Рахунок #:invoice_id',
                        'invoices'                   => 'Рахунки',
                        'price'                      => 'Ціна',
                        'print'                      => 'Друк',
                        'product-name'               => 'Назва',
                        'products-ordered'           => 'Замовлені товари',
                        'qty'                        => 'Кількість',
                        'shipping-handling-excl-tax' => 'Доставка та обробка (Без ПДВ)',
                        'shipping-handling-incl-tax' => 'Доставка та обробка (З ПДВ)',
                        'shipping-handling'          => 'Доставка та обробка',
                        'sku'                        => 'Артикул',
                        'subtotal-excl-tax'          => 'Підсумок (Без ПДВ)',
                        'subtotal-incl-tax'          => 'Підсумок (З ПДВ)',
                        'subtotal'                   => 'Підсумок',
                        'tax'                        => 'Податок',
                        'tax-amount'                 => 'Сума податку',
                    ],

                    'shipments' => [
                        'individual-shipment' => 'Відправлення #:shipment_id',
                        'product-name'        => 'Назва',
                        'qty'                 => 'Кількість',
                        'shipments'           => 'Відправлення',
                        'sku'                 => 'Артикул',
                        'subtotal'            => 'Підсумок',
                        'tracking-number'     => 'Номер відстеження',
                    ],

                    'refunds' => [
                        'adjustment-fee'             => 'Комісія за коригування',
                        'adjustment-refund'          => 'Коригування повернення',
                        'discount'                   => 'Знижка',
                        'grand-total'                => 'Загальна сума',
                        'individual-refund'          => 'Повернення #:refund_id',
                        'no-result-found'            => 'Ми не знайшли жодних записів.',
                        'order-summary'              => 'Підсумок замовлення',
                        'price'                      => 'Ціна',
                        'product-name'               => 'Назва',
                        'qty'                        => 'Кількість',
                        'refunds'                    => 'Повернення',
                        'shipping-handling'          => 'Доставка та обробка',
                        'shipping-handling-excl-tax' => 'Доставка та обробка (Без ПДВ)',
                        'shipping-handling-incl-tax' => 'Доставка та обробка (З ПДВ)',
                        'sku'                        => 'Артикул',
                        'subtotal'                   => 'Підсумок',
                        'subtotal-excl-tax'          => 'Підсумок (Без ПДВ)',
                        'subtotal-incl-tax'          => 'Підсумок (З ПДВ)',
                        'tax'                        => 'Податок',
                        'tax-amount'                 => 'Сума податку',
                    ],
                ],

                'invoice-pdf' => [
                    'bank-details'               => 'Банківські реквізити',
                    'bill-to'                    => 'Платник',
                    'contact-number'             => 'Контактний номер',
                    'contact'                    => 'Контакт',
                    'date'                       => 'Дата рахунку',
                    'discount'                   => 'Знижка',
                    'excl-tax'                   => 'Без податку:',
                    'grand-total'                => 'Загальна сума',
                    'invoice-id'                 => 'ID рахунку-фактури',
                    'invoice'                    => 'Рахунок-фактура',
                    'order-date'                 => 'Дата замовлення',
                    'order-id'                   => 'ID замовлення',
                    'payment-method'             => 'Спосіб оплати',
                    'payment-terms'              => 'Умови оплати',
                    'price'                      => 'Ціна',
                    'product-name'               => 'Назва товару',
                    'qty'                        => 'Кількість',
                    'ship-to'                    => 'Адреса доставки',
                    'shipping-handling-excl-tax' => 'Доставка та обробка (без податку)',
                    'shipping-handling-incl-tax' => 'Доставка та обробка (з податком)',
                    'shipping-handling'          => 'Доставка та обробка',
                    'shipping-method'            => 'Метод доставки',
                    'sku'                        => 'Артикул',
                    'subtotal-excl-tax'          => 'Підсумок (без податку)',
                    'subtotal-incl-tax'          => 'Підсумок (з податком)',
                    'subtotal'                   => 'Підсумок',
                    'tax-amount'                 => 'Сума податку',
                    'tax'                        => 'Податок',
                    'vat-number'                 => 'Номер платника ПДВ',
                ],
            ],

            'reviews' => [
                'empty-review' => 'Вы еще не оставили отзыв о товаре',
                'title'        => 'Отзывы',
            ],

            'downloadable-products' => [
                'available'           => 'в наявності',
                'completed'           => 'Виконано',
                'date'                => 'Дата',
                'download-error'      => 'Ссылка для скачивания устарела.',
                'expired'             => 'Закінчився',
                'empty-product'       => 'У вас нет товаров для скачивания',
                'name'                => 'Товары для скачивания',
                'orderId'             => 'Идентификатор заказа',
                'pending'             => 'В очікуванні',
                'payment-error'       => 'Оплата не была выполнена за это скачивание.',
                'records-found'       => 'Найдено записей',
                'remaining-downloads' => 'Оставшиеся загрузки',
                'status'              => 'Статус',
                'title'               => 'Заголовок',
            ],

            'wishlist' => [
                'color'              => 'Цвет',
                'delete-all'         => 'Удалить все',
                'empty'              => 'На странице списка желаний нет добавленных товаров.',
                'move-to-cart'       => 'Переместить в корзину',
                'moved'              => 'Товар успешно перемещен в корзину',
                'moved-success'      => 'Товар успешно перемещен в корзину',
                'page-title'         => 'Список желаний',
                'product-removed'    => 'Товар больше не доступен, так как его удалил администратор',
                'profile'            => 'Профиль',
                'remove'             => 'Удалить',
                'remove-all-success' => 'Все товары из вашего списка желаний были удалены',
                'remove-fail'        => 'Товар не может быть удален из списка желаний',
                'removed'            => 'Товар успешно удален из списка желаний',
                'see-details'        => 'Подробности',
                'success'            => 'Товар успешно добавлен в список желаний',
                'title'              => 'Список желаний',
            ],
        ],
    ],

    'components' => [
        'accordion' => [
            'default-content' => 'Зміст за замовчуванням',
            'default-header'  => 'Заголовок за замовчуванням',
        ],

        'drawer' => [
            'default-toggle'  => 'Перемикач за замовчуванням',
        ],

        'media' => [
            'index' => [
                'add-attachments' => 'Додати вкладення',
                'add-image'       => 'Додати зображення',
            ],
        ],

        'layouts' => [
            'header' => [
                'account'           => 'Обліковий запис',
                'bagisto'           => 'Багісто',
                'cart'              => 'Кошик',
                'compare'           => 'Порівняння',
                'dropdown-text'     => 'Керування кошиком, замовленнями та списком бажань',
                'logout'            => 'Вийти',
                'no-category-found' => 'Категорія не знайдена.',
                'orders'            => 'Замовлення',
                'profile'           => 'Профіль',
                'search'            => 'Пошук',
                'search-text'       => 'Шукати продукти тут',
                'sign-in'           => 'Увійти',
                'sign-up'           => 'Зареєструватися',
                'submit'            => 'Відправити',
                'title'             => 'Обліковий запис',
                'welcome'           => 'Ласкаво просимо',
                'welcome-guest'     => 'Ласкаво просимо, Гість',
                'wishlist'          => 'Список бажань',

                'desktop' => [
                    'top' => [
                        'default-locale' => 'Мова за замовчуванням',
                    ],
                ],

                'mobile' => [
                    'currencies' => 'Валюти',
                    'locales'    => 'Мови',
                    'login'      => 'Зареєструватися або Увійти',
                ],
            ],

            'footer' => [
                'about-us'               => 'Про нас',
                'contact-us'             => 'Зв\'язатися з нами',
                'currency'               => 'Валюта',
                'customer-service'       => 'Служба підтримки',
                'email'                  => 'Електронна пошта',
                'footer-content'         => 'Вміст нижнього колонтитула',
                'footer-text'            => '© Авторське право 2010 - :current_year, Webkul Software (зареєстровано в Індії). Усі права захищені.',
                'locale'                 => 'Мова',
                'newsletter-text'        => 'Готуйтеся до наших цікавих новин!',
                'order-return'           => 'Замовлення та повернення',
                'payment-policy'         => 'Політика оплати',
                'privacy-cookies-policy' => 'Політика конфіденційності та файлів cookie',
                'shipping-policy'        => 'Політика доставки',
                'subscribe'              => 'Підписатися',
                'subscribe-newsletter'   => 'Підписатися на розсилку',
                'subscribe-stay-touch'   => 'Підпишіться, щоб залишатися на зв\'язку.',
                'whats-new'              => 'Що нового',
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => ':length з',
                'results'   => ':total Результати',
                'selected'  => ':total Вибрано',

                'mass-actions' => [
                    'must-select-a-mass-action'        => 'Ви повинні вибрати масову дію.',
                    'must-select-a-mass-action-option' => 'Ви повинні вибрати опцію масової дії.',
                    'no-records-selected'              => 'Не вибрано жодного запису.',
                    'select-action'                    => 'Вибрати дію',
                ],

                'search' => [
                    'title' => 'Пошук',
                ],

                'filter' => [
                    'apply-filter' => 'Застосувати фільтри',
                    'title'        => 'Фільтр',

                    'dropdown' => [
                        'select' => 'Вибрати',

                        'searchable' => [
                            'at-least-two-chars' => 'Введіть принаймні 2 символи...',
                            'no-results'         => 'Результатів не знайдено...',
                        ],
                    ],

                    'custom-filters' => [
                        'clear-all' => 'Очистити все',
                    ],
                ],
            ],

            'table' => [
                'actions'              => 'Дії',
                'next-page'            => 'Наступна сторінка',
                'no-records-available' => 'Немає доступних записів.',
                'of'                   => 'з :total записів',
                'page-navigation'      => 'Навігація сторінок',
                'page-number'          => 'Номер сторінки',
                'previous-page'        => 'Попередня сторінка',
                'showing'              => 'Показано :firstItem',
                'to'                   => 'до :lastItem',
            ],
        ],

        'modal' => [
            'default-content' => 'Зміст за замовчуванням',
            'default-header'  => 'Заголовок за замовчуванням',

            'confirm' => [
                'agree-btn'    => 'Погодитися',
                'disagree-btn' => 'Відмовитися',
                'message'      => 'Ви впевнені, що хочете виконати цю дію?',
                'title'        => 'Ви впевнені?',
            ],
        ],

        'products' => [
            'card' => [
                'add-to-cart'            => 'Додати до Кошика',
                'add-to-compare'         => 'Додати до Списку Порівнянь',
                'add-to-compare-success' => 'Товар успішно додано до списку порівнянь.',
                'add-to-wishlist'        => 'Додати до Списку Бажань',
                'already-in-compare'     => 'Товар вже додано до списку порівнянь.',
                'new'                    => 'Новинка',
                'review-description'     => 'Будьте першим, хто оцінить цей товар',
                'sale'                   => 'Розпродаж',
            ],

            'carousel' => [
                'next'     => 'Наступний',
                'previous' => 'Попередній',
                'view-all' => 'Переглянути Всі',
            ],

            'ratings' => [
                'title' => 'Рейтинги',
            ],
        ],

        'range-slider' => [
            'max-range' => 'Максимальний Діапазон',
            'min-range' => 'Мінімальний Діапазон',
            'range'     => 'Діапазон:',
        ],

        'carousel' => [
            'image-slide' => 'Зображення Слайду',
            'next'        => 'Наступний',
            'previous'    => 'Попередній',
        ],

        'quantity-changer' => [
            'decrease-quantity' => 'Зменшити Кількість',
            'increase-quantity' => 'Збільшити Кількість',
        ],
    ],

    'products' => [
        'prices' => [
            'grouped' => [
                'starting-at' => 'Починається з',
            ],

            'configurable' => [
                'as-low-as' => 'Від',
            ],
        ],

        'sort-by' => [
            'title'   => 'Сортувати за',
        ],

        'view' => [
            'type' => [
                'configurable' => [
                    'select-options'       => 'Будь ласка, виберіть опцію',
                    'select-above-options' => 'Будь ласка, виберіть опції вище',
                ],

                'bundle' => [
                    'none'         => 'Немає',
                    'total-amount' => 'Загальна сума',
                ],

                'downloadable' => [
                    'links'   => 'Посилання',
                    'sample'  => 'Зразок',
                    'samples' => 'Зразки',
                ],

                'grouped' => [
                    'name' => 'Назва',
                ],
            ],

            'gallery' => [
                'product-image'   => 'Зображення товару',
                'thumbnail-image' => 'Зменшуване зображення',
            ],

            'reviews' => [
                'attachments'      => 'Вкладення',
                'cancel'           => 'Скасувати',
                'comment'          => 'Коментар',
                'customer-review'  => 'Відгуки клієнтів',
                'empty-review'     => 'Відгуків не знайдено, будьте першим, хто залишить відгук про цей товар',
                'failed-to-upload' => 'Не вдалося завантажити зображення',
                'load-more'        => 'Завантажити ще',
                'name'             => 'Назва',
                'rating'           => 'Рейтинг',
                'ratings'          => 'Рейтинги',
                'submit-review'    => 'Надіслати відгук',
                'success'          => 'Відгук успішно надіслано.',
                'title'            => 'Заголовок',
                'translate'        => 'Переклад',
                'translating'      => 'Переклад...',
                'write-a-review'   => 'Написати відгук',
            ],

            'add-to-cart'            => 'Додати до кошика',
            'add-to-compare'         => 'Товар додано в порівняння.',
            'add-to-wishlist'        => 'Додати до Списку Бажань',
            'additional-information' => 'Додаткова інформація',
            'already-in-compare'     => 'Товар вже додано в порівняння.',
            'buy-now'                => 'Купити зараз',
            'compare'                => 'Порівняти',
            'description'            => 'Опис',
            'related-product-title'  => 'Супутні товари',
            'review'                 => 'Відгуки',
            'tax-inclusive'          => 'З усіма податками',
            'up-sell-title'          => 'Ми знайшли інші товари, які вам можуть сподобатися!',
        ],

        'type' => [
            'abstract' => [
                'offers' => 'Купуйте :qty за :price кожний і економте :discount',
            ],
        ],
    ],

    'categories' => [
        'filters' => [
            'clear-all' => 'Очистити всі',
            'filter'    => 'Фільтр',
            'filters'   => 'Фільтри:',
            'sort'      => 'Сортувати',
        ],

        'toolbar' => [
            'grid' => 'Сітка',
            'list' => 'Список',
            'show' => 'Показати',
        ],

        'view' => [
            'empty'     => 'У цій категорії немає товарів',
            'load-more' => 'Завантажити ще',
        ],
    ],

    'search' => [
        'title'   => 'Результати пошуку для : :query',
        'results' => 'Результати пошуку',

        'images' => [
            'index' => [
                'only-images-allowed'  => 'Дозволені лише зображення (.jpeg, .jpg, .png, ..).',
                'search'               => 'Пошук',
                'size-limit-error'     => 'Помилка обмеження розміру',
                'something-went-wrong' => 'Щось пішло не так, будь ласка, спробуйте пізніше.',
            ],

            'results' => [
                'analyzed-keywords' => 'Аналізовані ключові слова:',
            ],
        ],
    ],

    'compare' => [
        'already-added'      => 'Товар вже додано до списку порівнянь',
        'delete-all'         => 'Видалити все',
        'empty-text'         => 'У вас немає товарів у списку порівнянь',
        'item-add-success'   => 'Товар успішно додано до списку порівнянь',
        'product-compare'    => 'Порівняння товарів',
        'remove-all-success' => 'Всі товари успішно видалено.',
        'remove-error'       => 'Виникла помилка. Будь ласка, спробуйте пізніше.',
        'remove-success'     => 'Товар успішно видалено.',
        'title'              => 'Порівняння товарів',
    ],

    'checkout' => [
        'success' => [
            'info'          => 'Ми надішлемо вам інформацію про замовлення та номер відстеження по електронній пошті',
            'order-id-info' => 'Номер вашого замовлення: #:order_id',
            'thanks'        => 'Дякуємо за ваше замовлення!',
            'title'         => 'Замовлення успішно оформлено',
        ],

        'cart' => [
            'continue-to-checkout'      => 'Продовжити оформлення замовлення',
            'illegal'                   => 'Кількість не може бути менше одного.',
            'inactive-add'              => 'Неактивний товар не може бути доданий до кошика.',
            'inactive'                  => 'Товар був деактивований та видалений з кошика.',
            'inventory-warning'         => 'Запитана кількість недоступна. Будь ласка, спробуйте пізніше.',
            'item-add-to-cart'          => 'Товар успішно додано',
            'minimum-order-message'     => 'Мінімальна сума замовлення становить',
            'missing-fields'            => 'Відсутні деякі обов\'язкові поля для цього товару.',
            'missing-options'           => 'Відсутні варіанти для цього товару.',
            'paypal-payment-cancelled'  => 'Платіж Paypal скасовано.',
            'qty-missing'               => 'Принаймні один товар повинен мати кількість більше 1.',
            'return-to-shop'            => 'Повернутися в магазин',
            'rule-applied'              => 'Правило кошика застосовано',
            'select-hourly-duration'    => 'Виберіть тривалість слоту одну годину.',
            'success-remove'            => 'Товар успішно видалено з кошика.',
            'suspended-account-message' => 'Ваш обліковий запис призупинено.',

            'index' => [
                'bagisto'                  => 'Багісто',
                'cart'                     => 'Кошик',
                'continue-shopping'        => 'Продовжити покупки',
                'empty-product'            => 'У вас немає товарів у кошику.',
                'excl-tax'                 => 'Без ПДВ:',
                'home'                     => 'Головна',
                'items-selected'           => ':count товари вибрані',
                'move-to-wishlist'         => 'Перемістити в список бажань',
                'move-to-wishlist-success' => 'Обрані товари успішно переміщено в список бажань.',
                'price'                    => 'Ціна',
                'product-name'             => 'Назва товару',
                'quantity'                 => 'Кількість',
                'quantity-update'          => 'Кількість успішно оновлена',
                'remove'                   => 'Видалити',
                'remove-selected-success'  => 'Обрані товари успішно видалено з кошика.',
                'see-details'              => 'Детальніше',
                'select-all'               => 'Вибрати все',
                'select-cart-item'         => 'Вибрати товар у кошику',
                'tax'                      => 'Податок',
                'total'                    => 'Всього',
                'update-cart'              => 'Оновити кошик',
                'view-cart'                => 'Переглянути кошик',

                'cross-sell' => [
                    'title' => 'Більше варіантів',
                ],
            ],

            'mini-cart' => [
                'continue-to-checkout' => 'Продовжити оформлення замовлення',
                'empty-cart'           => 'Ваш кошик порожній',
                'excl-tax'             => 'Без ПДВ:',
                'offer-on-orders'      => 'Отримайте до 30% ЗНИЖКА на ваше 1-е замовлення',
                'remove'               => 'Видалити',
                'see-details'          => 'Детальніше',
                'shopping-cart'        => 'Кошик',
                'subtotal'             => 'Підсумок',
                'view-cart'            => 'Переглянути кошик',
            ],

            'summary' => [
                'cart-summary'              => 'Підсумок кошика',
                'delivery-charges-excl-tax' => 'Вартість доставки (без ПДВ)',
                'delivery-charges-incl-tax' => 'Вартість доставки (з ПДВ)',
                'delivery-charges'          => 'Вартість доставки',
                'discount-amount'           => 'Сума знижки',
                'grand-total'               => 'Загальна сума',
                'place-order'               => 'Оформити замовлення',
                'proceed-to-checkout'       => 'Перейти до оформлення',
                'sub-total-excl-tax'        => 'Підсумок (без ПДВ)',
                'sub-total-incl-tax'        => 'Підсумок (з ПДВ)',
                'sub-total'                 => 'Підсумок',
                'tax'                       => 'Податок',

                'estimate-shipping' => [
                    'country'        => 'Країна',
                    'info'           => 'Введіть ваше місце призначення, щоб отримати оцінку вартості доставки та податку.',
                    'postcode'       => 'Поштовий індекс',
                    'select-country' => 'Вибрати країну',
                    'select-state'   => 'Вибрати область',
                    'state'          => 'Область',
                    'title'          => 'Оцінка вартості доставки та податку',
                ],
            ],
        ],

        'onepage' => [
            'address' => [
                'add-new'                => 'Додати нову адресу',
                'add-new-address'        => 'Додати нову адресу',
                'back'                   => 'Назад',
                'billing-address'        => 'Платіжна адреса',
                'check-billing-address'  => 'Відсутня адреса виставлення рахунку.',
                'check-shipping-address' => 'Відсутня адреса доставки.',
                'city'                   => 'Місто',
                'company-name'           => 'Назва компанії',
                'confirm'                => 'Підтвердити',
                'country'                => 'Країна',
                'email'                  => 'Електронна пошта',
                'first-name'             => 'Ім\'я',
                'last-name'              => 'Прізвище',
                'postcode'               => 'Поштовий індекс',
                'proceed'                => 'Продовжити',
                'same-as-billing'        => 'Використовувати той самий адрес для доставки?',
                'save'                   => 'Зберегти',
                'save-address'           => 'Зберегти в адресну книгу',
                'select-country'         => 'Вибрати країну',
                'select-state'           => 'Вибрати область',
                'shipping-address'       => 'Адреса доставки',
                'state'                  => 'Область',
                'street-address'         => 'Вулиця',
                'telephone'              => 'Телефон',
                'title'                  => 'Адреса',
            ],

            'index' => [
                'checkout' => 'Оформлення замовлення',
                'home'     => 'Головна',
            ],

            'payment' => [
                'payment-method' => 'Спосіб оплати',
            ],

            'shipping' => [
                'shipping-method' => 'Спосіб доставки',
            ],

            'summary' => [
                'cart-summary'              => 'Підсумок кошика',
                'delivery-charges-excl-tax' => 'Вартість доставки (без ПДВ)',
                'delivery-charges-incl-tax' => 'Вартість доставки (з ПДВ)',
                'delivery-charges'          => 'Вартість доставки',
                'discount-amount'           => 'Сума знижки',
                'excl-tax'                  => 'Без ПДВ:',
                'grand-total'               => 'Загальна сума',
                'place-order'               => 'Оформити замовлення',
                'price_&_qty'               => ':price × :qty',
                'processing'                => 'Обробка',
                'sub-total-excl-tax'        => 'Підсумок (без ПДВ)',
                'sub-total-incl-tax'        => 'Підсумок (з ПДВ)',
                'sub-total'                 => 'Підсумок',
                'tax'                       => 'Податок',
            ],
        ],

        'coupon' => [
            'already-applied' => 'Код купона вже застосований.',
            'applied'         => 'Застосований купон',
            'apply'           => 'Застосувати купон',
            'apply-issue'     => 'Код купона не може бути застосований.',
            'button-title'    => 'Застосувати',
            'code'            => 'Код купона',
            'discount'        => 'Знижка купона',
            'enter-your-code' => 'Введіть свій код',
            'error'           => 'Щось пішло не так',
            'invalid'         => 'Код купона недійсний.',
            'remove'          => 'Видалити купон',
            'subtotal'        => 'Підсумок',
            'success-apply'   => 'Код купона успішно застосовано.',
        ],

        'login' => [
            'email'    => 'Електронна пошта',
            'password' => 'Пароль',
            'title'    => 'Увійти',
        ],
    ],

    'home' => [
        'contact' => [
            'about'         => 'Напишіть нам, і ми якомога швидше відповімо вам',
            'desc'          => ' Що у вас на думці?',
            'describe-here' => 'Опишіть тут',
            'email'         => 'Електронна пошта',
            'message'       => 'Повідомлення',
            'name'          => 'Ім\'я',
            'phone-number'  => 'Номер телефону',
            'submit'        => 'Надіслати',
            'title'         => 'Зв\'яжіться з нами',
        ],

        'index' => [
            'offer'               => 'Отримайте ЗНИЖКУ до 40% на ваше 1-е замовлення. КУПУЙТЕ ЗАРАЗ',
            'resend-verify-email' => 'Надіслати лист для підтвердження електронної пошти знову',
            'verify-email'        => 'Підтвердіть свій обліковий запис електронної пошти',
        ],

        'thanks-for-contact' => 'Дякуємо, що зв\'язалися з нами зі своїми коментарями та питаннями. Ми відповімо вам найближчим часом.',
    ],

    'partials' => [
        'pagination' => [
            'pagination-showing' => 'Показано від :firstItem до :lastItem з :total записів',
        ],
    ],

    'errors' => [
        'go-to-home'   => 'На головну',

        '404' => [
            'description' => 'Упс! Сторінку, яку ви шукаєте, відпочиває. Здається, ми не можемо знайти те, що ви шукаєте.',
            'title'       => '404 Сторінка не знайдена',
        ],

        '401' => [
            'description' => 'Упс! Здається, вам не дозволено доступ до цієї сторінки. Виглядає, що вам не вистачає необхідних облікових даних.',
            'title'       => '401 Не авторизовано',
        ],

        '403' => [
            'description' => 'Упс! Ця сторінка закрита для вас. Здається, у вас немає необхідних дозволів для перегляду цього вмісту.',
            'title'       => '403 Заборонено',
        ],

        '500' => [
            'description' => 'Упс! Щось пішло не так. Здається, у нас виникли проблеми з завантаженням сторінки, яку ви шукаєте.',
            'title'       => '500 Внутрішня помилка сервера',
        ],

        '503' => [
            'description' => 'Упс! Здається, ми тимчасово припинили роботу для технічного обслуговування. Будь ласка, поверніться через деякий час.',
            'title'       => '503 Служба недоступна',
        ],
    ],

    'layouts' => [
        'address'               => 'Адреса',
        'downloadable-products' => 'Завантажувані товари',
        'my-account'            => 'Мій обліковий запис',
        'orders'                => 'Замовлення',
        'profile'               => 'Профіль',
        'reviews'               => 'Відгуки',
        'wishlist'              => 'Список бажань',
    ],

    'subscription' => [
        'already'             => 'Ви вже підписані на нашу розсилку.',
        'subscribe-success'   => 'Ви успішно підписалися на нашу розсилку.',
        'unsubscribe-success' => 'Ви успішно відписалися від нашої розсилки.',
    ],

    'emails' => [
        'dear'   => 'Шановний :customer_name',
        'thanks' => 'Якщо вам потрібна будь-яка допомога, будь ласка, зв\'яжіться з нами за адресою <a href=":link" style=":style">:email</a>.<br/>Дякуємо!',

        'customers' => [
            'registration' => [
                'credentials-description' => 'Ваш обліковий запис створено. Деталі вашого облікового запису наведені нижче:',
                'description'             => 'Ваш обліковий запис був успішно створений, і ви можете увійти, використовуючи свої облікові дані електронної пошти та пароль. Після входу ви зможете скористатися іншими послугами, такими як перегляд минулих замовлень, список бажань та редагування інформації в обліковому записі.',
                'greeting'                => 'Ласкаво просимо і дякуємо за реєстрацію!',
                'password'                => 'Пароль',
                'sign-in'                 => 'Увійти',
                'subject'                 => 'Нова реєстрація клієнта',
                'username-email'          => 'Ім\'я користувача/Електронна пошта',
            ],

            'forgot-password' => [
                'description'    => 'Ви отримали цей лист, оскільки ми отримали запит на скидання пароля для вашого облікового запису.',
                'greeting'       => 'Забули пароль!',
                'reset-password' => 'Скинути пароль',
                'subject'        => 'Лист із скиданням пароля',
            ],

            'update-password' => [
                'description' => 'Ви отримали цей лист, оскільки ви оновили свій пароль.',
                'greeting'    => 'Пароль оновлено!',
                'subject'     => 'Пароль оновлено',
            ],

            'verification' => [
                'description'  => 'Будь ласка, натисніть кнопку нижче, щоб підтвердити свою адресу електронної пошти.',
                'greeting'     => 'Ласкаво просимо!',
                'subject'      => 'Підтвердження адреси електронної пошти',
                'verify-email' => 'Підтвердити адресу електронної пошти',
            ],

            'commented' => [
                'description' => 'Примітка - :note',
                'subject'     => 'Додано новий коментар',
            ],

            'subscribed' => [
                'description' => 'Вітаємо і ласкаво просимо до нашої громади розсилки! Ми раді мати вас на борту і будемо тримати вас в курсі останніх новин, тенденцій і ексклюзивних пропозицій.',
                'greeting'    => 'Ласкаво просимо до нашої розсилки!',
                'subject'     => 'Ви! Підпишіться на нашу розсилку',
                'unsubscribe' => 'Відписатися',
            ],
        ],

        'contact-us' => [
            'contact-from'    => 'через форму зворотного зв\'язку на веб-сайті',
            'reply-to-mail'   => 'будь ласка, відповідайте на цей лист.',
            'reach-via-phone' => 'Також ви можете зв\'язатися з нами за телефоном',
            'inquiry-from'    => 'Запит від',
            'to'              => 'Щоб зв\'язатися з',
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Дякуємо за ваше замовлення #:order_id, оформлене :created_at',
                'subject'  => 'Підтвердження нового замовлення',
                'summary'  => 'Підсумок замовлення',
                'title'    => 'Підтвердження замовлення!',
            ],

            'invoiced' => [
                'greeting' => 'Ваш рахунок #:invoice_id за замовлення #:order_id створено :created_at',
                'subject'  => 'Підтвердження нового рахунку',
                'summary'  => 'Підсумок рахунку',
                'title'    => 'Створено новий рахунок!',
            ],

            'shipped' => [
                'greeting'     => 'Ваше замовлення #:order_id було відправлено :shipped_at',
                'subject'      => 'Підтвердження відправленого замовлення',
                'summary'      => 'Підсумок відправленого замовлення',
                'title'        => 'Замовлення відправлено!',
            ],

            'refunded' => [
                'greeting' => 'Возврат средств инициирован для заказа :order_id, размещенного :created_at',
                'subject'  => 'Подтверждение нового возврата средств',
                'summary'  => 'Итоги возврата средств',
                'title'    => 'Заказ возвращен!',
            ],

            'canceled' => [
                'greeting' => 'Ваше замовлення #:order_id відмінено :canceled_at',
                'subject'  => 'Підтвердження скасованого замовлення',
                'summary'  => 'Підсумок скасованого замовлення',
                'title'    => 'Замовлення скасовано!',
            ],

            'commented' => [
                'subject' => 'Добавлен новый комментарий',
                'title'   => 'Добавлен новый комментарий до вашого замовлення :order_id, разміщеного :created_at',
            ],

            'billing-address'            => 'Адреса оплати',
            'carrier'                    => 'Перевізник',
            'contact'                    => 'Контакт',
            'discount'                   => 'Знижка',
            'excl-tax'                   => 'Без ПДВ: ',
            'grand-total'                => 'Загальна сума',
            'name'                       => 'Ім\'я',
            'payment'                    => 'Оплата',
            'price'                      => 'Ціна',
            'qty'                        => 'Кількість',
            'shipping-address'           => 'Адреса доставки',
            'shipping-handling-excl-tax' => 'Доставка та обробка (без ПДВ)',
            'shipping-handling-incl-tax' => 'Доставка та обробка (з ПДВ)',
            'shipping-handling'          => 'Доставка та обробка',
            'shipping'                   => 'Доставка',
            'sku'                        => 'Артикул',
            'subtotal-excl-tax'          => 'Підсумок (без ПДВ)',
            'subtotal-incl-tax'          => 'Підсумок (з ПДВ)',
            'subtotal'                   => 'Підсумок',
            'tax'                        => 'ПДВ',
            'tracking-number'            => 'Номер відстеження: :tracking_number',
        ],
    ],
];
