{!! view_render_event('bagisto.shop.layout.footer.before') !!}

<!--
    The category repository is injected directly here because there is no way
    to retrieve it from the view composer, as this is an anonymous component.
-->
@inject('themeCustomizationRepository', 'Webkul\Theme\Repositories\ThemeCustomizationRepository')

<!--
    This code needs to be refactored to reduce the amount of PHP in the Blade
    template as much as possible.
-->
@php
    $customization = $themeCustomizationRepository->findOneWhere([
        'type'       => 'footer_links',
        'status'     => 1,
        'channel_id' => core()->getCurrentChannel()->id,
    ]);

    $kj=1;
@endphp


<footer>
      <div class="container">
        <div class="footer-content">
          <div class="footer-logo col-span-5">
            <img src="<?=url('/'); ?>/themes/shop/cheval/images/footer_logo.svg" alt="Auto Vault Logo" />

            <div class="footer-column">
              <div><h3>Email</h3>
              <p><a href="mailto:hello@avpartz.com">hello@avpartz.com</a></p>              
              <h3 class="mg-top">Phone</h3>
              <p><a href="tel:+971524570007">+971 52 457 0007</a></p>
              <h3 class="mg-top">Follow us</h3>
              <div class="social-links">
                <a href="#" aria-label="Facebook"
                  ><img src="<?=url('/'); ?>/themes/shop/cheval/images/facebook.svg" alt="Auto Vault Facebook" /></a>
                <a href="#" aria-label="Instagram"
                  ><img src="<?=url('/'); ?>/themes/shop/cheval/images/instagram.svg" alt="Auto Vault Instagram" /></a>
                <a href="#" aria-label="linkedin"
                  ><img src="<?=url('/'); ?>/themes/shop/cheval/images/linkedin.svg" alt="Auto Vault linkedin" /></a>
              </div>
</div><div>
              <h3>Address</h3>
              <p>
               Dubai investment park first<br> Property investment office 4<br>Office F1-354 - UAE
              </p></div>
            </div>
          </div>
          <div class="footer-links col-span-7">
            

            @if ($customization?->options) 
                @foreach ($customization->options as $footerLinkSection)
                <div class="footer-column footer_a_<?=$kj; ?>">
              <h3><?=(($kj==1) ? 'Account' : (($kj==2) ? 'Category' : 'Category')); ?></h3>
              <ul class="grid gap-5 text-sm">
                        @php
                            usort($footerLinkSection, function ($a, $b) {
                                return $a['sort_order'] - $b['sort_order'];
                            });
                            $kj++;
                        @endphp

                        @foreach ($footerLinkSection as $link)
                            <li>
                                <a href="{{ $link['url'] }}">
                                    {{ $link['title'] }}
                                </a>
                            </li>
                        @endforeach
                    </ul></div>
                @endforeach
            @endif

            
          </div>
        </div>
        <div class="footer-bottom">
          <p>&copy; <?=date('Y'); ?> Auto Vault . All Rights Reserved</p>
          <p>Designed & Developed By <a href="https://chevalme.com/" target="_blank">Cheval</a></p>
        </div>
      </div>
    </footer>


{!! view_render_event('bagisto.shop.layout.footer.after') !!}
