@props(['options'])

<v-carouselourbrand :count="8" :images="{{ json_encode($options['images'] ?? []) }}">
    <div class="overflow-hidden">
        <div class="shimmer aspect-[2.743/1] max-h-screen w-screen"></div>
    </div>
</v-carouselourbrand>

@pushOnce('scripts')
    <script
        type="text/x-template"
        id="v-carouselourbrand-template"
    >


    <section class="popular-brands">
   <div
            class="container mt-14 max-lg:px-8 max-md:mt-7 max-md:!px-0 max-sm:mt-5 "
            
        ><h2>Our Trusted Brands</h2>
            <div class="relative">
                <div
                    ref="sliderContainer"
                    class="scrollbar-hide flex gap-6 overflow-auto scroll-smooth max-lg:gap-4"
                >
                    <div
                    class="our_brands_list justify-items-center"
                    v-for="(image, index) in images"
                    @click="visitLink(image)"
                    ref="slide"
                >
                    <x-shop::media.images.lazy
                        class=""
                        ::lazy="false"
                        ::src="image.image"
                        ::srcset="image.image + ' 1920w, ' + image.image.replace('storage', 'cache/large') + ' 1280w,' + image.image.replace('storage', 'cache/medium') + ' 1024w, ' + image.image.replace('storage', 'cache/small') + ' 525w'"
                        ::alt="image?.title"
                        tabindex="0"
                        fetchpriority="high"
                    />
                </div>
                </div>

                <span
                    class="icon-arrow-left-stylish icon_carosel hide absolute -left-10 top-9 flex h-[50px] w-[50px] cursor-pointer items-center justify-center rounded-full border border-black bg-white text-2xl -transition hover:bg-black hover:text-white max-lg:-left-7 max-md:hidden"
                    role="button"
                    aria-label="@lang('shop::components.carousel.previous')"
                    tabindex="0"
                    @click="swipeLeft"
                >
                </span>

                <span
                    class="icon-arrow-right-stylish icon_carosel hide absolute -right-6 top-9 flex h-[50px] w-[50px] cursor-pointer items-center justify-center rounded-full border border-black bg-white text-2xl -transition hover:bg-black hover:text-white max-lg:-right-7 max-md:hidden"
                    role="button"
                    aria-label="@lang('shop::components.carousel.next')"
                    tabindex="0"
                    @click="swipeRight"
                >
                </span>
            </div>
        </div></section>


        
    </script>

    <script type="module">
        app.component("v-carouselourbrand", {
            template: '#v-carouselourbrand-template',

            props: ['images'],

            data() {
                return {
                    isLoading: true,

                    categories: [],

                    offset: 323,
                };
            },

            mounted() {
                this.getCategories();
            },

            methods: {
                getCategories() {
                    this.$axios.get(this.src)
                        .then(response => {
                            this.isLoading = false;

                            this.categories = response.data.data;
                            console.log(response.data.data);
                        }).catch(error => {
                            console.log(error);
                        });
                },

                swipeLeft() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft -= this.offset;
                },

                swipeRight() {
                    const container = this.$refs.swiperContainer;

                    container.scrollLeft += this.offset;
                },
            },
        });
    </script>

   
@endpushOnce