<?php

return [
    'customers' => [
        'forgot-password' => [
            'already-sent'         => 'Wachtwoord al opnieuw ingesteld E-mail verzonden.',
            'back'                 => 'Terug naar Aanmelden?',
            'bagisto'              => 'Bagisto',
            'email'                => 'E-mail',
            'email-not-exist'      => 'We kunnen geen gebruiker vinden met dat e-mailadres.',
            'footer'               => '© Auteursrecht 2010 - :current_year, Webkul Software (geregistreerd in India). Alle rechten voorbehouden.',
            'forgot-password-text' => 'Als u uw wachtwoord bent vergeten, kunt u het herstellen door uw e-mailadres in te voeren.',
            'page-title'           => 'Bent u uw wachtwoord vergeten?',
            'reset-link-sent'      => 'We hebben de resetlink voor uw wachtwoord per e-mail verzonden.',
            'sign-in-button'       => 'Aanmelden',
            'submit'               => 'Wachtwoord Herstellen',
            'title'                => 'Wachtwoord Herstellen',
        ],

        'reset-password' => [
            'back-link-title'  => 'Terug naar Aanmelden',
            'bagisto'          => 'Bagisto',
            'confirm-password' => 'Bevestig Wachtwoord',
            'email'            => 'Geregistreerde E-mail',
            'footer'           => '© Auteursrecht 2010 - :current_year, Webkul Software (geregistreerd in India). Alle rechten voorbehouden.',
            'password'         => 'Wachtwoord',
            'submit-btn-title' => 'Wachtwoord Resetten',
            'title'            => 'Wachtwoord Resetten',
        ],

        'login-form' => [
            'bagisto'             => 'Bagisto',
            'button-title'        => 'Aanmelden',
            'create-your-account' => 'Maak uw account aan',
            'email'               => 'E-mail',
            'footer'              => '© Auteursrecht 2010 - :current_year, Webkul Software (geregistreerd in India). Alle rechten voorbehouden.',
            'forgot-pass'         => 'Wachtwoord Vergeten?',
            'form-login-text'     => 'Als u een account heeft, meld u dan aan met uw e-mailadres.',
            'invalid-credentials' => 'Controleer uw referenties en probeer het opnieuw.',
            'new-customer'        => 'Nieuwe klant?',
            'not-activated'       => 'Uw activering wacht op goedkeuring van de beheerder',
            'page-title'          => 'Klant Aanmelden',
            'password'            => 'Wachtwoord',
            'show-password'       => 'Wachtwoord Weergeven',
            'title'               => 'Aanmelden',
            'verify-first'        => 'Verifieer eerst uw e-mailaccount.',
        ],

        'signup-form' => [
            'account-exists'              => 'Heeft u al een account?',
            'bagisto'                     => 'Bagisto',
            'button-title'                => 'Registreren',
            'confirm-pass'                => 'Bevestig Wachtwoord',
            'email'                       => 'E-mail',
            'first-name'                  => 'Voornaam',
            'footer'                      => '© Auteursrecht 2010 - :current_year, Webkul Software (geregistreerd in India). Alle rechten voorbehouden.',
            'form-signup-text'            => 'Als u nieuw bent in onze winkel, zijn we blij u als lid te hebben.',
            'last-name'                   => 'Achternaam',
            'page-title'                  => 'Word Gebruiker',
            'password'                    => 'Wachtwoord',
            'sign-in-button'              => 'Aanmelden',
            'subscribe-to-newsletter'     => 'Abonneer op nieuwsbrief',
            'success'                     => 'Account succesvol aangemaakt.',
            'success-verify'              => 'Account succesvol aangemaakt, er is een e-mail verzonden ter verificatie.',
            'success-verify-email-unsent' => 'Account succesvol aangemaakt, maar verificatie-e-mail niet verzonden.',
            'verification-not-sent'       => 'Fout! Probleem bij het verzenden van de verificatie-e-mail, probeer het later opnieuw.',
            'verification-sent'           => 'Verificatie e-mail verzonden',
            'verified'                    => 'Uw account is geverifieerd, probeer nu in te loggen.',
            'verify-failed'               => 'We kunnen uw e-mailaccount niet verifiëren.',
        ],

        'account' => [
            'home' => 'Home',

            'profile' => [
                'index' => [
                    'delete'         => 'Verwijderen',
                    'delete-failed'  => 'Fout opgetreden bij het verwijderen van de klant.',
                    'delete-profile' => 'Profiel Verwijderen',
                    'delete-success' => 'Klant succesvol verwijderd',
                    'dob'            => 'Geboortedatum',
                    'edit'           => 'Bewerken',
                    'edit-success'   => 'Profiel succesvol bijgewerkt',
                    'email'          => 'E-mail',
                    'enter-password' => 'Voer uw wachtwoord in',
                    'first-name'     => 'Voornaam',
                    'gender'         => 'Geslacht',
                    'last-name'      => 'Achternaam',
                    'order-pending'  => 'Kan klantaccount niet verwijderen omdat er nog bestelling(en) in afwachting zijn of in verwerking zijn.',
                    'title'          => 'Profiel',
                    'unmatched'      => 'Het oude wachtwoord komt niet overeen.',
                    'wrong-password' => 'Verkeerd wachtwoord!',
                ],

                'edit' => [
                    'confirm-password'        => 'Bevestig Wachtwoord',
                    'current-password'        => 'Huidig Wachtwoord',
                    'dob'                     => 'Geboortedatum',
                    'edit'                    => 'Bewerken',
                    'edit-profile'            => 'Profiel Bewerken',
                    'email'                   => 'E-mail',
                    'female'                  => 'Vrouw',
                    'first-name'              => 'Voornaam',
                    'gender'                  => 'Geslacht',
                    'last-name'               => 'Achternaam',
                    'male'                    => 'Man',
                    'new-password'            => 'Nieuw Wachtwoord',
                    'other'                   => 'Anders',
                    'phone'                   => 'Telefoon',
                    'save'                    => 'Opslaan',
                    'subscribe-to-newsletter' => 'Abonneren op nieuwsbrief',
                ],
            ],

            'addresses' => [
                'index' => [
                    'add-address'      => 'Adres Toevoegen',
                    'create-success'   => 'Adres succesvol toegevoegd.',
                    'default-address'  => 'Standaard Adres',
                    'default-delete'   => 'Standaard adres kan niet worden gewijzigd.',
                    'delete'           => 'Verwijderen',
                    'delete-success'   => 'Adres succesvol verwijderd',
                    'edit'             => 'Bewerken',
                    'edit-success'     => 'Adres succesvol bijgewerkt.',
                    'empty-address'    => 'U heeft nog geen adres aan uw account toegevoegd.',
                    'security-warning' => 'Verdachte activiteit gevonden!!!',
                    'set-as-default'   => 'Instellen als Standaard',
                    'title'            => 'Adres',
                    'update-success'   => 'Adres succesvol bijgewerkt.',
                ],

                'create' => [
                    'add-address'    => 'Adres Toevoegen',
                    'city'           => 'Stad',
                    'company-name'   => 'Bedrijfsnaam',
                    'country'        => 'Land',
                    'email'          => 'E-mail',
                    'first-name'     => 'Voornaam',
                    'last-name'      => 'Achternaam',
                    'phone'          => 'Telefoon',
                    'post-code'      => 'Postcode',
                    'save'           => 'Opslaan',
                    'select-country' => 'Selecteer Land',
                    'set-as-default' => 'Instellen als Standaard',
                    'state'          => 'Provincie',
                    'street-address' => 'Straatnaam en Huisnummer',
                    'title'          => 'Adres',
                    'vat-id'         => 'BTW-nummer',
                ],

                'edit' => [
                    'city'           => 'Stad',
                    'company-name'   => 'Bedrijfsnaam',
                    'country'        => 'Land',
                    'edit'           => 'Bewerken',
                    'email'          => 'E-mail',
                    'first-name'     => 'Voornaam',
                    'last-name'      => 'Achternaam',
                    'phone'          => 'Telefoon',
                    'post-code'      => 'Postcode',
                    'select-country' => 'Selecteer Land',
                    'state'          => 'Provincie',
                    'street-address' => 'Straatnaam en Huisnummer',
                    'title'          => 'Adres',
                    'update-btn'     => 'Bijwerken',
                    'vat-id'         => 'BTW-nummer',
                ],
            ],

            'orders' => [
                'action'      => 'Actie',
                'action-view' => 'Bekijken',
                'empty-order' => 'U heeft nog geen product besteld',
                'order'       => 'Bestelling',
                'order-date'  => 'Besteldatum',
                'order-id'    => 'Bestel-ID',
                'subtotal'    => 'Subtotaal',
                'title'       => 'Bestellingen',
                'total'       => 'Totaal',

                'status' => [
                    'title' => 'Status',

                    'options' => [
                        'canceled'        => 'Geannuleerd',
                        'closed'          => 'Gesloten',
                        'completed'       => 'Voltooid',
                        'fraud'           => 'Fraude',
                        'pending'         => 'In Afwachting',
                        'pending-payment' => 'In Afwachting van Betaling',
                        'processing'      => 'Verwerking',
                    ],
                ],

                'view' => [
                    'billing-address'      => 'Factuuradres',
                    'cancel-btn-title'     => 'Annuleren',
                    'cancel-confirm-msg'   => 'Weet u zeker dat u deze bestelling wilt annuleren?',
                    'cancel-error'         => 'Uw bestelling kan niet geannuleerd worden.',
                    'cancel-success'       => 'Uw bestelling is geannuleerd',
                    'contact'              => 'Contact',
                    'item-invoiced'        => 'Item gefactureerd',
                    'item-refunded'        => 'Item terugbetaald',
                    'item-shipped'         => 'Item verzonden',
                    'item-ordered'         => 'Item besteld',
                    'order-id'             => 'Bestelnummer',
                    'page-title'           => 'Bestelling #:order_id',
                    'payment-method'       => 'Betaalmethode',
                    'reorder-btn-title'    => 'Opnieuw bestellen',
                    'shipping-address'     => 'Verzendadres',
                    'shipping-method'      => 'Verzendmethode',
                    'shipping-and-payment' => 'Verzend- en betaalgegevens',
                    'status'               => 'Status',
                    'title'                => 'Bekijken',
                    'total'                => 'Totaal',

                    'information' => [
                        'discount'                   => 'Korting',
                        'excl-tax'                   => 'Excl. BTW:',
                        'grand-total'                => 'Totaalbedrag',
                        'info'                       => 'Informatie',
                        'item-canceled'              => 'Geannuleerd (:qty_canceled)',
                        'item-refunded'              => 'Terugbetaald (:qty_refunded)',
                        'invoiced-item'              => 'Gefactureerd (:qty_invoiced)',
                        'item-shipped'               => 'verzonden (:qty_shipped)',
                        'item-status'                => 'Itemstatus',
                        'ordered-item'               => 'Besteld (:qty_ordered)',
                        'placed-on'                  => 'Geplaatst op',
                        'price'                      => 'Prijs',
                        'product-name'               => 'Naam',
                        'shipping-handling'          => 'Verzend- en afhandelingskosten',
                        'shipping-handling-excl-tax' => 'Verzend- en afhandelingskosten (Excl. BTW)',
                        'shipping-handling-incl-tax' => 'Verzend- en afhandelingskosten (Incl. BTW)',
                        'sku'                        => 'Artikelnummer',
                        'subtotal'                   => 'Subtotaal',
                        'subtotal-excl-tax'          => 'Subtotaal (Excl. BTW)',
                        'subtotal-incl-tax'          => 'Subtotaal (Incl. BTW)',
                        'order-summary'              => 'Besteloverzicht',
                        'tax'                        => 'BTW',
                        'tax-amount'                 => 'BTW-bedrag',
                        'tax-percent'                => 'BTW-percentage',
                        'total-due'                  => 'Totaal verschuldigd',
                        'total-paid'                 => 'Totaal betaald',
                        'total-refunded'             => 'Totaal terugbetaald',
                    ],

                    'invoices' => [
                        'discount'                   => 'Korting',
                        'excl-tax'                   => 'Excl. BTW:',
                        'grand-total'                => 'Totaalbedrag',
                        'individual-invoice'         => 'Factuur #:invoice_id',
                        'invoices'                   => 'Facturen',
                        'price'                      => 'Prijs',
                        'print'                      => 'Afdrukken',
                        'product-name'               => 'Naam',
                        'products-ordered'           => 'Bestelde producten',
                        'qty'                        => 'Aantal',
                        'shipping-handling-excl-tax' => 'Verzend- en afhandelingskosten (Excl. BTW)',
                        'shipping-handling-incl-tax' => 'Verzend- en afhandelingskosten (Incl. BTW)',
                        'shipping-handling'          => 'Verzend- en afhandelingskosten',
                        'sku'                        => 'Artikelnummer',
                        'subtotal-excl-tax'          => 'Subtotaal (Excl. BTW)',
                        'subtotal-incl-tax'          => 'Subtotaal (Incl. BTW)',
                        'subtotal'                   => 'Subtotaal',
                        'tax'                        => 'BTW',
                        'tax-amount'                 => 'BTW-bedrag',
                    ],

                    'shipments' => [
                        'individual-shipment' => 'Verzending #:shipment_id',
                        'product-name'        => 'Naam',
                        'qty'                 => 'Aantal',
                        'shipments'           => 'Verzendingen',
                        'sku'                 => 'Artikelnummer',
                        'subtotal'            => 'Subtotaal',
                        'tracking-number'     => 'Track & Trace-nummer',
                    ],

                    'refunds' => [
                        'adjustment-fee'             => 'Aanpassingskosten',
                        'adjustment-refund'          => 'Aanpassingsrefund',
                        'discount'                   => 'Korting',
                        'grand-total'                => 'Totaalbedrag',
                        'individual-refund'          => 'Terugbetaling #:refund_id',
                        'no-result-found'            => 'Geen resultaten gevonden.',
                        'order-summary'              => 'Besteloverzicht',
                        'price'                      => 'Prijs',
                        'product-name'               => 'Naam',
                        'qty'                        => 'Aantal',
                        'refunds'                    => 'Terugbetalingen',
                        'shipping-handling'          => 'Verzend- en afhandelingskosten',
                        'shipping-handling-excl-tax' => 'Verzend- en afhandelingskosten (Excl. BTW)',
                        'shipping-handling-incl-tax' => 'Verzend- en afhandelingskosten (Incl. BTW)',
                        'sku'                        => 'Artikelnummer',
                        'subtotal'                   => 'Subtotaal',
                        'subtotal-excl-tax'          => 'Subtotaal (Excl. BTW)',
                        'subtotal-incl-tax'          => 'Subtotaal (Incl. BTW)',
                        'tax'                        => 'BTW',
                        'tax-amount'                 => 'BTW-bedrag',
                    ],
                ],

                'invoice-pdf' => [
                    'bank-details'               => 'Bankgegevens',
                    'bill-to'                    => 'Factuuradres',
                    'contact-number'             => 'Contactnummer',
                    'contact'                    => 'Contact',
                    'date'                       => 'Factuurdatum',
                    'discount'                   => 'Korting',
                    'excl-tax'                   => 'Excl. BTW:',
                    'grand-total'                => 'Totaalbedrag',
                    'invoice-id'                 => 'Factuurnummer',
                    'invoice'                    => 'Factuur',
                    'order-date'                 => 'Besteldatum',
                    'order-id'                   => 'Bestelnummer',
                    'payment-method'             => 'Betaalmethode',
                    'payment-terms'              => 'Betalingsvoorwaarden',
                    'price'                      => 'Prijs',
                    'product-name'               => 'Productnaam',
                    'qty'                        => 'Hoeveelheid',
                    'ship-to'                    => 'Verzenden naar',
                    'shipping-handling-excl-tax' => 'Verzendkosten en behandeling (excl. BTW)',
                    'shipping-handling-incl-tax' => 'Verzendkosten en behandeling (incl. BTW)',
                    'shipping-handling'          => 'Verzendkosten en behandeling',
                    'shipping-method'            => 'Verzendmethode',
                    'sku'                        => 'Artikelnummer',
                    'subtotal-excl-tax'          => 'Subtotaal (excl. BTW)',
                    'subtotal-incl-tax'          => 'Subtotaal (incl. BTW)',
                    'subtotal'                   => 'Subtotaal',
                    'tax-amount'                 => 'Belastingbedrag',
                    'tax'                        => 'Belasting',
                    'vat-number'                 => 'BTW-nummer',
                ],
            ],

            'reviews' => [
                'empty-review' => 'U heeft nog geen product beoordeeld',
                'title'        => 'Beoordelingen',
            ],

            'downloadable-products' => [
                'available'           => 'Beschikbaar',
                'completed'           => 'Voltooid',
                'date'                => 'Datum',
                'download-error'      => 'Downloadlink is verlopen.',
                'expired'             => 'Verlopen',
                'empty-product'       => 'U heeft geen product om te downloaden',
                'name'                => 'Downloadbare Producten',
                'orderId'             => 'Bestelnummer',
                'pending'             => 'In behandeling',
                'payment-error'       => 'Betaling is niet gedaan voor deze download.',
                'records-found'       => 'Record(s) gevonden',
                'remaining-downloads' => 'Resterende Downloads',
                'status'              => 'Status',
                'title'               => 'Titel',
            ],

            'wishlist' => [
                'color'              => 'Kleur',
                'delete-all'         => 'Alles Verwijderen',
                'empty'              => 'Er zijn geen producten toegevoegd aan de verlanglijst.',
                'move-to-cart'       => 'Verplaats Naar Winkelwagen',
                'moved'              => 'Item succesvol naar de winkelwagen verplaatst',
                'moved-success'      => 'Item Succesvol Verplaatst naar Winkelwagen',
                'page-title'         => 'Verlanglijst',
                'product-removed'    => 'Product is niet meer beschikbaar en is verwijderd door de beheerder',
                'profile'            => 'Profiel',
                'remove'             => 'Verwijderen',
                'remove-all-success' => 'Alle items uit uw verlanglijst zijn verwijderd',
                'remove-fail'        => 'Item kan niet uit de verlanglijst worden verwijderd',
                'removed'            => 'Item succesvol verwijderd uit verlanglijst',
                'see-details'        => 'Details Bekijken',
                'success'            => 'Item succesvol toegevoegd aan verlanglijst',
                'title'              => 'Verlanglijst',
            ],
        ],
    ],

    'components' => [
        'accordion' => [
            'default-content' => 'Standaard inhoud',
            'default-header'  => 'Standaard kop',
        ],

        'drawer' => [
            'default-toggle'  => 'Standaard Schakelen',
        ],

        'media' => [
            'index' => [
                'add-attachments' => 'Bijlagen toevoegen',
                'add-image'       => 'Afbeelding toevoegen',
            ],
        ],

        'layouts' => [
            'header' => [
                'account'           => 'Account',
                'bagisto'           => 'Bagisto',
                'cart'              => 'Winkelwagen',
                'compare'           => 'Vergelijken',
                'dropdown-text'     => 'Beheer Winkelwagen, Bestellingen en Verlanglijst',
                'logout'            => 'Uitloggen',
                'no-category-found' => 'Geen categorie gevonden.',
                'orders'            => 'Bestellingen',
                'profile'           => 'Profiel',
                'search'            => 'Zoeken',
                'search-text'       => 'Zoek hier producten',
                'sign-in'           => 'Inloggen',
                'sign-up'           => 'Aanmelden',
                'submit'            => 'Verzenden',
                'title'             => 'Account',
                'welcome'           => 'Welkom',
                'welcome-guest'     => 'Welkom Gast',
                'wishlist'          => 'Verlanglijst',

                'desktop' => [
                    'top' => [
                        'default-locale' => 'Standaardtaal',
                    ],
                ],

                'mobile' => [
                    'currencies' => 'Valuta',
                    'locales'    => 'Taal',
                    'login'      => 'Registreren of Inloggen',
                ],
            ],

            'footer' => [
                'about-us'               => 'Over ons',
                'contact-us'             => 'Neem contact met ons op',
                'currency'               => 'Valuta',
                'customer-service'       => 'Klantenservice',
                'email'                  => 'E-mail',
                'footer-content'         => 'Voettekst inhoud',
                'footer-text'            => '© Auteursrecht 2010 - :current_year, Webkul Software (geregistreerd in India). Alle rechten voorbehouden.',
                'locale'                 => 'Taal',
                'newsletter-text'        => 'Maak je klaar voor onze leuke nieuwsbrief!',
                'order-return'           => 'Bestelling en Retourneren',
                'payment-policy'         => 'Betalingsbeleid',
                'privacy-cookies-policy' => 'Privacy- en cookiebeleid',
                'shipping-policy'        => 'Verzendbeleid',
                'subscribe'              => 'Abonneren',
                'subscribe-newsletter'   => 'Abonneer op de nieuwsbrief',
                'subscribe-stay-touch'   => 'Abonneer om in contact te blijven.',
                'whats-new'              => 'Wat is nieuw',
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => ':length van',
                'results'   => ':total Resultaten',
                'selected'  => ':total Geselecteerd',

                'mass-actions' => [
                    'must-select-a-mass-action'        => 'U moet een massa-actie selecteren.',
                    'must-select-a-mass-action-option' => 'U moet een optie voor massa-actie selecteren.',
                    'no-records-selected'              => 'Er zijn geen records geselecteerd.',
                    'select-action'                    => 'Selecteer Actie',
                ],

                'search' => [
                    'title' => 'Zoeken',
                ],

                'filter' => [
                    'apply-filter' => 'Filters Toepassen',
                    'title'        => 'Filteren',

                    'dropdown' => [
                        'select' => 'Selecteren',

                        'searchable' => [
                            'at-least-two-chars' => 'Typ minimaal 2 tekens...',
                            'no-results'         => 'Geen resultaat gevonden...',
                        ],
                    ],

                    'custom-filters' => [
                        'clear-all' => 'Alles wissen',
                    ],
                ],
            ],

            'table' => [
                'actions'              => 'Acties',
                'next-page'            => 'Volgende Pagina',
                'no-records-available' => 'Geen Records Beschikbaar.',
                'of'                   => 'van :total items',
                'page-navigation'      => 'Pagina Navigatie',
                'page-number'          => 'Paginanummer',
                'previous-page'        => 'Vorige Pagina',
                'showing'              => 'Weergeven :firstItem',
                'to'                   => 'tot :lastItem',
            ],
        ],

        'modal' => [
            'default-content' => 'Standaard inhoud',
            'default-header'  => 'Standaard kop',

            'confirm' => [
                'agree-btn'    => 'Akkoord',
                'disagree-btn' => 'Niet akkoord',
                'message'      => 'Weet je zeker dat je deze actie wilt uitvoeren?',
                'title'        => 'Weet je het zeker?',
            ],
        ],

        'products' => [
            'card' => [
                'add-to-cart'            => 'Toevoegen aan winkelwagen',
                'add-to-compare'         => 'Toevoegen aan vergelijkingslijst',
                'add-to-compare-success' => 'Item succesvol toegevoegd aan vergelijkingslijst.',
                'add-to-wishlist'        => 'Toevoegen aan verlanglijstje',
                'already-in-compare'     => 'Item is al toegevoegd aan vergelijkingslijst.',
                'new'                    => 'Nieuw',
                'review-description'     => 'Wees de eerste om dit product te beoordelen',
                'sale'                   => 'Uitverkoop',
            ],

            'carousel' => [
                'next'     => 'Volgende',
                'previous' => 'Vorige',
                'view-all' => 'Alles bekijken',
            ],

            'ratings' => [
                'title' => 'Beoordelingen',
            ],
        ],

        'range-slider' => [
            'max-range' => 'Maximale Bereik',
            'min-range' => 'Minimale Bereik',
            'range'     => 'Bereik:',
        ],

        'carousel' => [
            'image-slide' => 'Afbeeldingslide',
            'next'        => 'Volgende',
            'previous'    => 'Vorige',
        ],

        'quantity-changer' => [
            'decrease-quantity' => 'Hoeveelheid verminderen',
            'increase-quantity' => 'Hoeveelheid verhogen',
        ],
    ],

    'products' => [
        'prices' => [
            'grouped' => [
                'starting-at' => 'Vanaf',
            ],

            'configurable' => [
                'as-low-as' => 'Vanaf',
            ],
        ],

        'sort-by' => [
            'title'   => 'Sorteer op',
        ],

        'view' => [
            'type' => [
                'configurable' => [
                    'select-options'       => 'Selecteer alsjeblieft een optie',
                    'select-above-options' => 'Selecteer hierboven de opties',
                ],

                'bundle' => [
                    'none'         => 'Geen',
                    'total-amount' => 'Totaalbedrag',
                ],

                'downloadable' => [
                    'links'   => 'Links',
                    'sample'  => 'Voorbeeld',
                    'samples' => 'Voorbeelden',
                ],

                'grouped' => [
                    'name' => 'Naam',
                ],
            ],

            'gallery' => [
                'product-image'   => 'Productafbeelding',
                'thumbnail-image' => 'Miniatuurafbeelding',
            ],

            'reviews' => [
                'attachments'      => 'Bijlagen',
                'cancel'           => 'Annuleren',
                'comment'          => 'Opmerking',
                'customer-review'  => 'Klantbeoordelingen',
                'empty-review'     => 'Geen beoordeling gevonden, wees de eerste om dit product te beoordelen',
                'failed-to-upload' => 'Het uploaden van de afbeelding is mislukt',
                'load-more'        => 'Meer laden',
                'name'             => 'Naam',
                'rating'           => 'Beoordeling',
                'ratings'          => 'Waarderingen',
                'submit-review'    => 'Beoordeling indienen',
                'success'          => 'Beoordeling succesvol ingediend.',
                'title'            => 'Titel',
                'translate'        => 'Vertalen',
                'translating'      => 'Vertalen...',
                'write-a-review'   => 'Schrijf een beoordeling',
            ],

            'add-to-cart'            => 'Toevoegen aan winkelwagen',
            'add-to-compare'         => 'Product toegevoegd aan vergelijking.',
            'add-to-wishlist'        => 'Toevoegen aan verlanglijstje',
            'additional-information' => 'Aanvullende informatie',
            'already-in-compare'     => 'Product staat al in de vergelijking.',
            'buy-now'                => 'Nu kopen',
            'compare'                => 'Vergelijken',
            'description'            => 'Beschrijving',
            'related-product-title'  => 'Gerelateerde producten',
            'review'                 => 'Beoordelingen',
            'tax-inclusive'          => 'Inclusief alle belastingen',
            'up-sell-title'          => 'We hebben andere producten gevonden die je misschien leuk vindt!',
        ],

        'type' => [
            'abstract' => [
                'offers' => 'Koop :qty voor :price per stuk en bespaar :discount',
            ],
        ],
    ],

    'categories' => [
        'filters' => [
            'clear-all' => 'Alles wissen',
            'filter'    => 'Filter',
            'filters'   => 'Filters:',
            'sort'      => 'Sorteer',
        ],

        'toolbar' => [
            'grid' => 'Raster',
            'list' => 'Lijst',
            'show' => 'Tonen',
        ],

        'view' => [
            'empty'     => 'Geen producten beschikbaar in deze categorie',
            'load-more' => 'Meer laden',
        ],
    ],

    'search' => [
        'title'   => 'Zoekresultaten voor : :query',
        'results' => 'Zoekresultaten',

        'images' => [
            'index' => [
                'only-images-allowed'  => 'Alleen afbeeldingen (.jpeg, .jpg, .png, ..) zijn toegestaan.',
                'search'               => 'Zoeken',
                'size-limit-error'     => 'Grootte Limiet Fout',
                'something-went-wrong' => 'Er is iets misgegaan, probeer het later opnieuw.',
            ],

            'results' => [
                'analyzed-keywords' => 'Geanalyseerde Trefwoorden:',
            ],
        ],
    ],

    'compare' => [
        'already-added'      => 'Item is al toegevoegd aan de vergelijkingslijst',
        'delete-all'         => 'Alles Verwijderen',
        'empty-text'         => 'Je hebt geen items in je vergelijkingslijst',
        'item-add-success'   => 'Item succesvol toegevoegd aan de vergelijkingslijst',
        'product-compare'    => 'Producten Vergelijken',
        'remove-all-success' => 'Alle items succesvol verwijderd.',
        'remove-error'       => 'Er is iets misgegaan, probeer het later opnieuw.',
        'remove-success'     => 'Item succesvol verwijderd.',
        'title'              => 'Product Vergelijking',
    ],

    'checkout' => [
        'success' => [
            'info'          => 'We sturen u een e-mail met uw bestelgegevens en trackinginformatie',
            'order-id-info' => 'Uw bestelnummer is #:order_id',
            'thanks'        => 'Bedankt voor uw bestelling!',
            'title'         => 'Bestelling succesvol geplaatst',
        ],

        'cart' => [
            'continue-to-checkout'      => 'Ga verder naar afrekenen',
            'illegal'                   => 'De hoeveelheid kan niet minder zijn dan één.',
            'inactive-add'              => 'Inactief item kan niet aan winkelwagen worden toegevoegd.',
            'inactive'                  => 'Het item is gedeactiveerd en vervolgens uit de winkelwagen verwijderd.',
            'inventory-warning'         => 'De aangevraagde hoeveelheid is niet beschikbaar, probeer het later opnieuw.',
            'item-add-to-cart'          => 'Item succesvol toegevoegd',
            'minimum-order-message'     => 'Het minimum bestelbedrag is',
            'missing-fields'            => 'Sommige vereiste velden ontbreken voor dit product.',
            'missing-options'           => 'Opties ontbreken voor dit product.',
            'paypal-payment-cancelled'  => 'PayPal-betaling is geannuleerd.',
            'qty-missing'               => 'Minstens één product moet meer dan 1 hoeveelheid hebben.',
            'return-to-shop'            => 'Terug naar de winkel',
            'rule-applied'              => 'Winkelwagenregel toegepast',
            'select-hourly-duration'    => 'Selecteer een slotduur van één uur.',
            'success-remove'            => 'Item is succesvol verwijderd uit de winkelwagen.',
            'suspended-account-message' => 'Uw account is opgeschort.',

            'index' => [
                'bagisto'                  => 'Bagisto',
                'cart'                     => 'Winkelwagen',
                'continue-shopping'        => 'Doorgaan met winkelen',
                'empty-product'            => 'U heeft geen product in uw winkelwagen.',
                'excl-tax'                 => 'Excl. BTW:',
                'home'                     => 'Home',
                'items-selected'           => ':count items geselecteerd',
                'move-to-wishlist'         => 'Verplaats naar verlanglijst',
                'move-to-wishlist-success' => 'Geselecteerde items succesvol verplaatst naar de verlanglijst.',
                'price'                    => 'Prijs',
                'product-name'             => 'Productnaam',
                'quantity'                 => 'Hoeveelheid',
                'quantity-update'          => 'Hoeveelheid succesvol bijgewerkt',
                'remove'                   => 'Verwijderen',
                'remove-selected-success'  => 'Geselecteerde items succesvol uit de winkelwagen verwijderd.',
                'see-details'              => 'Details bekijken',
                'select-all'               => 'Alles selecteren',
                'select-cart-item'         => 'Selecteer winkelwagenitem',
                'tax'                      => 'Belasting',
                'total'                    => 'Totaal',
                'update-cart'              => 'Winkelwagen bijwerken',
                'view-cart'                => 'Bekijk winkelwagen',

                'cross-sell' => [
                    'title' => 'Meer keuzes',
                ],
            ],

            'mini-cart' => [
                'continue-to-checkout' => 'Ga verder naar afrekenen',
                'empty-cart'           => 'Uw winkelwagen is leeg',
                'excl-tax'             => 'Excl. BTW:',
                'offer-on-orders'      => 'Ontvang tot 30% korting op uw eerste bestelling',
                'remove'               => 'Verwijderen',
                'see-details'          => 'Details bekijken',
                'shopping-cart'        => 'Winkelwagen',
                'subtotal'             => 'Subtotaal',
                'view-cart'            => 'Bekijk winkelwagen',
            ],

            'summary' => [
                'cart-summary'              => 'Winkelwagenoverzicht',
                'delivery-charges-excl-tax' => 'Verzendkosten (Excl. BTW)',
                'delivery-charges-incl-tax' => 'Verzendkosten (Incl. BTW)',
                'delivery-charges'          => 'Verzendkosten',
                'discount-amount'           => 'Korting',
                'grand-total'               => 'Totaalbedrag',
                'place-order'               => 'Bestelling plaatsen',
                'proceed-to-checkout'       => 'Doorgaan naar afrekenen',
                'sub-total-excl-tax'        => 'Subtotaal (Excl. BTW)',
                'sub-total-incl-tax'        => 'Subtotaal (Incl. BTW)',
                'sub-total'                 => 'Subtotaal',
                'tax'                       => 'Belasting',

                'estimate-shipping' => [
                    'country'        => 'Land',
                    'info'           => 'Voer uw bestemming in om een schatting te krijgen van de verzend- en belastingkosten.',
                    'postcode'       => 'Postcode',
                    'select-country' => 'Selecteer land',
                    'select-state'   => 'Selecteer provincie',
                    'state'          => 'Provincie',
                    'title'          => 'Verzend- en belastingkosten schatten',
                ],
            ],
        ],

        'onepage' => [
            'address' => [
                'add-new'                => 'Nieuw adres toevoegen',
                'add-new-address'        => 'Nieuw adres toevoegen',
                'back'                   => 'Terug',
                'billing-address'        => 'Factuuradres',
                'check-billing-address'  => 'Factuuradres ontbreekt.',
                'check-shipping-address' => 'Verzendadres ontbreekt.',
                'city'                   => 'Stad',
                'company-name'           => 'Bedrijfsnaam',
                'confirm'                => 'Bevestigen',
                'country'                => 'Land',
                'email'                  => 'E-mail',
                'first-name'             => 'Voornaam',
                'last-name'              => 'Achternaam',
                'postcode'               => 'Postcode',
                'proceed'                => 'Ga verder',
                'same-as-billing'        => 'Gelijk adres gebruiken voor verzending?',
                'save'                   => 'Opslaan',
                'save-address'           => 'Opslaan in adresboek',
                'select-country'         => 'Selecteer land',
                'select-state'           => 'Selecteer provincie',
                'shipping-address'       => 'Verzendadres',
                'state'                  => 'Provincie',
                'street-address'         => 'Straatadres',
                'telephone'              => 'Telefoon',
                'title'                  => 'Adres',
            ],

            'index' => [
                'checkout' => 'Afrekenen',
                'home'     => 'Home',
            ],

            'payment' => [
                'payment-method' => 'Betalingsmethode',
            ],

            'shipping' => [
                'shipping-method' => 'Verzendmethode',
            ],

            'summary' => [
                'cart-summary'              => 'Winkelwagenoverzicht',
                'delivery-charges-excl-tax' => 'Verzendkosten (Excl. BTW)',
                'delivery-charges-incl-tax' => 'Verzendkosten (Incl. BTW)',
                'delivery-charges'          => 'Verzendkosten',
                'discount-amount'           => 'Kortingbedrag',
                'excl-tax'                  => 'Excl. BTW:',
                'grand-total'               => 'Totaalbedrag',
                'place-order'               => 'Bestelling plaatsen',
                'price_&_qty'               => ':price × :qty',
                'processing'                => 'Verwerken',
                'sub-total-excl-tax'        => 'Subtotaal (Excl. BTW)',
                'sub-total-incl-tax'        => 'Subtotaal (Incl. BTW)',
                'sub-total'                 => 'Subtotaal',
                'tax'                       => 'Belasting',
            ],
        ],

        'coupon' => [
            'already-applied' => 'Couponcode is al toegepast.',
            'applied'         => 'Coupon toegepast',
            'apply'           => 'Coupon toepassen',
            'apply-issue'     => 'Couponcode kan niet worden toegepast.',
            'button-title'    => 'Toepassen',
            'code'            => 'Couponcode',
            'discount'        => 'Kortingsbon',
            'enter-your-code' => 'Voer uw code in',
            'error'           => 'Er is iets misgegaan',
            'invalid'         => 'Couponcode is ongeldig.',
            'remove'          => 'Coupon verwijderen',
            'subtotal'        => 'Subtotaal',
            'success-apply'   => 'Couponcode succesvol toegepast.',
        ],

        'login' => [
            'email'    => 'E-mail',
            'password' => 'Wachtwoord',
            'title'    => 'Inloggen',
        ],
    ],

    'home' => [
        'contact' => [
            'about'         => 'Stuur ons een bericht en we zullen zo snel mogelijk reageren',
            'desc'          => 'Waar denk je aan?',
            'describe-here' => 'Beschrijf hier',
            'email'         => 'E-mail',
            'message'       => 'Bericht',
            'name'          => 'Naam',
            'phone-number'  => 'Telefoonnummer',
            'submit'        => 'Verzenden',
            'title'         => 'Neem contact met ons op',
        ],

        'index' => [
            'offer'               => 'Krijg TOT 40% KORTING op je 1e bestelling - WINKEL NU',
            'resend-verify-email' => 'Verificatie-e-mail opnieuw verzenden',
            'verify-email'        => 'Verifieer je e-mailaccount',
        ],

        'thanks-for-contact' => 'Bedankt voor het contact met ons opnemen met uw opmerkingen en vragen. We zullen spoedig reageren.',
    ],

    'partials' => [
        'pagination' => [
            'pagination-showing' => 'Toont :firstItem tot :lastItem van de :total vermeldingen',
        ],
    ],

    'errors' => [
        'go-to-home' => 'Ga naar de startpagina',

        '404' => [
            'description' => 'Oeps! De pagina die je zoekt, is met vakantie. Het lijkt erop dat we niet hebben gevonden wat je zocht.',
            'title'       => '404 Pagina niet gevonden',
        ],

        '401' => [
            'description' => 'Oeps! Het lijkt erop dat je geen toegang hebt tot deze pagina. Het lijkt erop dat je de benodigde referenties mist.',
            'title'       => '401 Onbevoegd',
        ],

        '403' => [
            'description' => 'Oeps! Deze pagina is verboden terrein. Het lijkt erop dat je niet over de vereiste rechten beschikt om deze inhoud te bekijken.',
            'title'       => '403 Verboden',
        ],

        '500' => [
            'description' => 'Oeps! Er is iets misgegaan. Het lijkt erop dat we problemen hebben met het laden van de pagina die je zoekt.',
            'title'       => '500 Interne serverfout',
        ],

        '503' => [
            'description' => 'Oeps! Het lijkt erop dat we tijdelijk offline zijn voor onderhoud. Kom later terug.',
            'title'       => '503 Service Niet Beschikbaar',
        ],
    ],

    'layouts' => [
        'address'               => 'Adres',
        'downloadable-products' => 'Downloadbare Producten',
        'my-account'            => 'Mijn Account',
        'orders'                => 'Bestellingen',
        'profile'               => 'Profiel',
        'reviews'               => 'Beoordelingen',
        'wishlist'              => 'Verlanglijst',
    ],

    'subscription' => [
        'already'             => 'Je bent al geabonneerd op onze nieuwsbrief.',
        'subscribe-success'   => 'Je bent succesvol geabonneerd op onze nieuwsbrief.',
        'unsubscribe-success' => 'Je hebt je succesvol afgemeld voor onze nieuwsbrief.',
    ],

    'emails' => [
        'dear'   => 'Beste :customer_name',
        'thanks' => 'Als je hulp nodig hebt, neem dan contact met ons op via <a href=":link" style=":style">:email</a>.<br/>Bedankt!',

        'customers' => [
            'registration' => [
                'credentials-description' => 'Uw account is aangemaakt. Uw accountgegevens staan hieronder:',
                'description'             => 'Je account is nu succesvol aangemaakt en je kunt inloggen met je e-mailadres en wachtwoord. Na het inloggen kun je andere diensten gebruiken, waaronder het bekijken van eerdere bestellingen, verlanglijstjes en het bewerken van je accountgegevens.',
                'greeting'                => 'Welkom en bedankt voor je registratie bij ons!',
                'password'                => 'Wachtwoord',
                'sign-in'                 => 'Inloggen',
                'subject'                 => 'Nieuwe Klantregistratie',
                'username-email'          => 'Gebruikersnaam/E-mail',
            ],

            'forgot-password' => [
                'description'    => 'Je ontvangt deze e-mail omdat we een verzoek hebben ontvangen om je wachtwoord opnieuw in te stellen voor je account.',
                'greeting'       => 'Wachtwoord vergeten!',
                'reset-password' => 'Wachtwoord opnieuw instellen',
                'subject'        => 'E-mail voor het opnieuw instellen van het wachtwoord',
            ],

            'update-password' => [
                'description' => 'Je ontvangt deze e-mail omdat je je wachtwoord hebt bijgewerkt.',
                'greeting'    => 'Wachtwoord bijgewerkt!',
                'subject'     => 'Wachtwoord bijgewerkt',
            ],

            'verification' => [
                'description'  => 'Klik op de onderstaande knop om je e-mailadres te verifiëren.',
                'greeting'     => 'Welkom!',
                'subject'      => 'E-mail voor accountverificatie',
                'verify-email' => 'E-mailadres verifiëren',
            ],

            'commented' => [
                'description' => 'Opmerking is - :note',
                'subject'     => 'Nieuwe opmerking toegevoegd',
            ],

            'subscribed' => [
                'description' => 'Gefeliciteerd en welkom bij onze nieuwsbriefgemeenschap! We zijn blij dat je meedoet en je op de hoogte houden van het laatste nieuws, trends en exclusieve aanbiedingen.',
                'greeting'    => 'Welkom bij onze nieuwsbrief!',
                'subject'     => 'Je! Abonneer je op onze nieuwsbrief',
                'unsubscribe' => 'Afmelden',
            ],
        ],

        'contact-us' => [
            'contact-from'    => 'via het contactformulier op de website',
            'reply-to-mail'   => 'antwoord alstublieft op deze e-mail.',
            'reach-via-phone' => 'U kunt ons ook telefonisch bereiken op',
            'inquiry-from'    => 'Vraag van',
            'to'              => 'Om contact op te nemen met',
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Bedankt voor je bestelling :order_id geplaatst op :created_at',
                'subject'  => 'Nieuwe Bestelbevestiging',
                'summary'  => 'Samenvatting van Bestelling',
                'title'    => 'Bestelbevestiging!',
            ],

            'invoiced' => [
                'greeting' => 'Je factuur #:invoice_id voor bestelling :order_id gemaakt op :created_at',
                'subject'  => 'Nieuwe Factuurbevestiging',
                'summary'  => 'Samenvatting van Factuur',
                'title'    => 'Factuurbevestiging!',
            ],

            'shipped' => [
                'greeting' => 'Je bestelling :order_id geplaatst op :created_at is verzonden',
                'subject'  => 'Nieuwe Verzendingsbevestiging',
                'summary'  => 'Samenvatting van Verzending',
                'title'    => 'Bestelling Verzonden!',
            ],

            'refunded' => [
                'greeting' => 'Terugbetaling is gestart voor bestelling :order_id geplaatst op :created_at',
                'subject'  => 'Nieuwe Terugbetalingsbevestiging',
                'summary'  => 'Samenvatting van Terugbetaling',
                'title'    => 'Bestelling Terugbetaald!',
            ],

            'canceled' => [
                'greeting' => 'Je bestelling :order_id geplaatst op :created_at is geannuleerd',
                'subject'  => 'Nieuwe Bestellingsannuleringsbevestiging',
                'summary'  => 'Samenvatting van Bestelling',
                'title'    => 'Bestelling Geannuleerd!',
            ],

            'commented' => [
                'subject' => 'Nieuwe opmerking toegevoegd',
                'title'   => 'Nieuwe opmerking toegevoegd aan je bestelling :order_id geplaatst op :created_at',
            ],

            'billing-address'            => 'Factuuradres',
            'carrier'                    => 'Vervoerder',
            'contact'                    => 'Contact',
            'discount'                   => 'Korting',
            'excl-tax'                   => 'Excl. BTW: ',
            'grand-total'                => 'Totaalbedrag',
            'name'                       => 'Naam',
            'payment'                    => 'Betaling',
            'price'                      => 'Prijs',
            'qty'                        => 'Aantal',
            'shipping-address'           => 'Verzendadres',
            'shipping-handling-excl-tax' => 'Verzend- en verwerkingskosten (Excl. BTW)',
            'shipping-handling-incl-tax' => 'Verzend- en verwerkingskosten (Incl. BTW)',
            'shipping-handling'          => 'Verzend- en verwerkingskosten',
            'shipping'                   => 'Verzending',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Subtotaal (Excl. BTW)',
            'subtotal-incl-tax'          => 'Subtotaal (Incl. BTW)',
            'subtotal'                   => 'Subtotaal',
            'tax'                        => 'BTW',
            'tracking-number'            => 'Volgnummer: :tracking_number',
        ],
    ],
];
